/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.util.internal;

import java.util.*;

import org.eclipse.hyades.trace.views.internal.*;
import org.eclipse.swt.*;

public class ColumnData {
	
	public final static int IS_VISIBLE 		= 0x00000001;
	public final static int NONDELETABLE		= 0x00000002;
	public final static int NONMOVABLE		= 0x00000004;
	public final static int NONRESIZABLE		= 0x00000008;
	public final static int SUPPORTS_DELTA 	= 0x00000010;
	
	private String _name;
	private int _style = 0;
	private int _width = 20;
	private int _alignment;
	private int _initialPos=0;
		
	public ColumnData(String name, int initialPos, int style, int alignment, int width) {
		initialize(name, initialPos, style, alignment, width);		
	}
	
	private void initialize(String name, int initialPos, int style, int alignment, int width) {
		_name = name;
		_initialPos = initialPos;
		_style = style;
		_width = width;
		_alignment = alignment;
	}

	   /**
     * createColumnData creates an ArrayList of ColumnData information from
     * the data stored in the preferences store.
     * The data in the preferences store is stored as a series of column definitions
     * separated by commas.  For a description of an individual column definition, see
     * addColumnData.
     * @param String the key to extract the column definition string from the preferences
     * store.
     */
	public static ArrayList createColumnData(String preferenceKey, String defaultColumns) {
		String preferenceColumns = TraceUIPlugin.getDefault().getPreferenceStore().getString(preferenceKey);
		if (preferenceColumns == null || preferenceColumns.length() == 0) {
			preferenceColumns = defaultColumns;
		}
	    return createColumnDataFromString(preferenceColumns);
	}
	
	public static ArrayList createColumnDataFromString(String preferenceColumns) {
		
		ArrayList columnDataList = new ArrayList();
			
		if (preferenceColumns != null && !preferenceColumns.equals("")) {
/*			
			// Walk the data and count how many columns the table should have
			// and then allocate the column ArrayList using that size.			
			int count = 1;
			for (int i = preferenceColumns.indexOf(","); i != -1; i = preferenceColumns.indexOf(",",i+1)) {
				count++;
			}
			columnDataList = new ArrayList(count);
*/			
			// Walk the data again parsing each column data template and adding it
			// to the column data array list.
			int idx = 0;
			String columnDataTemplate;
			while (idx != -1) {
				idx = preferenceColumns.indexOf(",");
				
				if (idx != -1) {
					// For all but the last column definition
					columnDataTemplate = preferenceColumns.substring(0, idx);
					preferenceColumns = preferenceColumns.substring(idx + 1);
				}
				else {
					// For the last column definition.
					columnDataTemplate = preferenceColumns;
				}
				addColumnData(columnDataTemplate, columnDataList);
			}
		}
		return columnDataList;
	}
		/**
	 * addColumnData parses a single column definition and adds the defintion
	 * to the ColumnData array list.
	 * @param column java.lang.String containing the column template information
	 * The column template consists of the column name followed by a : followed by the
	 * visiblity flag true or false, followed by a :, followed by an integer
	 * representing the width of the column.
	 * @param ArrayList containing the ColumnData created from the template
	 */
	private static void addColumnData(String columnTemplate, ArrayList list) {

		String columnName = "";
		int style = 0;
		int width = 0;
		int alignment = SWT.LEFT;		
		int initialPos = 0;
		
		// Parse off the column name.
		int idx = columnTemplate.indexOf(":");
		if (idx != -1) {
			columnName = columnTemplate.substring(0, idx);
			columnTemplate = columnTemplate.substring(idx + 1);
		}
		
		// Parse off the initial position; used by the LabelProvider
		idx = columnTemplate.indexOf(":");
		if (idx != -1) {
			initialPos = Integer.parseInt(columnTemplate.substring(0, idx));	
			columnTemplate = columnTemplate.substring(idx + 1);
		}
		
		// Parse off the style flags
		idx = columnTemplate.indexOf(":");
		if (idx != -1) {
			style = Integer.parseInt(columnTemplate.substring(0, idx));	
			columnTemplate = columnTemplate.substring(idx + 1);
		}
       
		// Parse off the alignment
		idx = columnTemplate.indexOf(":");
		if (idx != -1) {
			alignment = columnTemplate.substring(0, idx).equals("left") ? SWT.LEFT : SWT.RIGHT;
			columnTemplate = columnTemplate.substring(idx + 1);
		}
		// Parse off the width
		width = Integer.parseInt(columnTemplate);
		
		list.add(new ColumnData(columnName, initialPos, style, alignment, width));
	}
	/**
	 * setColumns saves a new set of ColumnData from the newList to the currentList and
	 * then serializes the data and persists it to the preferences store.
	 *
	 * @param java.util.ArrayList newList is the new ColumnData information
	 * @param java.util.ArrayList currentList is the current ColumnData information
	 * @param java.lang.String preferenceKey is the key to store the serialized data in the
	 * preferences store.
	 */
	public static void setColumns(ArrayList newList, ArrayList currentList, String preferenceKey) {
		// Replace the current list data with the new list data
		currentList.clear();
		currentList.addAll(newList);
		setColumns(currentList, preferenceKey);
	}
	
	public static void setColumns(ArrayList currentList, String preferenceKey) {
		String columnName = "";
		int width;
		String alignment;
		String elementClassName;
		int deltaWidth = 0;
		
		// Create the column data template string to save in the preferences store
		String columns = "";
		for (int i = 0; i < currentList.size(); i++) {
			ColumnData columnData = (ColumnData)currentList.get(i);
			columnName = columnData.name();
				
			width = columnData.width();
			alignment = columnData.getAlignment() == SWT.LEFT ? "left" : "right";
	
			columns = columns + "," + columnName + ":"+ columnData.getInitalPos()
			          + ":" + columnData.getStyle()
			          + ":" + alignment + ":" 
					  + width;
		}
		if (columns.startsWith(",") && columns.length() > 1)
			columns = columns.substring(1);

		// Save the column data template into the preferences.
		TraceUIPlugin.getDefault().getPreferenceStore().setValue(preferenceKey, columns);
	}
		
	/**
	 * Insert the method's description here.
	 * Creation date: (3/8/2001 2:14:41 PM)
	 * @return java.lang.String
	 */
	public String name() {
		return _name;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (3/8/2001 2:15:04 PM)
	 * @param name java.lang.String
	 */
	public void name(String name) {
		_name = name;
	}
	
	public boolean isNonDeletable() {
		return (_style & ColumnData.NONDELETABLE) != 0;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (3/13/2001 1:18:01 PM)
	 * @return java.lang.String
	 */
//	public String toString() {
//		return _name + ", " + _width + ", " + _visible;
//	}
	/**
	 * Insert the method's description here.
	 * Creation date: (3/8/2001 2:16:16 PM)
	 * @return boolean
	 */
	public boolean visible() {
		return (_style & ColumnData.IS_VISIBLE) != 0;
	}
	
	public int getAlignment() {
		return _alignment;
	}
	public int getStyle() {
		return _style;
	}
	public boolean isResizable() {
		return (_style & ColumnData.NONRESIZABLE) == 0;
	}
	public boolean isMovable() {
		return (_style & ColumnData.NONMOVABLE) == 0;
	}
	
	public boolean supportsDelta() {
		return (_style & ColumnData.SUPPORTS_DELTA) != 0;
	}
	
	/**
	 * Insert the method's description here.
	 * Creation date: (3/8/2001 2:17:16 PM)
	 * @return int
	 */
	public int width() {
		return _width;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (3/8/2001 2:16:41 PM)
	 * @param width int
	 */
	public void width(int width) {
		_width = width;
	}
	
	public int getInitalPos()
	{
		return _initialPos;
	}
}