/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui;

import org.eclipse.hyades.ui.internal.util.ImageManager;

/**
 * Image manager for the Hyades UI plugin.
 *  
 * @author marcelop
 * @author popescu
 * @since 0.0.1
 */
public class HyadesUIImages
extends ImageManager
{
	/**
	 * HyadesUIImages' singleton.
	 */
	public static final HyadesUIImages INSTANCE = new HyadesUIImages();
	
	/*
	 * Available cached Images in the Java plugin image registry.
	 */
	public static final String IMG_FILTER_LOG_AGENT 	= "agent_log_obj.gif";
	public static final String IMG_FILTER_PROF_AGENT 	= "agent_prof_obj.gif";
	public static final String IMG_UI_MONITOR    		= "monitor_obj.gif";
	public static final String IMG_UI_NODE       		= "node_obj.gif";
	public static final String IMG_UI_PROCESS    		= "process_obj.gif";
	
	/**
	 * @see org.eclipse.hyades.ui.util.ImageManager#addImages()
	 */
	protected void addImages()
	{
		add(T_OBJ,IMG_FILTER_PROF_AGENT);
		add(T_OBJ,IMG_FILTER_LOG_AGENT);
		add(T_OBJ,IMG_UI_MONITOR);
		add(T_OBJ,IMG_UI_NODE);   
		add(T_OBJ,IMG_UI_PROCESS);		
	}	
}
