/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.internal.navigator.action;

import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.help.WorkbenchHelp;

import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.util.ContextIds;
import org.eclipse.hyades.ui.util.IDisposable;

/**
 * Superclass of all actions to be added to the navigator.
 * 
 * <p>This implementation is based on the 
 * {@link org.eclipse.ui.views.navigator.ResourceNavigatorAction} class.
 * 
 * @author marcelop
 * @since 0.0.1
 */
public class NavigatorAction 
extends SelectionProviderAction implements IDisposable
{
	private INavigator navigator;

	/**
	 * Constructor for NavigatorAction
	 * @param navigator
	 * @param label
	 */
	public NavigatorAction(INavigator navigator,	String label)
	{
		super(navigator.getViewer(), label);
		this.navigator = navigator;
		WorkbenchHelp.setHelp(this, HyadesUIPlugin.getID() + ContextIds.ACT_NAVIGATOR);				
		
	}

	/**
	 * @see org.eclipse.ui.actions.SelectionProviderAction#dispose()
	 */
	public void dispose()
	{
		navigator = null;
		super.dispose();
	}

	/**
	 * Returns the navigator for which this action was created.
	 */
	public INavigator getNavigator()
	{
		return navigator;
	}
	
	/**
	 * Returns <code>true</code> if this action is valid for the current
	 * selection or <code>false</code> otherwise.
	 * @return boolean
	 */
	public boolean isApplicableForSelection()
	{
		return true;
	}	
}
