/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions;

import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.action.Action;

/**
 * @author sveyrier
 *
 */
public class FilterInternalMessages extends Action {

	private SDView view = null;
	
	public FilterInternalMessages(SDView theView)
	{
		super(SDViewerPlugin.getResourceString("ACTION_FILTER_INT_NAME"),AS_CHECK_BOX); //$NON-NLS-1$
		view = theView;
		setToolTipText(SDViewerPlugin.getResourceString("ACTION_FILTER_INT_DESCRIPTION")); //$NON-NLS-1$
		setId("org.eclipse.hyades.uml2sd.ui.filterinternalmesssage"); //$NON-NLS-1$
		setImageDescriptor(SDViewerPlugin.getResourceImage("filter_obj.gif")); //$NON-NLS-1$
	}
	
	public void run()
	{
		if ((view==null)||(view.getSDWidget())==null)
			return;
		if (view.getInternalMessageFilterProvider()!= null)
			view.getInternalMessageFilterProvider().setFiltered(isChecked());
		view.getSDWidget().redraw();
	}

}
