/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions;

import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.action.Action;

/**
 * @author sveyrier
 *
 */
public class PrevPage extends Action{
	
	private SDView view = null;
	
	public PrevPage(SDView theView)
	{
		super();
		view = theView;
		setText(SDViewerPlugin.getResourceString("COOLBAR_PREV_PAGE")); //$NON-NLS-1$
		setToolTipText(SDViewerPlugin.getResourceString("COOLBAR_PREV_PAGE_TOOLTIP")); //$NON-NLS-1$
		setId("org.eclipse.hyades.uml2sd.ui.prevpage"); //$NON-NLS-1$
		setImageDescriptor(SDViewerPlugin.getResourceImage("prev_nav.gif")); //$NON-NLS-1$
	}

	public void run()
	{
		if ((view==null)||(view.getSDWidget())==null)
			return;
		if (view.getSDPagingProvider()!=null)
			view.getSDPagingProvider().prevPage();
		view.updateCoolBar();
		view.getSDWidget().redraw();
	}
}
