/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions;


import java.net.URL;

import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.hyades.uml2sd.ui.view.SDWidget;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

/**
 * @author sveyrier
 *
 */
public class Zoom implements IViewActionDelegate{

	protected SDWidget viewer = null;
	protected SDView view = null;
	protected boolean lastZoomIn = false;
	protected boolean lastZoomOut = false;
	
	private static Cursor zoomIn = null;
	private static Cursor zoomOut = null;

	public void init (IViewPart _view)
	{
		view = (SDView)_view;
		if (view instanceof SDView)
			viewer = ((SDView)view).getSDWidget();
		if ((zoomIn != null)&&(!zoomIn.isDisposed()))
			zoomIn.dispose();
		if ((zoomOut != null)&&(!zoomOut.isDisposed()))
			zoomOut.dispose();
		zoomIn = new Cursor(Display.getCurrent(), getImageData("zoomin_source.bmp").getImageData(), //$NON-NLS-1$
					getImageData("zoom_mask.bmp").getImageData(),0,0);  //$NON-NLS-1$
		zoomOut = new Cursor(Display.getCurrent(), getImageData("zoomout_source.bmp").getImageData(),//$NON-NLS-1$
					getImageData("zoom_mask.bmp").getImageData(),0,0);//$NON-NLS-1$
	}

	public void run (IAction action)
	{
		
		if (action.getId().equals("org.eclipse.hyades.uml2sd.ui.actions.ZoomOutCoolBar")) //$NON-NLS-1$
		{
			//Eclipse 3.0 M7 workaround 
			if (lastZoomOut==action.isChecked())
				action.setChecked(!action.isChecked());
			viewer.setZoomOutMode(action.isChecked());
			lastZoomOut = action.isChecked();
			if (action.isChecked())
				viewer.setCursor(zoomOut);
			else viewer.setCursor(new Cursor(Display.getDefault(),SWT.CURSOR_ARROW));
		}
		else if (action.getId().equals("org.eclipse.hyades.uml2sd.ui.actions.ZoomInCoolBar")) //$NON-NLS-1$
		{
			//Eclipse 3.0 M7 workaround 
			if (lastZoomIn==action.isChecked())
				action.setChecked(!action.isChecked());
			viewer.setZoomInMode(action.isChecked());
			lastZoomIn = action.isChecked();
			if (action.isChecked())
				viewer.setCursor(zoomIn);
			else viewer.setCursor(new Cursor(Display.getDefault(),SWT.CURSOR_ARROW));
		}
		else if (action.getId().equals("org.eclipse.hyades.uml2sd.ui.actions.ResetZoom")) //$NON-NLS-1$
		{
			viewer.resetZoomFactor();
			//The reset action is a radio button only to uncheck the zoomin and out button
			//when it is clicked. This avoid adding code to do it manually
			//We only have to force it to false every time
			action.setChecked(false);
		}
	}
	

	public void selectionChanged(IAction action, ISelection selection)
	{		
	}
	
	private static URL BASIC_URL=null;
	static
	{
		//URL to get images from plugins
		//perhaps we can found better code to load images ...
		//but at this time I know this: 
		try {
		BASIC_URL = new URL( "platform", "localhost", "plugin");//$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		} catch( Exception E ) {
			System.err.println(E);
		}
	}
   
	public ImageDescriptor getImageData( String _name )
	{
		try {
		 URL url=new URL( BASIC_URL, "plugin/org.eclipse.hyades.uml2sd.ui/icons/"+ _name);//$NON-NLS-1$
		 ImageDescriptor img = ImageDescriptor.createFromURL( url );
		 return img;
		} catch( Exception E ) {
				System.err.println(E);
				 }
		return null;
	}
}
