/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.core.internal;

import org.eclipse.hyades.uml2sd.ui.core.AsyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.ITimeRange;
import org.eclipse.hyades.uml2sd.ui.core.Metrics;
import org.eclipse.hyades.uml2sd.ui.drawings.IColor;
import org.eclipse.hyades.uml2sd.ui.drawings.IGC;
import org.eclipse.hyades.uml2sd.ui.drawings.ISDPreferences;


public class EllipsisisMessage extends AsyncMessage implements ITimeRange{
	
	public int getX()
	{
		if (startLifeline==null)
			return super.getX()+super.getWidth()-16;
		else return super.getX();
	}
	
	public int getWidth()
	{
		return 16;
	}

	private void drawMessage (IGC context)
	{
		//temporay store the coordinates to avoid more methods calls
		int x = super.getX();
		int y = getY();
		int width = super.getWidth();
		int height = getHeight();
		
		//UML2 found message (always drawn from left to right)
		if (startLifeline ==null && endLifeline != null)
		{
			//Draw the message label above the message and centered
			//The label is truncated if it cannot fit between the two message end
			//2*Metrics.MESSAGES_NAME_SPACING = space above the label + space below the label
			context.drawTextTruncatedCentred(getName(),x , y - Metrics.getMessageFontHeigth() - 2*Metrics.MESSAGES_NAME_SPACING, width ,
											 2*Metrics.MESSAGES_NAME_SPACING + Metrics.getMessageFontHeigth(),!isSelected());

		    int currentStyle = context.getLineStyle();
		    context.setLineStyle(context.getLineSolidStyle());
			//Draw the message main line
			context.drawLine(x+width-5, y, x +width- 6 , y + height);
			context.drawLine(x+width-10, y, x+width- 11 , y + height);
			context.drawLine(x+width-15, y, x+width- 16 , y + height);
		    context.setLineStyle(currentStyle);
				  
			IColor storedColor = context.getBackground();
			context.setBackground(context.getForeground());
			context.setBackground(storedColor);
		}
		//UML2 lost message (always drawn from left to right)
		else if (endLifeline ==null && startLifeline != null)
		{
			//Draw the message label above the message and centered
			//The label is truncated if it cannot fit between the two message end
		    //2*Metrics.MESSAGES_NAME_SPACING = space above the label + space below the label
			context.drawTextTruncatedCentred(getName(),x , y - Metrics.getMessageFontHeigth() - 2*Metrics.MESSAGES_NAME_SPACING, width ,
											 2*Metrics.MESSAGES_NAME_SPACING+Metrics.getMessageFontHeigth(),!isSelected());

			int currentStyle = context.getLineStyle();
			context.setLineStyle(context.getLineSolidStyle());
			//Draw the message main line
			context.drawLine(x+5, y, x + 6 , y + height);
			context.drawLine(x+10, y, x+ 11 , y + height);
			context.drawLine(x+15, y, x+ 16 , y + height);
			context.setLineStyle(currentStyle);			
			
			IColor storedColor = context.getBackground();
			context.setBackground(context.getForeground());
		
			context.setBackground(storedColor);

		}
		else super.draw(context);
	}
	
	public void draw (IGC context)
	{
		if (!isVisible())
			return;
		//Draw it selected?*/
		if (isSelected())
		{
			/*
			 * Draw it twice
			 * First time, bigger inverting selection colors
			 * Second time, regular drawing using selection colors
			 * This create the highlight effect
			 */
			context.setForeground(Frame.getUserPref().getBackGroundColorSelection());
			context.setLineWidth(Metrics.SELECTION_LINE_WIDTH);
			drawMessage(context);
			context.setBackground(Frame.getUserPref().getBackGroundColorSelection());
			context.setForeground(Frame.getUserPref().getForeGroundColorSelection());
			// Second drawing is done after the else
		}
		else 
		{
			context.setBackground(Frame.getUserPref().getBackGroundColor(ISDPreferences.PREF_ASYNC_MESS));
			context.setForeground(Frame.getUserPref().getForeGroundColor(ISDPreferences.PREF_ASYNC_MESS));
		}
		context.setLineWidth(Metrics.NORMAL_LINE_WIDTH);
		drawMessage(context);
	}
	
}
