/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.drawings.impl;

import java.net.URL;

import org.eclipse.hyades.uml2sd.ui.drawings.IImage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

/**
 * @author sveyrier
 *
 */
public class ImageImpl implements IImage{
	
	protected Image img = null;
	
	public ImageImpl(String file)
	{
		img = getResourceImage(file);
	}

	public ImageImpl(Image img_)
	{
		img = img_;
	}

	private static URL BASIC_URL=null;
	static
	{
		//URL to get images from plugins
		//perhaps we can found better code to load images ...
		//but at this time I know this: 
		try {
		BASIC_URL = new URL( "platform", "localhost", "plugin");//$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		} catch( Exception E ) {
			System.err.println(E);
		}
	}
	   
	public Image getResourceImage( String _name )
	{
		try {
		 URL url=new URL( BASIC_URL, "plugin/org.eclipse.hyades.uml2sd.ui/icons/"+ _name);//$NON-NLS-1$
		 ImageDescriptor img = ImageDescriptor.createFromURL( url );
		return img.createImage() ;
		} catch( Exception E ) {
					 System.err.println(E);
				 }
		return null;
	}
	
	public Object getImage()
	{
		return img;
	}
	
	public void dispose()
	{
		if (img!= null)
		img.dispose();
	}
}
