package org.eclipse.hyades.logging.events.cbe;

import java.io.Serializable;

import org.eclipse.emf.ecore.EObject;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Msg Catalog Token</b></em>'.
 * <P>
 * A string used as substitution value for resolving an internationalized 
 * message into formatted text.  
 * </P>
 * 
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0.1
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.MsgCatalogToken#getValue <em>Value</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getMsgCatalogToken()
 * @model 
 * @generated
 */
public interface MsgCatalogToken extends EObject, Serializable {
    /**
     * <p>
     * Returns the value of the '<em><b>Value</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Value</em>' attribute.
     * @see #setValue(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getMsgCatalogToken_Value()
     * @model required="true"
     * @generated
     */
    String getValue();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.MsgCatalogToken#getValue <em>Value</em>}' attribute.
     * <!-- begin-user-doc -->
     * <P>
     * The string length for value <em>must not</em> exceed 256 characters.
     * </P>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Value</em>' attribute.
     * @see #getValue()
     * @generated
     */
    void setValue(String value);

    /**
     * <p>
     * Checks whether the contents of the instance conform to the
     * CBE specification.
     * </p>
     *
     * @throws ValidationException 
     *                       if the message catalog token does not follow the 
     *                       CBE specification.
     */
    void validate() throws ValidationException;

	/**
	 * Resets the object's properties to their initial (e.g. null) state.
	 * 
	 * All components are initialized to either zero or null.
	 * 
	 * @since 1.0
	 */
	void init();
} // MsgCatalogToken
