package org.eclipse.hyades.logging.events.cbe.impl.tests;

import junit.framework.TestCase;

import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Tests whether EMF produce the CBE s correctly.
 * 
 * @author Denilson Nastacio
 * @author Scott Brown
 * @version 1.0.1
 * @since 1.0.1
 */
public class ComponentIdentificationImplTest extends TestCase {
    /**
     * Constructor for ComponentIdentificationImplTest.
     * @param testcase
     */
    public ComponentIdentificationImplTest(String testcase) {
        super(testcase);
    }

    /**
     * Tests whether the <code>ComponentIdentification</code> has been 
     * properly generated. 
     */
    public void testGeneration() throws Exception {
        ComponentIdentification ci = Util.generateComponentIdentification();
    }

    /**
     * Tests the serialization for the <code>ComponentIdentification</code> 
     * class. 
     */
    public void testSerialization() throws Exception {
        ComponentIdentification ci = Util.generateComponentIdentification();
        Util.testSerialization(ci);
    }

    /**
     * Tests whether the <code>ComponentIdentification</code> checks for 
     * required properties. 
     */
    public void testValidationRequired() throws Exception {
        ComponentIdentification ci = Util.generateComponentIdentification();

        // Checking whether validate accepts completely filled        
        ci.validate();

        ci.setComponent(null);
        Util.assertMissingAttributes(ci, "component");

        ci = Util.generateComponentIdentification();
        ci.setComponentIdType(null);
        Util.assertMissingAttributes(ci, "componentIdType");

        ci = Util.generateComponentIdentification();
        ci.setSubComponent(null);
        Util.assertMissingAttributes(ci, "subComponent");

        ci = Util.generateComponentIdentification();
        ci.setComponentIdType(null);
        Util.assertMissingAttributes(ci, "componentIdType");

        ci = Util.generateComponentIdentification();
        ci.setLocation(null);
        Util.assertMissingAttributes(ci, "location");

        ci = Util.generateComponentIdentification();
        ci.setLocationType(null);
        Util.assertMissingAttributes(ci, "locationType");
    }

    /**
     * Tests whether the <code>ComponentIdentification</code> checks for 
     * required boundaries. 
     */
    public void testValidationBoundaries() throws Exception {
        ComponentIdentification ci = Util.generateComponentIdentification();

        // Testing atttibutes at their boundaries 
        ci.validate();
        ci.setApplication(Util.getPaddedString(256));
        ci.setComponent(Util.getPaddedString(256));
        ci.setSubComponent(Util.getPaddedString(512));
        ci.setComponentIdType(Util.getPaddedString(32));
        ci.setExecutionEnvironment(Util.getPaddedString(256));
        ci.setInstanceId(Util.getPaddedString(128));
        ci.setLocation(Util.getPaddedString(128));
        ci.setProcessId(Util.getPaddedString(64));
        ci.setThreadId(Util.getPaddedString(64));
        ci.validate();

        ci = Util.generateComponentIdentification();
        ci.setApplication(Util.getPaddedString(257));
        Util.assertInvalidBoundaries(ci, "application");

        ci = Util.generateComponentIdentification();
        ci.setComponent(Util.getPaddedString(257));
        Util.assertInvalidBoundaries(ci, "component");

        ci = Util.generateComponentIdentification();
        ci.setSubComponent(Util.getPaddedString(513));
        Util.assertInvalidBoundaries(ci, "subComponent");

        ci = Util.generateComponentIdentification();
        ci.setComponentIdType(Util.getPaddedString(33));
        Util.assertInvalidBoundaries(ci, "componentIdType");

        ci = Util.generateComponentIdentification();
        ci.setExecutionEnvironment(Util.getPaddedString(257));
        Util.assertInvalidBoundaries(ci, "executionEnvironment");

        ci = Util.generateComponentIdentification();
        ci.setInstanceId(Util.getPaddedString(129));
        Util.assertInvalidBoundaries(ci, "instanceId");

        ci = Util.generateComponentIdentification();
        ci.setLocation(Util.getPaddedString(257));
        Util.assertInvalidBoundaries(ci, "location");

        ci = Util.generateComponentIdentification();
        ci.setLocationType(Util.getPaddedString(33));
        Util.assertInvalidBoundaries(ci, "locationType");

        ci = Util.generateComponentIdentification();
        ci.setProcessId(Util.getPaddedString(65));
        Util.assertInvalidBoundaries(ci, "processId");

        ci = Util.generateComponentIdentification();
        ci.setThreadId(Util.getPaddedString(65));
        Util.assertInvalidBoundaries(ci, "threadId");
    }

}
