package org.eclipse.hyades.logging.events.cbe.tests;

import java.io.Serializable;

import junit.framework.TestCase;

import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.CompletionException;
import org.eclipse.hyades.logging.events.cbe.ContentHandler;
import org.eclipse.hyades.logging.events.cbe.EventException;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.EventFactoryFactory;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * JUnit test case for <code>EventFactoryFactory</code>.
 * 
 * @author Denilson Nastacio
 * @version 1.0.1 
 * @since 1.0.1 
 */
public class EventFactoryFactoryTest extends TestCase {

    /**
     * Constructor for EventFactoryFactoryTest.
     * @param arg0
     */
    public EventFactoryFactoryTest(String arg0) {
        super(arg0);
    }

    /**
     *
     */
    public void testCreateEventFactory() {
        EventFactory ef = EventFactoryFactory.createEventFactory();
        ef.createCommonBaseEvent();
    }

    /**
     *
     */
    public void testCreateEventFactoryWithHandler() throws EventException {
        final String EXTENSION_NAME = "Example";
        ContentHandler mockHandler = new MockHandler(EXTENSION_NAME);
        EventFactory ef = EventFactoryFactory.createEventFactory(mockHandler);
        CommonBaseEvent cbe = ef.createCommonBaseEvent();
        cbe.complete();
        assertNotNull(cbe.getExtensionName());
        assertEquals(EXTENSION_NAME, cbe.getExtensionName());
    }

    /**
     * 
     */
    public class MockHandler implements ContentHandler, Serializable {
        private String extensionName;

        public MockHandler(String name) {
            extensionName = name;
        }
        public void completeEvent(CommonBaseEvent event) throws CompletionException {
            event.setExtensionName(extensionName);
        }
    }

}
