/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.common;

import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFTimedEvent;
import org.eclipse.hyades.models.common.testprofile.impl.Common_TestprofileFactoryImpl;

/**
 * @author akmathur
 *
 * This is the TPFTimedEvent loader.
 */
public class XMLtimedEventLoader extends XMLexecutionEventLoader {
	
	protected final static String EVENT_TIMED_END_TIMESTAMP = "endTimestamp";
	protected long endTimestamp = -1;
		
	/**
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#initialize(org.eclipse.hyades.loaders.util.HierarchyContext, java.lang.String)
	 */
	public void initialize(HierarchyContext context, String name) {
		super.initialize(context, name);
		endTimestamp = -1;
	}
	
	/**
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#addAttribute(java.lang.String, java.lang.String)
	 */
	public void addAttribute(String name, String value) {
		printAttribute(name, value);
		switch (LoadersUtils.getHashCode(name)) {
		case ExecutionConstants.EVENT_TIMED_END_TIMESTAMP_int :
			endTimestamp = Long.parseLong(value);
			break;

		default:
			super.addAttribute(name, value);
			break;
		}
	}

	/**
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#addYourselfInContext()
	 */
	public void addYourselfInContext() {
		// Event could have been created by the extended class XMLwaitEventLoader
		TPFTimedEvent event = (TPFTimedEvent) this.event;
		
		// If this is really a timed event, then Create the event
		if (event == null) {
			event = Common_TestprofileFactoryImpl.eINSTANCE.createTPFTimedEvent();
		}
		
		// Now populate the specialized attributes
		event.setEndTimestamp(endTimestamp);
		
		// populate the event with the base event attributes
		this.event = event;
		super.addYourselfInContext();
		super.addYourselfToContainer();
	}
	
	/**
	 * @see org.eclipse.hyades.loaders.common.XMLexecutionEventLoader#overwrite(org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent)
	 */
	protected void overwrite(TPFExecutionEvent match) {
		// Overwrite basic event properties
		super.overwrite(match);
		
		// Overwrite specific event properties
		((TPFTimedEvent) match).setEndTimestamp(((TPFTimedEvent) event).getEndTimestamp());
	}
}
