/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.configuration.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.hyades.models.common.common.CommonPlugin;
import org.eclipse.hyades.models.common.common.impl.CMNNamedElementImpl;
import org.eclipse.hyades.models.common.configuration.CFGCategory;
import org.eclipse.hyades.models.common.configuration.CFGCategorySelectionMode;
import org.eclipse.hyades.models.common.configuration.CFGCategorySelectionMultiplicity;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>CFG Category</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGCategoryImpl#getDisplayName <em>Display Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGCategoryImpl#getSelectionMode <em>Selection Mode</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGCategoryImpl#getSelectionAmount <em>Selection Amount</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGCategoryImpl#getSelectionMultiplicity <em>Selection Multiplicity</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class CFGCategoryImpl extends CMNNamedElementImpl implements CFGCategory{
    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public static final String copyright = "";

    /**
     * The default value of the '{@link #getDisplayName() <em>Display Name</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getDisplayName()
     * @generated
     * @ordered
     */
	protected static final String DISPLAY_NAME_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getDisplayName() <em>Display Name</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getDisplayName()
     * @generated
     * @ordered
     */
	protected String displayName = DISPLAY_NAME_EDEFAULT;

    /**
     * The default value of the '{@link #getSelectionMode() <em>Selection Mode</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getSelectionMode()
     * @generated
     * @ordered
     */
	protected static final CFGCategorySelectionMode SELECTION_MODE_EDEFAULT = CFGCategorySelectionMode.ENTER_VALUE_LITERAL;

    /**
     * The cached value of the '{@link #getSelectionMode() <em>Selection Mode</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getSelectionMode()
     * @generated
     * @ordered
     */
	protected CFGCategorySelectionMode selectionMode = SELECTION_MODE_EDEFAULT;

    /**
     * The default value of the '{@link #getSelectionAmount() <em>Selection Amount</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getSelectionAmount()
     * @generated
     * @ordered
     */
	protected static final int SELECTION_AMOUNT_EDEFAULT = 0;

    /**
     * The cached value of the '{@link #getSelectionAmount() <em>Selection Amount</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getSelectionAmount()
     * @generated
     * @ordered
     */
	protected int selectionAmount = SELECTION_AMOUNT_EDEFAULT;

    /**
     * The default value of the '{@link #getSelectionMultiplicity() <em>Selection Multiplicity</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getSelectionMultiplicity()
     * @generated
     * @ordered
     */
	protected static final CFGCategorySelectionMultiplicity SELECTION_MULTIPLICITY_EDEFAULT = CFGCategorySelectionMultiplicity.ZERO_LITERAL;

    /**
     * The cached value of the '{@link #getSelectionMultiplicity() <em>Selection Multiplicity</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getSelectionMultiplicity()
     * @generated
     * @ordered
     */
	protected CFGCategorySelectionMultiplicity selectionMultiplicity = SELECTION_MULTIPLICITY_EDEFAULT;

	private String internalDisplayName = null;

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected CFGCategoryImpl()
    {
        super();
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected EClass eStaticClass()
    {
        return Common_ConfigurationPackage.eINSTANCE.getCFGCategory();
    }

	public String getDisplayName()
    {
		if(internalDisplayName != null)
			setDisplayName(CommonPlugin.getString(internalDisplayName));
        return getDisplayNameGen();
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public String getDisplayNameGen()
    {
        return displayName;
    }
	
	
    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setDisplayName(String newDisplayName)
    {
        String oldDisplayName = displayName;
        displayName = newDisplayName;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_CATEGORY__DISPLAY_NAME, oldDisplayName, displayName));
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public CFGCategorySelectionMode getSelectionMode()
    {
        return selectionMode;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setSelectionMode(CFGCategorySelectionMode newSelectionMode)
    {
        CFGCategorySelectionMode oldSelectionMode = selectionMode;
        selectionMode = newSelectionMode == null ? SELECTION_MODE_EDEFAULT : newSelectionMode;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_CATEGORY__SELECTION_MODE, oldSelectionMode, selectionMode));
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public int getSelectionAmount()
    {
        return selectionAmount;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setSelectionAmount(int newSelectionAmount)
    {
        int oldSelectionAmount = selectionAmount;
        selectionAmount = newSelectionAmount;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_CATEGORY__SELECTION_AMOUNT, oldSelectionAmount, selectionAmount));
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public CFGCategorySelectionMultiplicity getSelectionMultiplicity()
    {
        return selectionMultiplicity;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setSelectionMultiplicity(CFGCategorySelectionMultiplicity newSelectionMultiplicity)
    {
        CFGCategorySelectionMultiplicity oldSelectionMultiplicity = selectionMultiplicity;
        selectionMultiplicity = newSelectionMultiplicity == null ? SELECTION_MULTIPLICITY_EDEFAULT : newSelectionMultiplicity;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_CATEGORY__SELECTION_MULTIPLICITY, oldSelectionMultiplicity, selectionMultiplicity));
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Object eGet(EStructuralFeature eFeature, boolean resolve)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_ConfigurationPackage.CFG_CATEGORY__ID:
                return getId();
            case Common_ConfigurationPackage.CFG_CATEGORY__DESCRIPTION:
                return getDescription();
            case Common_ConfigurationPackage.CFG_CATEGORY__NAME:
                return getName();
            case Common_ConfigurationPackage.CFG_CATEGORY__DISPLAY_NAME:
                return getDisplayName();
            case Common_ConfigurationPackage.CFG_CATEGORY__SELECTION_MODE:
                return getSelectionMode();
            case Common_ConfigurationPackage.CFG_CATEGORY__SELECTION_AMOUNT:
                return new Integer(getSelectionAmount());
            case Common_ConfigurationPackage.CFG_CATEGORY__SELECTION_MULTIPLICITY:
                return getSelectionMultiplicity();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void eSet(EStructuralFeature eFeature, Object newValue)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_ConfigurationPackage.CFG_CATEGORY__ID:
                setId((String)newValue);
                return;
            case Common_ConfigurationPackage.CFG_CATEGORY__DESCRIPTION:
                setDescription((String)newValue);
                return;
            case Common_ConfigurationPackage.CFG_CATEGORY__NAME:
                setName((String)newValue);
                return;
            case Common_ConfigurationPackage.CFG_CATEGORY__DISPLAY_NAME:
                setDisplayName((String)newValue);
                return;
            case Common_ConfigurationPackage.CFG_CATEGORY__SELECTION_MODE:
                setSelectionMode((CFGCategorySelectionMode)newValue);
                return;
            case Common_ConfigurationPackage.CFG_CATEGORY__SELECTION_AMOUNT:
                setSelectionAmount(((Integer)newValue).intValue());
                return;
            case Common_ConfigurationPackage.CFG_CATEGORY__SELECTION_MULTIPLICITY:
                setSelectionMultiplicity((CFGCategorySelectionMultiplicity)newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void eUnset(EStructuralFeature eFeature)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_ConfigurationPackage.CFG_CATEGORY__ID:
                setId(ID_EDEFAULT);
                return;
            case Common_ConfigurationPackage.CFG_CATEGORY__DESCRIPTION:
                setDescription(DESCRIPTION_EDEFAULT);
                return;
            case Common_ConfigurationPackage.CFG_CATEGORY__NAME:
                setName(NAME_EDEFAULT);
                return;
            case Common_ConfigurationPackage.CFG_CATEGORY__DISPLAY_NAME:
                setDisplayName(DISPLAY_NAME_EDEFAULT);
                return;
            case Common_ConfigurationPackage.CFG_CATEGORY__SELECTION_MODE:
                setSelectionMode(SELECTION_MODE_EDEFAULT);
                return;
            case Common_ConfigurationPackage.CFG_CATEGORY__SELECTION_AMOUNT:
                setSelectionAmount(SELECTION_AMOUNT_EDEFAULT);
                return;
            case Common_ConfigurationPackage.CFG_CATEGORY__SELECTION_MULTIPLICITY:
                setSelectionMultiplicity(SELECTION_MULTIPLICITY_EDEFAULT);
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public boolean eIsSet(EStructuralFeature eFeature)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_ConfigurationPackage.CFG_CATEGORY__ID:
                return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
            case Common_ConfigurationPackage.CFG_CATEGORY__DESCRIPTION:
                return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
            case Common_ConfigurationPackage.CFG_CATEGORY__NAME:
                return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
            case Common_ConfigurationPackage.CFG_CATEGORY__DISPLAY_NAME:
                return DISPLAY_NAME_EDEFAULT == null ? displayName != null : !DISPLAY_NAME_EDEFAULT.equals(displayName);
            case Common_ConfigurationPackage.CFG_CATEGORY__SELECTION_MODE:
                return selectionMode != SELECTION_MODE_EDEFAULT;
            case Common_ConfigurationPackage.CFG_CATEGORY__SELECTION_AMOUNT:
                return selectionAmount != SELECTION_AMOUNT_EDEFAULT;
            case Common_ConfigurationPackage.CFG_CATEGORY__SELECTION_MULTIPLICITY:
                return selectionMultiplicity != SELECTION_MULTIPLICITY_EDEFAULT;
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public String toString()
    {
        if (eIsProxy()) return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (displayName: ");
        result.append(displayName);
        result.append(", selectionMode: ");
        result.append(selectionMode);
        result.append(", selectionAmount: ");
        result.append(selectionAmount);
        result.append(", selectionMultiplicity: ");
        result.append(selectionMultiplicity);
        result.append(')');
        return result.toString();
    }
	
	public void setInternalDisplayName(String displayName)
	{
		this.internalDisplayName = displayName;
	}
	
} //CFGCategoryImpl
