/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.facades.behavioral.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.hyades.models.common.fragments.Common_Behavior_FragmentsPackage;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.util.FileUtil;

/**
 * @author jtoomey
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class FacadeResourceImpl extends XMIResourceImpl {

	private File annotationDir = null;
	
	/**
	 * 
	 */
	public FacadeResourceImpl() {
		super();
	}

	/**
	 * @param arg0
	 */
	public FacadeResourceImpl(URI arg0) {
		super(arg0);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.ecore.resource.impl.ResourceImpl#attached(org.eclipse.emf.ecore.EObject)
	 */
	public void attached(EObject arg0) {
		super.attached(arg0);
				
		if(arg0.eClass().equals(Common_TestprofilePackage.eINSTANCE.getTPFTestSuite()))
		{
			HyadesCommon_TestprofileAdapterFactory adaptorFactory = new HyadesCommon_TestprofileAdapterFactory();
			adaptorFactory.adapt(arg0, Common_TestprofilePackage.eINSTANCE.getTPFTestSuite()); 
		}
		if(arg0.eClass().equals(Common_Behavior_FragmentsPackage.eINSTANCE.getBVRInteraction()))
		{
			HyadesCommon_Behavior_FragmentsAdapterFactory adaptorFactory = new HyadesCommon_Behavior_FragmentsAdapterFactory();
			adaptorFactory.adapt(arg0, Common_Behavior_FragmentsPackage.eINSTANCE.getBVRInteraction()); 
		}
		if(arg0.eClass().equals(Common_Behavior_FragmentsPackage.eINSTANCE.getBVRInteractionOperand()))
		{
			HyadesCommon_Behavior_FragmentsAdapterFactory adaptorFactory = new HyadesCommon_Behavior_FragmentsAdapterFactory();
			adaptorFactory.adapt(arg0, Common_Behavior_FragmentsPackage.eINSTANCE.getBVRInteractionOperand());
		}
		if(arg0.eClass().equals(Common_TestprofilePackage.eINSTANCE.getTPFTestComponent()))
		{
			HyadesCommon_TestprofileAdapterFactory adaptorFactory = new HyadesCommon_TestprofileAdapterFactory();
			adaptorFactory.adapt(arg0, Common_TestprofilePackage.eINSTANCE.getTPFTestComponent()); 
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.ecore.resource.impl.ResourceImpl#detached(org.eclipse.emf.ecore.EObject)
	 */
	public void detached(EObject arg0) {
		super.detached(arg0);
		arg0.eAdapters().clear();		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.ecore.resource.impl.ResourceImpl#doLoad(java.io.InputStream, java.util.Map)
	 */
	public void doLoad(InputStream inputStream, Map options) throws IOException {
/*		try {
			if ( inputStream.available() == 0 )
				return;
		}
		catch (IOException ex)
		{
			return;
		}
*/	
		if ( inputStream instanceof ZipInputStream )
		{
			ZipInputStream zipIn = (ZipInputStream) inputStream;
			
			// Read the ResourceContents into a temporary file so we can call the 
			// super.doLoad() after we read out any annotations
			File tempResourceContents = File.createTempFile("tempResouce", "");
			FileOutputStream file = new FileOutputStream(tempResourceContents);
			BufferedOutputStream bufFile = new BufferedOutputStream(file);

			int bufSize = 65536;
			byte[] readBuffer = new byte[bufSize];
			int count;
			while ((count = zipIn.read(readBuffer, 0, bufSize)) != -1) {
				bufFile.write(readBuffer, 0, count);
			}
			bufFile.close();
			
			ZipEntry entry = zipIn.getNextEntry();
			if ( entry != null )
			{
				// We have at least one annotation file.
				URI baseAnnotationDirURI = URI.createFileURI(getAnnotationDir().getAbsolutePath());			
				while ( entry != null )
				{
					String entryName = entry.getName();
					URI relativeURI = URI.createURI(entryName);
					URI fileURI = relativeURI.resolve(baseAnnotationDirURI);
					File dest = new File(fileURI.toFileString()); 
					if ( !(dest.getParentFile().exists()))
					{
						dest.getParentFile().mkdirs();
					}
					file = new FileOutputStream(fileURI.toFileString());
					bufFile = new BufferedOutputStream(file);
					
					while ((count = zipIn.read(readBuffer, 0, bufSize)) != -1) {
						bufFile.write(readBuffer, 0, count);
					}
					bufFile.close();
					entry = zipIn.getNextEntry();
				}
			}
			
			FileInputStream fileIn = new FileInputStream(tempResourceContents);
			BufferedInputStream bufIn = new BufferedInputStream(fileIn);
			super.doLoad(bufIn, options);
			bufIn.close();
			tempResourceContents.delete();
		}
		else
			super.doLoad(inputStream, options);

	}
	/* (non-Javadoc)
	 * @see org.eclipse.emf.ecore.resource.impl.ResourceImpl#doSave(java.io.OutputStream, java.util.Map)
	 */
	public void doSave(OutputStream outputStream, Map options)
			throws IOException {
		super.doSave(outputStream, options);
		
		if ( hasAnnotations() && outputStream instanceof ZipOutputStream)
		{
			ZipOutputStream zipOut = (ZipOutputStream)outputStream;
			File annotationDir = getAnnotationDir();
			URI baseAnnotationDirURI = URI.createFileURI(annotationDir.getAbsolutePath());			
			File[] annotations = FileUtil.listAllFiles(annotationDir);
			if ( annotations == null )
				return;
			
			for ( int i=0; i<annotations.length; i++)
			{
				URI currentFile = URI.createFileURI(annotations[i].getAbsolutePath());
				URI relativeURI = currentFile.deresolve(baseAnnotationDirURI);
				FileInputStream in = new FileInputStream(annotations[i]);
				ZipEntry entry = new ZipEntry(relativeURI.toString());
				entry.setMethod(ZipEntry.STORED);
				entry.setSize(annotations[i].length());
				
				// This stinks, but in order to copy a file into a zipoutputstream
				// using the STORED method (meaning, please don't try to compress this),
				// you need to precalculate the CRC, which means you need to read the
				// entire file twice (unless you want to hold the whole thing in memory,
				// which we don't want to do...)
				CRC32 crc = new CRC32();
				BufferedInputStream contentStream = new BufferedInputStream(in);

				// 64k buffer for reading and writing
				int bufSize = 65536;
				byte[] readBuffer = new byte[bufSize];
				int count;
				while ((count = contentStream.read(readBuffer, 0, bufSize)) != -1) {
					crc.update(readBuffer, 0, count);
				}
				contentStream.close();
				entry.setCrc(crc.getValue());
				zipOut.putNextEntry(entry);

				in = new FileInputStream(annotations[i]);
				contentStream = new BufferedInputStream(in);
				while ((count = contentStream.read(readBuffer, 0, bufSize)) != -1) {
					zipOut.write(readBuffer, 0, count);
				}
				zipOut.closeEntry();
				contentStream.close();
			}
		}
	}
	
	public boolean hasAnnotations()
	{
		return (annotationDir != null);
	}
	

	public synchronized File getAnnotationDir() throws IOException
	{
		// This method is synchronized to provide atomicity of the test & set
		// of the anotationDir
		if ( annotationDir != null )
		{
			return annotationDir;
		}
		
		File systemTempDir = FileUtil.getTempDir();
		File temp = File.createTempFile("Hyades.TestModel.AnnotationDir", "", systemTempDir);
		if ( temp.delete() && temp.mkdir() )
		{
			annotationDir = new File(temp, "annotations");
			if ( !annotationDir.mkdir() )
				throw new IOException("Unable to create new annotation Dir " + annotationDir.getAbsolutePath());
		}
		else
		{
			throw new IOException("Unable to create new annotation Dir " + temp.getAbsolutePath());
		}
		
		return annotationDir;
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		// Clean up annotationDir, if it exists.
		cleanupAnnotationDir();
		super.finalize();
	}
	
	/**
	 * This method simply calls cleanupAnnotationDir today, but may do
	 * more cleanup in the future
	 */
	public void cleanup()
	{
		cleanupAnnotationDir();
	}
	
	private void cleanupAnnotationDir()
	{
		if ( hasAnnotations() )
		{
			FileUtil.deltree(annotationDir.getParentFile());
		}
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.emf.ecore.resource.impl.ResourceImpl#doUnload()
	 */
	protected void doUnload() {
		super.doUnload();
		cleanupAnnotationDir();
	}
}
