/*******************************************************************************
 * Copyright (c) 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.facades.behavioral.impl;

import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;

/**
 * @author jtoomey
 * @author psun
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class HyadesTPFTestComponentAdapter extends AdapterImpl {

	/**
	 * 
	 */
	public HyadesTPFTestComponentAdapter() {
		super();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.common.notify.Adapter#isAdapterForType(java.lang.Object)
	 */
	public boolean isAdapterForType(Object arg0) {
	  if (arg0 instanceof EObject)
	  {
		return ((EObject)arg0).eClass() == Common_TestprofilePackage.eINSTANCE.getTPFTestComponent();
	  }
	  return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.common.notify.Adapter#notifyChanged(org.eclipse.emf.common.notify.Notification)
	 */
	public void notifyChanged(Notification notification) {
				
		int eventType = notification.getEventType();
			
		if ( eventType == Notification.ADD ||
			 eventType == Notification.ADD_MANY ||
			 eventType == Notification.REMOVE ||
			 eventType == Notification.REMOVE_MANY )
		{
			TPFTestComponent testComponent = (TPFTestComponent) notification.getNotifier();

			if( ! (testComponent.eResource() instanceof FacadeResourceImpl ))
			{
				return;
			}
			
			Iterator iter = null;
			switch (notification.getFeatureID(TPFTest.class))
			{
				case Common_TestprofilePackage.TPF_TEST_COMPONENT__BEHAVIORS:
					// If one or more test component behaviors have been removed, we must
					// fix up the relationship between the lifelines from 
					// those behaviors' interactions and the CFGInstances that
					// they were associated to.
					switch(eventType){
						case Notification.REMOVE:
							TPFBehavior behavior = (TPFBehavior)notification.getOldValue();
							HyadesTPFTestSuiteAdapter.removeTPFBehaviorInstances(behavior);
						break;
					case Notification.REMOVE_MANY:
						List behaviors = (List)notification.getOldValue();
						iter = behaviors.iterator();
						while (iter.hasNext()) {
							behavior = (TPFBehavior) iter.next();
							HyadesTPFTestSuiteAdapter.removeTPFBehaviorInstances(behavior);
						}
						break;					
					}
					break;
			}
		
		}
	}

}