/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.interactions.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestComponent;
import org.eclipse.hyades.models.common.facades.behavioral.ITestComponentInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.fragments.BVRInteraction;
import org.eclipse.hyades.models.common.fragments.Common_Behavior_FragmentsPackage;
import org.eclipse.hyades.models.common.interactions.BVREventOccurrence;
import org.eclipse.hyades.models.common.interactions.BVRExecutionOccurrence;
import org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;
import org.eclipse.hyades.models.common.testprofile.TPFDefaultApplication;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.impl.TPFBehaviorImpl;
import org.eclipse.hyades.models.common.testprofile.impl.TPFTestCaseImpl;
import org.eclipse.hyades.models.common.testprofile.impl.TPFTestComponentImpl;
import org.eclipse.hyades.models.common.testprofile.impl.TPFTestSuiteImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>BVR Execution Occurrence</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.impl.BVRExecutionOccurrenceImpl#getFinishEventOccurrence <em>Finish Event Occurrence</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.impl.BVRExecutionOccurrenceImpl#getBeforeEventOccurrence <em>Before Event Occurrence</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.impl.BVRExecutionOccurrenceImpl#getOtherBehavior <em>Other Behavior</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class BVRExecutionOccurrenceImpl extends BVRInteractionFragmentImpl implements BVRExecutionOccurrence
{
    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public static final String copyright = "";

    /**
     * The cached value of the '{@link #getFinishEventOccurrence() <em>Finish Event Occurrence</em>}' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getFinishEventOccurrence()
     * @generated
     * @ordered
     */
	protected BVREventOccurrence finishEventOccurrence = null;

    /**
     * The cached value of the '{@link #getBeforeEventOccurrence() <em>Before Event Occurrence</em>}' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getBeforeEventOccurrence()
     * @generated
     * @ordered
     */
	protected BVREventOccurrence beforeEventOccurrence = null;

    /**
     * The cached value of the '{@link #getOtherBehavior() <em>Other Behavior</em>}' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getOtherBehavior()
     * @generated
     * @ordered
     */
	protected TPFBehavior otherBehavior = null;

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected BVRExecutionOccurrenceImpl()
    {
        super();
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected EClass eStaticClass()
    {
        return Common_Behavior_InteractionsPackage.eINSTANCE.getBVRExecutionOccurrence();
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public BVREventOccurrence getFinishEventOccurrence()
    {
        if (finishEventOccurrence != null && finishEventOccurrence.eIsProxy())
        {
            BVREventOccurrence oldFinishEventOccurrence = finishEventOccurrence;
            finishEventOccurrence = (BVREventOccurrence)eResolveProxy((InternalEObject)finishEventOccurrence);
            if (finishEventOccurrence != oldFinishEventOccurrence)
            {
                if (eNotificationRequired())
                    eNotify(new ENotificationImpl(this, Notification.RESOLVE, Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__FINISH_EVENT_OCCURRENCE, oldFinishEventOccurrence, finishEventOccurrence));
            }
        }
        return finishEventOccurrence;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public BVREventOccurrence basicGetFinishEventOccurrence()
    {
        return finishEventOccurrence;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain basicSetFinishEventOccurrence(BVREventOccurrence newFinishEventOccurrence, NotificationChain msgs)
    {
        BVREventOccurrence oldFinishEventOccurrence = finishEventOccurrence;
        finishEventOccurrence = newFinishEventOccurrence;
        if (eNotificationRequired())
        {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__FINISH_EVENT_OCCURRENCE, oldFinishEventOccurrence, newFinishEventOccurrence);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setFinishEventOccurrence(BVREventOccurrence newFinishEventOccurrence)
    {
        if (newFinishEventOccurrence != finishEventOccurrence)
        {
            NotificationChain msgs = null;
            if (finishEventOccurrence != null)
                msgs = ((InternalEObject)finishEventOccurrence).eInverseRemove(this, Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__FINISH_EXECUTION_OCCURRENCE, BVREventOccurrence.class, msgs);
            if (newFinishEventOccurrence != null)
                msgs = ((InternalEObject)newFinishEventOccurrence).eInverseAdd(this, Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__FINISH_EXECUTION_OCCURRENCE, BVREventOccurrence.class, msgs);
            msgs = basicSetFinishEventOccurrence(newFinishEventOccurrence, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__FINISH_EVENT_OCCURRENCE, newFinishEventOccurrence, newFinishEventOccurrence));
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public BVREventOccurrence getBeforeEventOccurrence()
    {
        if (beforeEventOccurrence != null && beforeEventOccurrence.eIsProxy())
        {
            BVREventOccurrence oldBeforeEventOccurrence = beforeEventOccurrence;
            beforeEventOccurrence = (BVREventOccurrence)eResolveProxy((InternalEObject)beforeEventOccurrence);
            if (beforeEventOccurrence != oldBeforeEventOccurrence)
            {
                if (eNotificationRequired())
                    eNotify(new ENotificationImpl(this, Notification.RESOLVE, Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__BEFORE_EVENT_OCCURRENCE, oldBeforeEventOccurrence, beforeEventOccurrence));
            }
        }
        return beforeEventOccurrence;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public BVREventOccurrence basicGetBeforeEventOccurrence()
    {
        return beforeEventOccurrence;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain basicSetBeforeEventOccurrence(BVREventOccurrence newBeforeEventOccurrence, NotificationChain msgs)
    {
        BVREventOccurrence oldBeforeEventOccurrence = beforeEventOccurrence;
        beforeEventOccurrence = newBeforeEventOccurrence;
        if (eNotificationRequired())
        {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__BEFORE_EVENT_OCCURRENCE, oldBeforeEventOccurrence, newBeforeEventOccurrence);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setBeforeEventOccurrence(BVREventOccurrence newBeforeEventOccurrence)
    {
        if (newBeforeEventOccurrence != beforeEventOccurrence)
        {
            NotificationChain msgs = null;
            if (beforeEventOccurrence != null)
                msgs = ((InternalEObject)beforeEventOccurrence).eInverseRemove(this, Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__START_EXECUTION_OCURRENCE, BVREventOccurrence.class, msgs);
            if (newBeforeEventOccurrence != null)
                msgs = ((InternalEObject)newBeforeEventOccurrence).eInverseAdd(this, Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__START_EXECUTION_OCURRENCE, BVREventOccurrence.class, msgs);
            msgs = basicSetBeforeEventOccurrence(newBeforeEventOccurrence, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__BEFORE_EVENT_OCCURRENCE, newBeforeEventOccurrence, newBeforeEventOccurrence));
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public TPFBehavior getOtherBehavior()
    {
        if (otherBehavior != null && otherBehavior.eIsProxy())
        {
            TPFBehavior oldOtherBehavior = otherBehavior;
            otherBehavior = (TPFBehavior)eResolveProxy((InternalEObject)otherBehavior);
            if (otherBehavior != oldOtherBehavior)
            {
                if (eNotificationRequired())
                    eNotify(new ENotificationImpl(this, Notification.RESOLVE, Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__OTHER_BEHAVIOR, oldOtherBehavior, otherBehavior));
            }
        }
        return otherBehavior;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public TPFBehavior basicGetOtherBehavior()
    {
        return otherBehavior;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setOtherBehavior(TPFBehavior newOtherBehavior)
    {
        TPFBehavior oldOtherBehavior = otherBehavior;
        otherBehavior = newOtherBehavior;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__OTHER_BEHAVIOR, oldOtherBehavior, otherBehavior));
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
    {
        if (featureID >= 0)
        {
            switch (eDerivedStructuralFeatureID(featureID, baseClass))
            {
                case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__LIFELINES:
                    return ((InternalEList)getLifelines()).basicAdd(otherEnd, msgs);
                case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__MESSAGES:
                    return ((InternalEList)getMessages()).basicAdd(otherEnd, msgs);
                case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__INTERACTION:
                    if (eContainer != null)
                        msgs = eBasicRemoveFromContainer(msgs);
                    return eBasicSetContainer(otherEnd, Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__INTERACTION, msgs);
                case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__DEFAULT_APPLICATION:
                    if (defaultApplication != null)
                        msgs = ((InternalEObject)defaultApplication).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__DEFAULT_APPLICATION, null, msgs);
                    return basicSetDefaultApplication((TPFDefaultApplication)otherEnd, msgs);
                case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__FINISH_EVENT_OCCURRENCE:
                    if (finishEventOccurrence != null)
                        msgs = ((InternalEObject)finishEventOccurrence).eInverseRemove(this, Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__FINISH_EXECUTION_OCCURRENCE, BVREventOccurrence.class, msgs);
                    return basicSetFinishEventOccurrence((BVREventOccurrence)otherEnd, msgs);
                case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__BEFORE_EVENT_OCCURRENCE:
                    if (beforeEventOccurrence != null)
                        msgs = ((InternalEObject)beforeEventOccurrence).eInverseRemove(this, Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__START_EXECUTION_OCURRENCE, BVREventOccurrence.class, msgs);
                    return basicSetBeforeEventOccurrence((BVREventOccurrence)otherEnd, msgs);
                default:
                    return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
            }
        }
        if (eContainer != null)
            msgs = eBasicRemoveFromContainer(msgs);
        return eBasicSetContainer(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
    {
        if (featureID >= 0)
        {
            switch (eDerivedStructuralFeatureID(featureID, baseClass))
            {
                case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__LIFELINES:
                    return ((InternalEList)getLifelines()).basicRemove(otherEnd, msgs);
                case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__GENERAL_ORDERINGS:
                    return ((InternalEList)getGeneralOrderings()).basicRemove(otherEnd, msgs);
                case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__MESSAGES:
                    return ((InternalEList)getMessages()).basicRemove(otherEnd, msgs);
                case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__ANNOTATIONS:
                    return ((InternalEList)getAnnotations()).basicRemove(otherEnd, msgs);
                case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__INTERACTION:
                    return eBasicSetContainer(null, Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__INTERACTION, msgs);
                case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__PROPERTIES:
                    return ((InternalEList)getProperties()).basicRemove(otherEnd, msgs);
                case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__DEFAULT_APPLICATION:
                    return basicSetDefaultApplication(null, msgs);
                case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__FINISH_EVENT_OCCURRENCE:
                    return basicSetFinishEventOccurrence(null, msgs);
                case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__BEFORE_EVENT_OCCURRENCE:
                    return basicSetBeforeEventOccurrence(null, msgs);
                default:
                    return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
            }
        }
        return eBasicSetContainer(null, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs)
    {
        if (eContainerFeatureID >= 0)
        {
            switch (eContainerFeatureID)
            {
                case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__INTERACTION:
                    return ((InternalEObject)eContainer).eInverseRemove(this, Common_Behavior_FragmentsPackage.BVR_INTERACTION__INTERACTION_FRAGMENTS, BVRInteraction.class, msgs);
                default:
                    return eDynamicBasicRemoveFromContainer(msgs);
            }
        }
        return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Object eGet(EStructuralFeature eFeature, boolean resolve)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__ID:
                return getId();
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__DESCRIPTION:
                return getDescription();
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__NAME:
                return getName();
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__LIFELINES:
                return getLifelines();
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__GENERAL_ORDERINGS:
                return getGeneralOrderings();
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__MESSAGES:
                return getMessages();
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__ANNOTATIONS:
                return getAnnotations();
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__INTERACTION:
                return getInteraction();
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__PROPERTIES:
                return getProperties();
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__DEFAULT_APPLICATION:
                return getDefaultApplication();
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__FINISH_EVENT_OCCURRENCE:
                if (resolve) return getFinishEventOccurrence();
                return basicGetFinishEventOccurrence();
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__BEFORE_EVENT_OCCURRENCE:
                if (resolve) return getBeforeEventOccurrence();
                return basicGetBeforeEventOccurrence();
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__OTHER_BEHAVIOR:
                if (resolve) return getOtherBehavior();
                return basicGetOtherBehavior();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void eSet(EStructuralFeature eFeature, Object newValue)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__ID:
                setId((String)newValue);
                return;
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__DESCRIPTION:
                setDescription((String)newValue);
                return;
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__NAME:
                setName((String)newValue);
                return;
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__LIFELINES:
                getLifelines().clear();
                getLifelines().addAll((Collection)newValue);
                return;
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__GENERAL_ORDERINGS:
                getGeneralOrderings().clear();
                getGeneralOrderings().addAll((Collection)newValue);
                return;
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__MESSAGES:
                getMessages().clear();
                getMessages().addAll((Collection)newValue);
                return;
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__ANNOTATIONS:
                getAnnotations().clear();
                getAnnotations().addAll((Collection)newValue);
                return;
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__INTERACTION:
                setInteraction((BVRInteraction)newValue);
                return;
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__PROPERTIES:
                getProperties().clear();
                getProperties().addAll((Collection)newValue);
                return;
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__DEFAULT_APPLICATION:
                setDefaultApplication((TPFDefaultApplication)newValue);
                return;
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__FINISH_EVENT_OCCURRENCE:
                setFinishEventOccurrence((BVREventOccurrence)newValue);
                return;
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__BEFORE_EVENT_OCCURRENCE:
                setBeforeEventOccurrence((BVREventOccurrence)newValue);
                return;
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__OTHER_BEHAVIOR:
                setOtherBehavior((TPFBehavior)newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void eUnset(EStructuralFeature eFeature)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__ID:
                setId(ID_EDEFAULT);
                return;
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__DESCRIPTION:
                setDescription(DESCRIPTION_EDEFAULT);
                return;
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__NAME:
                setName(NAME_EDEFAULT);
                return;
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__LIFELINES:
                getLifelines().clear();
                return;
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__GENERAL_ORDERINGS:
                getGeneralOrderings().clear();
                return;
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__MESSAGES:
                getMessages().clear();
                return;
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__ANNOTATIONS:
                getAnnotations().clear();
                return;
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__INTERACTION:
                setInteraction((BVRInteraction)null);
                return;
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__PROPERTIES:
                getProperties().clear();
                return;
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__DEFAULT_APPLICATION:
                setDefaultApplication((TPFDefaultApplication)null);
                return;
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__FINISH_EVENT_OCCURRENCE:
                setFinishEventOccurrence((BVREventOccurrence)null);
                return;
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__BEFORE_EVENT_OCCURRENCE:
                setBeforeEventOccurrence((BVREventOccurrence)null);
                return;
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__OTHER_BEHAVIOR:
                setOtherBehavior((TPFBehavior)null);
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public boolean eIsSet(EStructuralFeature eFeature)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__ID:
                return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__DESCRIPTION:
                return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__NAME:
                return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__LIFELINES:
                return lifelines != null && !lifelines.isEmpty();
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__GENERAL_ORDERINGS:
                return generalOrderings != null && !generalOrderings.isEmpty();
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__MESSAGES:
                return messages != null && !messages.isEmpty();
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__ANNOTATIONS:
                return annotations != null && !annotations.isEmpty();
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__INTERACTION:
                return getInteraction() != null;
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__PROPERTIES:
                return properties != null && !properties.isEmpty();
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__DEFAULT_APPLICATION:
                return defaultApplication != null;
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__FINISH_EVENT_OCCURRENCE:
                return finishEventOccurrence != null;
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__BEFORE_EVENT_OCCURRENCE:
                return beforeEventOccurrence != null;
            case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__OTHER_BEHAVIOR:
                return otherBehavior != null;
        }
        return eDynamicIsSet(eFeature);
    }

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation#getInvokedTest()
	 */
	public ITest getInvokedTest() {
		if(getOtherBehavior() != null)
		{
			ITest test = (ITest)getOtherBehavior().getTest();
			if(test instanceof TPFTest)
				return test;
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation#setInvokedTest(org.eclipse.hyades.models.common.facades.behavioral.ITest)
	 */
	public void setInvokedTest(ITest test) {
		if ( test instanceof TPFTestCaseImpl || test instanceof TPFTestSuiteImpl)
		{
			if(test.getImplementor() != null)
			{
				setOtherBehavior((TPFBehaviorImpl)test.getImplementor());
			}
			else
			{
				throw new IllegalArgumentException("Invoked test must have an implementor.");
			}
		}
		else
		{
			throw new IllegalArgumentException("Invoked test must be a TPFTest.");			
		}
	}

	// TODO: These overrided methods need to be reworked in a future release
	public static final String SYNCHRONIZATION_FLAG = "SYNCRONIZATION_FLAG";

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IAction#isSynchronous()
	 */
	public boolean isSynchronous() {
		Iterator iter = getProperties().iterator();
		while(iter.hasNext())
		{
			BVRPropertyImpl property = (BVRPropertyImpl)iter.next();
			if(property.getName().equals(SYNCHRONIZATION_FLAG))
			{
				return Boolean.valueOf(property.getValue()).booleanValue();
			}
		}
		return true;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IAction#setSynchronous(boolean)
	 */
	public void setSynchronous(boolean synchronous)
		throws UnsupportedOperationException 
	{
		Iterator iter = getProperties().iterator();
		// find the synchronization property and set it
		while(iter.hasNext())
		{
			BVRPropertyImpl property = (BVRPropertyImpl)iter.next();
			if(property.getName().equals(SYNCHRONIZATION_FLAG))
			{
				property.setValue(new Boolean(synchronous).toString());
				return;
			}
		}
		// if the property doesn't exist, create it and set it
		BVRPropertyImpl property = (BVRPropertyImpl)Common_Behavior_InteractionsFactoryImpl.eINSTANCE.createBVRProperty();
		property.setName(SYNCHRONIZATION_FLAG);
		property.setValue(String.valueOf(synchronous));
		List properties = getProperties();
		properties.add(property);
	}
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ITestComponentInvocation#getInvokedImplementor()
	 */
	public IImplementor getInvokedImplementor() {
		TPFBehaviorImpl behavior = (TPFBehaviorImpl) getOtherBehavior();
		return behavior;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ITestComponentInvocation#getInvokedImplementorName()
	 */
	public String getInvokedImplementorName() {
		TPFBehaviorImpl behavior = (TPFBehaviorImpl) getOtherBehavior();
		if ( behavior != null )
			return behavior.getName();
		else
			return "";
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ITestComponentInvocation#getInvokedTestComponent()
	 */
	public ITestComponent getInvokedTestComponent() {
		TPFBehaviorImpl behavior = (TPFBehaviorImpl) getOtherBehavior();
		TPFTestComponentImpl component = (TPFTestComponentImpl)behavior.getTestComponent();
		return component;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ITestComponentInvocation#setInvokedTestComponent(org.eclipse.hyades.models.common.facades.behavioral.ITestComponent, org.eclipse.hyades.models.common.facades.behavioral.IImplementor)
	 */
	public void setInvokedTestComponent(
		ITestComponent component,
		IImplementor implementor) 
	{
		// component can be ignored, since it is inferred from implementor
		if ( implementor != null )
		{
			setOtherBehavior((TPFBehaviorImpl)implementor);		
		}
		else
		{
			// TODO: declare an exception on this interface and throw it here
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ITestComponentInvocation#setInvokedTestComponent(org.eclipse.hyades.models.common.facades.behavioral.ITestComponent, java.lang.String)
	 */
	public void setInvokedTestComponent(
		ITestComponent component,
		String implementorName) 
	{
		if ( component != null && implementorName != null )
		{
			TPFTestComponentImpl theComponent = (TPFTestComponentImpl) component;
			List behaviors = theComponent.getBehaviors();
			Iterator iter = behaviors.iterator();
			while(iter.hasNext())
			{
				TPFBehaviorImpl behavior = (TPFBehaviorImpl) iter.next();
				String name = behavior.getName();
				if ( name != null && name.equals(implementorName))
				{
					setInvokedTestComponent(component, (IImplementor) behavior);
					break;
				}
			}
			// TODO: Must thrown an exception here, or change interface to return boolean.
		}
		else
		{
			// TODO: declare an exception on this interface and throw it here
		}

	}

} //BVRExecutionOccurrenceImpl
