/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.testprofile;

import org.eclipse.hyades.models.common.common.CMNNamedElement;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>TPF Test Objective</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * A Test Objectiive is a dependency used to specify the objectives of a Test Case or Test Suite. A Test Case or Test Suite can have any number of objectives. A Test Objective being a dependency to the objective itself, it is associated to only one Test Case or Test Suite.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFTestObjective#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFTestObjective#getReference <em>Reference</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFTestObjective#getTest <em>Test</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFTestObjective()
 * @model 
 * @generated
 */
public interface TPFTestObjective extends CMNNamedElement{
    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	String copyright = "";

    /**
     * Returns the value of the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Type</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Type</em>' attribute.
     * @see #setType(String)
     * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFTestObjective_Type()
     * @model 
     * @generated
     */
	String getType();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.models.common.testprofile.TPFTestObjective#getType <em>Type</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Type</em>' attribute.
     * @see #getType()
     * @generated
     */
	void setType(String value);

    /**
     * Returns the value of the '<em><b>Reference</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Reference</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Reference</em>' attribute.
     * @see #setReference(String)
     * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFTestObjective_Reference()
     * @model 
     * @generated
     */
	String getReference();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.models.common.testprofile.TPFTestObjective#getReference <em>Reference</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Reference</em>' attribute.
     * @see #getReference()
     * @generated
     */
	void setReference(String value);

    /**
     * Returns the value of the '<em><b>Test</b></em>' container reference.
     * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.testprofile.TPFTest#getTestObjectives <em>Test Objectives</em>}'.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Test</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Test</em>' container reference.
     * @see #setTest(TPFTest)
     * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFTestObjective_Test()
     * @see org.eclipse.hyades.models.common.testprofile.TPFTest#getTestObjectives
     * @model opposite="testObjectives" required="true"
     * @generated
     */
	TPFTest getTest();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.models.common.testprofile.TPFTestObjective#getTest <em>Test</em>}' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Test</em>' container reference.
     * @see #getTest()
     * @generated
     */
	void setTest(TPFTest value);

} // TPFTestObjective
