/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.testprofile.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.hyades.models.common.interactions.BVRInteractionFragment;

import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFLoopEvent;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TPF Loop Event</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFLoopEventImpl#getIterations <em>Iterations</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFLoopEventImpl#isAsynchronous <em>Asynchronous</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TPFLoopEventImpl extends TPFExecutionEventImpl implements TPFLoopEvent {
    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public static final String copyright = "";

    /**
     * The default value of the '{@link #getIterations() <em>Iterations</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getIterations()
     * @generated
     * @ordered
     */
	protected static final long ITERATIONS_EDEFAULT = 0L;

    /**
     * The cached value of the '{@link #getIterations() <em>Iterations</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getIterations()
     * @generated
     * @ordered
     */
	protected long iterations = ITERATIONS_EDEFAULT;

    /**
     * The default value of the '{@link #isAsynchronous() <em>Asynchronous</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #isAsynchronous()
     * @generated
     * @ordered
     */
	protected static final boolean ASYNCHRONOUS_EDEFAULT = false;

    /**
     * The cached value of the '{@link #isAsynchronous() <em>Asynchronous</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #isAsynchronous()
     * @generated
     * @ordered
     */
	protected boolean asynchronous = ASYNCHRONOUS_EDEFAULT;

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected TPFLoopEventImpl()
    {
        super();
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected EClass eStaticClass()
    {
        return Common_TestprofilePackage.eINSTANCE.getTPFLoopEvent();
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public long getIterations()
    {
        return iterations;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setIterations(long newIterations)
    {
        long oldIterations = iterations;
        iterations = newIterations;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_LOOP_EVENT__ITERATIONS, oldIterations, iterations));
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public boolean isAsynchronous()
    {
        return asynchronous;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setAsynchronous(boolean newAsynchronous)
    {
        boolean oldAsynchronous = asynchronous;
        asynchronous = newAsynchronous;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_LOOP_EVENT__ASYNCHRONOUS, oldAsynchronous, asynchronous));
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
    {
        if (featureID >= 0)
        {
            switch (eDerivedStructuralFeatureID(featureID, baseClass))
            {
                case Common_TestprofilePackage.TPF_LOOP_EVENT__EXECUTION_HISTORY:
                    if (eContainer != null)
                        msgs = eBasicRemoveFromContainer(msgs);
                    return eBasicSetContainer(otherEnd, Common_TestprofilePackage.TPF_LOOP_EVENT__EXECUTION_HISTORY, msgs);
                case Common_TestprofilePackage.TPF_LOOP_EVENT__CHILDREN:
                    return ((InternalEList)getChildren()).basicAdd(otherEnd, msgs);
                case Common_TestprofilePackage.TPF_LOOP_EVENT__PARENT:
                    if (eContainer != null)
                        msgs = eBasicRemoveFromContainer(msgs);
                    return eBasicSetContainer(otherEnd, Common_TestprofilePackage.TPF_LOOP_EVENT__PARENT, msgs);
                default:
                    return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
            }
        }
        if (eContainer != null)
            msgs = eBasicRemoveFromContainer(msgs);
        return eBasicSetContainer(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
    {
        if (featureID >= 0)
        {
            switch (eDerivedStructuralFeatureID(featureID, baseClass))
            {
                case Common_TestprofilePackage.TPF_LOOP_EVENT__EXECUTION_HISTORY:
                    return eBasicSetContainer(null, Common_TestprofilePackage.TPF_LOOP_EVENT__EXECUTION_HISTORY, msgs);
                case Common_TestprofilePackage.TPF_LOOP_EVENT__CHILDREN:
                    return ((InternalEList)getChildren()).basicRemove(otherEnd, msgs);
                case Common_TestprofilePackage.TPF_LOOP_EVENT__PARENT:
                    return eBasicSetContainer(null, Common_TestprofilePackage.TPF_LOOP_EVENT__PARENT, msgs);
                case Common_TestprofilePackage.TPF_LOOP_EVENT__PROPERTIES:
                    return ((InternalEList)getProperties()).basicRemove(otherEnd, msgs);
                case Common_TestprofilePackage.TPF_LOOP_EVENT__ANNOTATIONS:
                    return ((InternalEList)getAnnotations()).basicRemove(otherEnd, msgs);
                default:
                    return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
            }
        }
        return eBasicSetContainer(null, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs)
    {
        if (eContainerFeatureID >= 0)
        {
            switch (eContainerFeatureID)
            {
                case Common_TestprofilePackage.TPF_LOOP_EVENT__EXECUTION_HISTORY:
                    return ((InternalEObject)eContainer).eInverseRemove(this, Common_TestprofilePackage.TPF_EXECUTION_HISTORY__EXECUTION_EVENTS, TPFExecutionHistory.class, msgs);
                case Common_TestprofilePackage.TPF_LOOP_EVENT__PARENT:
                    return ((InternalEObject)eContainer).eInverseRemove(this, Common_TestprofilePackage.TPF_EXECUTION_EVENT__CHILDREN, TPFExecutionEvent.class, msgs);
                default:
                    return eDynamicBasicRemoveFromContainer(msgs);
            }
        }
        return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Object eGet(EStructuralFeature eFeature, boolean resolve)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_TestprofilePackage.TPF_LOOP_EVENT__ID:
                return getId();
            case Common_TestprofilePackage.TPF_LOOP_EVENT__DESCRIPTION:
                return getDescription();
            case Common_TestprofilePackage.TPF_LOOP_EVENT__NAME:
                return getName();
            case Common_TestprofilePackage.TPF_LOOP_EVENT__OWNER_ID:
                return getOwnerId();
            case Common_TestprofilePackage.TPF_LOOP_EVENT__TIMESTAMP:
                return new Long(getTimestamp());
            case Common_TestprofilePackage.TPF_LOOP_EVENT__TEXT:
                return getText();
            case Common_TestprofilePackage.TPF_LOOP_EVENT__EVENT_TYPE:
                return getEventType();
            case Common_TestprofilePackage.TPF_LOOP_EVENT__EXECUTION_HISTORY:
                return getExecutionHistory();
            case Common_TestprofilePackage.TPF_LOOP_EVENT__INTERACTION_FRAGMENT:
                if (resolve) return getInteractionFragment();
                return basicGetInteractionFragment();
            case Common_TestprofilePackage.TPF_LOOP_EVENT__CHILDREN:
                return getChildren();
            case Common_TestprofilePackage.TPF_LOOP_EVENT__PARENT:
                return getParent();
            case Common_TestprofilePackage.TPF_LOOP_EVENT__PROPERTIES:
                return getProperties();
            case Common_TestprofilePackage.TPF_LOOP_EVENT__ANNOTATIONS:
                return getAnnotations();
            case Common_TestprofilePackage.TPF_LOOP_EVENT__ITERATIONS:
                return new Long(getIterations());
            case Common_TestprofilePackage.TPF_LOOP_EVENT__ASYNCHRONOUS:
                return isAsynchronous() ? Boolean.TRUE : Boolean.FALSE;
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void eSet(EStructuralFeature eFeature, Object newValue)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_TestprofilePackage.TPF_LOOP_EVENT__ID:
                setId((String)newValue);
                return;
            case Common_TestprofilePackage.TPF_LOOP_EVENT__DESCRIPTION:
                setDescription((String)newValue);
                return;
            case Common_TestprofilePackage.TPF_LOOP_EVENT__NAME:
                setName((String)newValue);
                return;
            case Common_TestprofilePackage.TPF_LOOP_EVENT__OWNER_ID:
                setOwnerId((String)newValue);
                return;
            case Common_TestprofilePackage.TPF_LOOP_EVENT__TIMESTAMP:
                setTimestamp(((Long)newValue).longValue());
                return;
            case Common_TestprofilePackage.TPF_LOOP_EVENT__TEXT:
                setText((String)newValue);
                return;
            case Common_TestprofilePackage.TPF_LOOP_EVENT__EVENT_TYPE:
                setEventType((String)newValue);
                return;
            case Common_TestprofilePackage.TPF_LOOP_EVENT__EXECUTION_HISTORY:
                setExecutionHistory((TPFExecutionHistory)newValue);
                return;
            case Common_TestprofilePackage.TPF_LOOP_EVENT__INTERACTION_FRAGMENT:
                setInteractionFragment((BVRInteractionFragment)newValue);
                return;
            case Common_TestprofilePackage.TPF_LOOP_EVENT__CHILDREN:
                getChildren().clear();
                getChildren().addAll((Collection)newValue);
                return;
            case Common_TestprofilePackage.TPF_LOOP_EVENT__PARENT:
                setParent((TPFExecutionEvent)newValue);
                return;
            case Common_TestprofilePackage.TPF_LOOP_EVENT__PROPERTIES:
                getProperties().clear();
                getProperties().addAll((Collection)newValue);
                return;
            case Common_TestprofilePackage.TPF_LOOP_EVENT__ANNOTATIONS:
                getAnnotations().clear();
                getAnnotations().addAll((Collection)newValue);
                return;
            case Common_TestprofilePackage.TPF_LOOP_EVENT__ITERATIONS:
                setIterations(((Long)newValue).longValue());
                return;
            case Common_TestprofilePackage.TPF_LOOP_EVENT__ASYNCHRONOUS:
                setAsynchronous(((Boolean)newValue).booleanValue());
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void eUnset(EStructuralFeature eFeature)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_TestprofilePackage.TPF_LOOP_EVENT__ID:
                setId(ID_EDEFAULT);
                return;
            case Common_TestprofilePackage.TPF_LOOP_EVENT__DESCRIPTION:
                setDescription(DESCRIPTION_EDEFAULT);
                return;
            case Common_TestprofilePackage.TPF_LOOP_EVENT__NAME:
                setName(NAME_EDEFAULT);
                return;
            case Common_TestprofilePackage.TPF_LOOP_EVENT__OWNER_ID:
                setOwnerId(OWNER_ID_EDEFAULT);
                return;
            case Common_TestprofilePackage.TPF_LOOP_EVENT__TIMESTAMP:
                setTimestamp(TIMESTAMP_EDEFAULT);
                return;
            case Common_TestprofilePackage.TPF_LOOP_EVENT__TEXT:
                setText(TEXT_EDEFAULT);
                return;
            case Common_TestprofilePackage.TPF_LOOP_EVENT__EVENT_TYPE:
                setEventType(EVENT_TYPE_EDEFAULT);
                return;
            case Common_TestprofilePackage.TPF_LOOP_EVENT__EXECUTION_HISTORY:
                setExecutionHistory((TPFExecutionHistory)null);
                return;
            case Common_TestprofilePackage.TPF_LOOP_EVENT__INTERACTION_FRAGMENT:
                setInteractionFragment((BVRInteractionFragment)null);
                return;
            case Common_TestprofilePackage.TPF_LOOP_EVENT__CHILDREN:
                getChildren().clear();
                return;
            case Common_TestprofilePackage.TPF_LOOP_EVENT__PARENT:
                setParent((TPFExecutionEvent)null);
                return;
            case Common_TestprofilePackage.TPF_LOOP_EVENT__PROPERTIES:
                getProperties().clear();
                return;
            case Common_TestprofilePackage.TPF_LOOP_EVENT__ANNOTATIONS:
                getAnnotations().clear();
                return;
            case Common_TestprofilePackage.TPF_LOOP_EVENT__ITERATIONS:
                setIterations(ITERATIONS_EDEFAULT);
                return;
            case Common_TestprofilePackage.TPF_LOOP_EVENT__ASYNCHRONOUS:
                setAsynchronous(ASYNCHRONOUS_EDEFAULT);
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public boolean eIsSet(EStructuralFeature eFeature)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_TestprofilePackage.TPF_LOOP_EVENT__ID:
                return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
            case Common_TestprofilePackage.TPF_LOOP_EVENT__DESCRIPTION:
                return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
            case Common_TestprofilePackage.TPF_LOOP_EVENT__NAME:
                return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
            case Common_TestprofilePackage.TPF_LOOP_EVENT__OWNER_ID:
                return OWNER_ID_EDEFAULT == null ? ownerId != null : !OWNER_ID_EDEFAULT.equals(ownerId);
            case Common_TestprofilePackage.TPF_LOOP_EVENT__TIMESTAMP:
                return timestamp != TIMESTAMP_EDEFAULT;
            case Common_TestprofilePackage.TPF_LOOP_EVENT__TEXT:
                return TEXT_EDEFAULT == null ? text != null : !TEXT_EDEFAULT.equals(text);
            case Common_TestprofilePackage.TPF_LOOP_EVENT__EVENT_TYPE:
                return EVENT_TYPE_EDEFAULT == null ? eventType != null : !EVENT_TYPE_EDEFAULT.equals(eventType);
            case Common_TestprofilePackage.TPF_LOOP_EVENT__EXECUTION_HISTORY:
                return getExecutionHistory() != null;
            case Common_TestprofilePackage.TPF_LOOP_EVENT__INTERACTION_FRAGMENT:
                return interactionFragment != null;
            case Common_TestprofilePackage.TPF_LOOP_EVENT__CHILDREN:
                return children != null && !children.isEmpty();
            case Common_TestprofilePackage.TPF_LOOP_EVENT__PARENT:
                return getParent() != null;
            case Common_TestprofilePackage.TPF_LOOP_EVENT__PROPERTIES:
                return properties != null && !properties.isEmpty();
            case Common_TestprofilePackage.TPF_LOOP_EVENT__ANNOTATIONS:
                return annotations != null && !annotations.isEmpty();
            case Common_TestprofilePackage.TPF_LOOP_EVENT__ITERATIONS:
                return iterations != ITERATIONS_EDEFAULT;
            case Common_TestprofilePackage.TPF_LOOP_EVENT__ASYNCHRONOUS:
                return asynchronous != ASYNCHRONOUS_EDEFAULT;
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public String toString()
    {
        if (eIsProxy()) return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (iterations: ");
        result.append(iterations);
        result.append(", asynchronous: ");
        result.append(asynchronous);
        result.append(')');
        return result.toString();
    }

} //TPFLoopEventImpl
