/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.sample.editor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.ui.editor.EditorExtension;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;

/**
 * Example of an editor extension.
 * 
 * @author marcelop
 * @since 0.0.1
 */
public class Extension1 
extends EditorExtension
{
	/**
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#createPages()
	 */
	public void createPages()
	{
		TPFTestSuite testSuite = (TPFTestSuite)getHyadesEditorPart().getEditorObject();
		getHyadesEditorPart().setTitle("Editor Extension1");
		
		Composite composite = new Composite(getHyadesEditorPart().getContainer(), SWT.NONE);
		composite.setLayout(new GridLayout(2, false));
		composite.setLayoutData(GridDataUtil.createFill());		
		getHyadesEditorPart().addPage(composite);
		
		Label label = new Label(composite, SWT.NONE);
		label.setText("Type:");
		Text text = new Text(composite, SWT.BORDER|SWT.SINGLE);
		text.setLayoutData(GridDataUtil.createHorizontalFill());
		if(testSuite.getType() != null) text.setText(testSuite.getType());
		text.setEditable(false);

		label = new Label(composite, SWT.NONE);
		label.setText("Name:");
		text = new Text(composite, SWT.BORDER|SWT.SINGLE);
		text.setLayoutData(GridDataUtil.createHorizontalFill());
		if(testSuite.getName() != null) text.setText(testSuite.getName());
		text.setEditable(false);

		label = new Label(composite, SWT.NONE);
		label.setText("Description:");
		text = new Text(composite, SWT.BORDER|SWT.MULTI);
		GridData gridData = GridDataUtil.createHorizontalFill();
		gridData.verticalSpan = 3;
		text.setLayoutData(gridData);
		if(testSuite.getDescription() != null) text.setText(testSuite.getDescription());
		text.setEditable(false);
	}

	/**
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#doSave(org.eclipse.core.runtime.IProgressMonitor)
	 */
	public void doSave(IProgressMonitor monitor)
	{

	}
	
	/**
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#getSelection()
	 */
	public IStructuredSelection getSelection()
	{
		return new StructuredSelection(getHyadesEditorPart().getEditorObject());
	}
}
