package org.eclipse.hyades.ui.sample.svg.generator;
/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

/**
 * Convenience class for creating SVG document generators.
 * 
 * @version 1.17.1.1
 * @see IGraphicDocumentGenerator 
 */
public abstract class SVGDocumentGeneratorFactory {
	/**
	 * Returns the <code>IGraphicDocumentGenerator</code> interface to an object 
	 * which generates the specified graphic type or <code>null</code> if the 
	 * type is not recognized.
	 * 
	 * @param generatorType one of the recognized graphic types
     * @return IGraphicDocumentGenerator the instantiated object	
     * @see IGraphicDocumentGenerator
     * @see IGraphicTypeConstants
     */
	public static IGraphicDocumentGenerator getGraphicDocumentGenerator(String generatorType) {
		IGraphicDocumentGenerator svgGenerator = null;
		
		if (generatorType.equals(IGraphicTypeConstants.LINE_CHART))
			svgGenerator = (IGraphicDocumentGenerator) new SVGLineChart();
		else if (generatorType.equals(IGraphicTypeConstants.AREA_CHART))
			svgGenerator = (IGraphicDocumentGenerator) new SVGAreaChart();
		else if (generatorType.equals(IGraphicTypeConstants.SCATTER_CHART))
			svgGenerator = (IGraphicDocumentGenerator) new SVGScatterChart();
		else if (generatorType.equals(IGraphicTypeConstants.GROUPBAR_CHART))
			svgGenerator = (IGraphicDocumentGenerator) new SVGGroupBarChart();
		else if (generatorType.equals(IGraphicTypeConstants.PIE_CHART))
			svgGenerator = (IGraphicDocumentGenerator) new SVGPieChart();
		else if (generatorType.equals(IGraphicTypeConstants.BAR_CHART))
			svgGenerator = (IGraphicDocumentGenerator) new SVGBarChart();	
		else if (generatorType.equals(IGraphicTypeConstants.STACKBAR_CHART))
			svgGenerator = (IGraphicDocumentGenerator) new SVGStackBarChart();	
		else if (generatorType.equals(IGraphicTypeConstants.METER))
			svgGenerator = (IGraphicDocumentGenerator) new SVGMeter();	
			
		return svgGenerator;	
	}

}

