/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;
import org.eclipse.hyades.loaders.hierarchy.Constants;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForLockEvent;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.impl.TRCFullHeapObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCFullTraceObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCHeapObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCThreadImpl;
public class XMLmonContendedEnterLoader extends TraceXMLFragmentLoader {
	//~ Static fields/initializers
	// -----------------------------------------------------------------
	protected static final String THREAD_OWNER = "threadOwner";
	//~ Instance fields
	// ----------------------------------------------------------------------------
	protected int threadOwner;
	//~ Methods
	// ------------------------------------------------------------------------------------
	public void addAttribute(String name, String value) {
		switch (LoadersUtils.getHashCode(name)) {
			case TraceConstants.THREAD_OWNER_int :
				threadOwner = Integer.parseInt(value);
				break;
			default :
				super.addAttribute(name, value);
				break;
		}
	}
	public void addYourselfInContext() {
		theProcess = getProcess();
		theThread = getThreadByIdRef(theProcess);
		dispatchProcessMode(ProcessSteps.ALL);
		TRCThreadWaitingForLockEvent threadWaitingForLockEvent = TraceFactory.eINSTANCE.createTRCThreadWaitingForLockEvent();
		threadWaitingForLockEvent.setLockedObject(theObject);
		threadWaitingForLockEvent.setThread(theThread);
		threadWaitingForLockEvent.setTime(createDeltaTime());//time);
		if (threadOwner > 0) {
			TRCThread thread = (TRCThread) LookupServiceExtensions.getInstance().locate(context, TRCThreadImpl.class, LoadersUtils.getLookUpKey(threadOwner));
			threadWaitingForLockEvent.setLockingThread(thread);
		}
		theThread.getThreadEvents().add(threadWaitingForLockEvent);
	}
	public void initialize(HierarchyContext context, String name) {
		loadToModel = context.isLoadToModel();
		super.initialize(context, name);
		threadOwner = 0;
	}
	protected void processEF(int step) {
		super.processEF(step);
		if ((theObject == null) || !(theObject instanceof TRCFullTraceObject)) {
			theObject = (TRCFullTraceObject) LookupServiceExtensions.getInstance().locate(context, TRCFullTraceObjectImpl.class, LoadersUtils.getLookUpKey(objIdRef));
		}
	}
	/**
	 *  
	 */
	protected void processES(int step) {
		super.processES(step);
		if (objIdRef > 0) {
			virtualObject = (VirtualObjectInfo) LookupServiceExtensions.getInstance().locate(context, VirtualObjectInfo.class, LoadersUtils.getLookUpKey(objIdRef));
			if (virtualObject != null) {
				theObject = getClassObject(virtualObject.myClass, TRCFullTraceObjectImpl.class);
			} else {
				return;
			}
		} else {
			theObject = getClassObject(theClass, TRCFullTraceObjectImpl.class);
		}
	}
	/**
	 *  
	 */
	protected void processHF(int step) {
		super.processHF(step);
		Class clazz = (TraceUtils.isBooleanOptionEnabled(context,Constants.MULTIPLE_HEAP_DUMPS) ? TRCFullHeapObjectImpl.class : TRCHeapObjectImpl.class);
		if ((theObject == null) || !(theObject instanceof TRCHeapObject)) {
			theObject = (TRCHeapObject) LookupServiceExtensions.getInstance().locate(context, clazz, LoadersUtils.getLookUpKey(objIdRef));
		}
	}
}