/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.trace.TRCAggregatedMethodInvocation;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCTraceObject;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Aggregated Method Invocation</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCAggregatedMethodInvocationImpl#getCount <em>Count</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCAggregatedMethodInvocationImpl extends TRCMethodInvocationImpl implements TRCAggregatedMethodInvocation {
	/**
	 * The default value of the '{@link #getCount() <em>Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCount()
	 * @generated
	 * @ordered
	 */
	protected static final int COUNT_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getCount() <em>Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCount()
	 * @generated
	 * @ordered
	 */
	protected int count = COUNT_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCAggregatedMethodInvocationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return TracePackage.eINSTANCE.getTRCAggregatedMethodInvocation();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getCount() {
		return count;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCount(int newCount) {
		int oldCount = count;
		count = newCount;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__COUNT, oldCount, count));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__METHOD:
					if (method != null)
						msgs = ((InternalEObject)method).eInverseRemove(this, TracePackage.TRC_METHOD__INVOCATIONS, TRCMethod.class, msgs);
					return basicSetMethod((TRCMethod)otherEnd, msgs);
				case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__INVOKED_BY:
					if (invokedBy != null)
						msgs = ((InternalEObject)invokedBy).eInverseRemove(this, TracePackage.TRC_METHOD_INVOCATION__INVOKES, TRCMethodInvocation.class, msgs);
					return basicSetInvokedBy((TRCMethodInvocation)otherEnd, msgs);
				case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__INVOKES:
					return ((InternalEList)getInvokes()).basicAdd(otherEnd, msgs);
				case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__PROCESS:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__PROCESS, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__METHOD:
					return basicSetMethod(null, msgs);
				case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__INVOKED_BY:
					return basicSetInvokedBy(null, msgs);
				case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__INVOKES:
					return ((InternalEList)getInvokes()).basicRemove(otherEnd, msgs);
				case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__PROCESS:
					return eBasicSetContainer(null, TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__PROCESS, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__PROCESS:
					return ((InternalEObject)eContainer).eInverseRemove(this, TracePackage.TRC_PROCESS__INVOCATIONS, TRCProcess.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__METHOD:
				if (resolve) return getMethod();
				return basicGetMethod();
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__INVOKED_BY:
				if (resolve) return getInvokedBy();
				return basicGetInvokedBy();
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__INVOKES:
				return getInvokes();
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__THREAD:
				if (resolve) return getThread();
				return basicGetThread();
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__PROCESS:
				return getProcess();
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__OWNING_OBJECT:
				if (resolve) return getOwningObject();
				return basicGetOwningObject();
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__COUNT:
				return new Integer(getCount());
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__METHOD:
				setMethod((TRCMethod)newValue);
				return;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__INVOKED_BY:
				setInvokedBy((TRCMethodInvocation)newValue);
				return;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__INVOKES:
				getInvokes().clear();
				getInvokes().addAll((Collection)newValue);
				return;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__THREAD:
				setThread((TRCThread)newValue);
				return;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__PROCESS:
				setProcess((TRCProcess)newValue);
				return;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__OWNING_OBJECT:
				setOwningObject((TRCTraceObject)newValue);
				return;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__COUNT:
				setCount(((Integer)newValue).intValue());
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__METHOD:
				setMethod((TRCMethod)null);
				return;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__INVOKED_BY:
				setInvokedBy((TRCMethodInvocation)null);
				return;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__INVOKES:
				getInvokes().clear();
				return;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__THREAD:
				setThread((TRCThread)null);
				return;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__PROCESS:
				setProcess((TRCProcess)null);
				return;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__OWNING_OBJECT:
				setOwningObject((TRCTraceObject)null);
				return;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__COUNT:
				setCount(COUNT_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__METHOD:
				return method != null;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__INVOKED_BY:
				return invokedBy != null;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__INVOKES:
				return invokes != null && !invokes.isEmpty();
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__THREAD:
				return thread != null;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__PROCESS:
				return getProcess() != null;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__OWNING_OBJECT:
				return owningObject != null;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__COUNT:
				return count != COUNT_EDEFAULT;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (count: ");
		result.append(count);
		result.append(')');
		return result.toString();
	}

} //TRCAggregatedMethodInvocationImpl
