/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCThreadSleepingEvent;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Thread Sleeping Event</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCThreadSleepingEventImpl#getSleepingTime <em>Sleeping Time</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCThreadSleepingEventImpl extends TRCThreadEventImpl implements TRCThreadSleepingEvent {
	/**
	 * The default value of the '{@link #getSleepingTime() <em>Sleeping Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSleepingTime()
	 * @generated
	 * @ordered
	 */
	protected static final long SLEEPING_TIME_EDEFAULT = 0L;

	/**
	 * The cached value of the '{@link #getSleepingTime() <em>Sleeping Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSleepingTime()
	 * @generated
	 * @ordered
	 */
	protected long sleepingTime = SLEEPING_TIME_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCThreadSleepingEventImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return TracePackage.eINSTANCE.getTRCThreadSleepingEvent();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public long getSleepingTime() {
		return sleepingTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSleepingTime(long newSleepingTime) {
		long oldSleepingTime = sleepingTime;
		sleepingTime = newSleepingTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_THREAD_SLEEPING_EVENT__SLEEPING_TIME, oldSleepingTime, sleepingTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_THREAD_SLEEPING_EVENT__THREAD:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, TracePackage.TRC_THREAD_SLEEPING_EVENT__THREAD, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_THREAD_SLEEPING_EVENT__THREAD:
					return eBasicSetContainer(null, TracePackage.TRC_THREAD_SLEEPING_EVENT__THREAD, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case TracePackage.TRC_THREAD_SLEEPING_EVENT__THREAD:
					return ((InternalEObject)eContainer).eInverseRemove(this, TracePackage.TRC_THREAD__THREAD_EVENTS, TRCThread.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_THREAD_SLEEPING_EVENT__TIME:
				return new Double(getTime());
			case TracePackage.TRC_THREAD_SLEEPING_EVENT__THREAD:
				return getThread();
			case TracePackage.TRC_THREAD_SLEEPING_EVENT__SLEEPING_TIME:
				return new Long(getSleepingTime());
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_THREAD_SLEEPING_EVENT__TIME:
				setTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_THREAD_SLEEPING_EVENT__THREAD:
				setThread((TRCThread)newValue);
				return;
			case TracePackage.TRC_THREAD_SLEEPING_EVENT__SLEEPING_TIME:
				setSleepingTime(((Long)newValue).longValue());
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_THREAD_SLEEPING_EVENT__TIME:
				setTime(TIME_EDEFAULT);
				return;
			case TracePackage.TRC_THREAD_SLEEPING_EVENT__THREAD:
				setThread((TRCThread)null);
				return;
			case TracePackage.TRC_THREAD_SLEEPING_EVENT__SLEEPING_TIME:
				setSleepingTime(SLEEPING_TIME_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_THREAD_SLEEPING_EVENT__TIME:
				return time != TIME_EDEFAULT;
			case TracePackage.TRC_THREAD_SLEEPING_EVENT__THREAD:
				return getThread() != null;
			case TracePackage.TRC_THREAD_SLEEPING_EVENT__SLEEPING_TIME:
				return sleepingTime != SLEEPING_TIME_EDEFAULT;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (sleepingTime: ");
		result.append(sleepingTime);
		result.append(')');
		return result.toString();
	}

} //TRCThreadSleepingEventImpl
