/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EcoreUtil;

import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForObjectEvent;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Thread Waiting For Object Event</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCThreadWaitingForObjectEventImpl#getTimeout <em>Timeout</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCThreadWaitingForObjectEventImpl#getObjectWaitingFor <em>Object Waiting For</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCThreadWaitingForObjectEventImpl extends TRCThreadEventImpl implements TRCThreadWaitingForObjectEvent {
	/**
	 * The default value of the '{@link #getTimeout() <em>Timeout</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimeout()
	 * @generated
	 * @ordered
	 */
	protected static final long TIMEOUT_EDEFAULT = 0L;

	/**
	 * The cached value of the '{@link #getTimeout() <em>Timeout</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimeout()
	 * @generated
	 * @ordered
	 */
	protected long timeout = TIMEOUT_EDEFAULT;

	/**
	 * The cached value of the '{@link #getObjectWaitingFor() <em>Object Waiting For</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getObjectWaitingFor()
	 * @generated
	 * @ordered
	 */
	protected TRCObject objectWaitingFor = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCThreadWaitingForObjectEventImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return TracePackage.eINSTANCE.getTRCThreadWaitingForObjectEvent();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public long getTimeout() {
		return timeout;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTimeout(long newTimeout) {
		long oldTimeout = timeout;
		timeout = newTimeout;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_THREAD_WAITING_FOR_OBJECT_EVENT__TIMEOUT, oldTimeout, timeout));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCObject getObjectWaitingFor() {
		if (objectWaitingFor != null && objectWaitingFor.eIsProxy()) {
			TRCObject oldObjectWaitingFor = objectWaitingFor;
			objectWaitingFor = (TRCObject)eResolveProxy((InternalEObject)objectWaitingFor);
			if (objectWaitingFor != oldObjectWaitingFor) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_THREAD_WAITING_FOR_OBJECT_EVENT__OBJECT_WAITING_FOR, oldObjectWaitingFor, objectWaitingFor));
			}
		}
		return objectWaitingFor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCObject basicGetObjectWaitingFor() {
		return objectWaitingFor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setObjectWaitingFor(TRCObject newObjectWaitingFor) {
		TRCObject oldObjectWaitingFor = objectWaitingFor;
		objectWaitingFor = newObjectWaitingFor;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_THREAD_WAITING_FOR_OBJECT_EVENT__OBJECT_WAITING_FOR, oldObjectWaitingFor, objectWaitingFor));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_THREAD_WAITING_FOR_OBJECT_EVENT__THREAD:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, TracePackage.TRC_THREAD_WAITING_FOR_OBJECT_EVENT__THREAD, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_THREAD_WAITING_FOR_OBJECT_EVENT__THREAD:
					return eBasicSetContainer(null, TracePackage.TRC_THREAD_WAITING_FOR_OBJECT_EVENT__THREAD, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case TracePackage.TRC_THREAD_WAITING_FOR_OBJECT_EVENT__THREAD:
					return ((InternalEObject)eContainer).eInverseRemove(this, TracePackage.TRC_THREAD__THREAD_EVENTS, TRCThread.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_THREAD_WAITING_FOR_OBJECT_EVENT__TIME:
				return new Double(getTime());
			case TracePackage.TRC_THREAD_WAITING_FOR_OBJECT_EVENT__THREAD:
				return getThread();
			case TracePackage.TRC_THREAD_WAITING_FOR_OBJECT_EVENT__TIMEOUT:
				return new Long(getTimeout());
			case TracePackage.TRC_THREAD_WAITING_FOR_OBJECT_EVENT__OBJECT_WAITING_FOR:
				if (resolve) return getObjectWaitingFor();
				return basicGetObjectWaitingFor();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_THREAD_WAITING_FOR_OBJECT_EVENT__TIME:
				setTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_THREAD_WAITING_FOR_OBJECT_EVENT__THREAD:
				setThread((TRCThread)newValue);
				return;
			case TracePackage.TRC_THREAD_WAITING_FOR_OBJECT_EVENT__TIMEOUT:
				setTimeout(((Long)newValue).longValue());
				return;
			case TracePackage.TRC_THREAD_WAITING_FOR_OBJECT_EVENT__OBJECT_WAITING_FOR:
				setObjectWaitingFor((TRCObject)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_THREAD_WAITING_FOR_OBJECT_EVENT__TIME:
				setTime(TIME_EDEFAULT);
				return;
			case TracePackage.TRC_THREAD_WAITING_FOR_OBJECT_EVENT__THREAD:
				setThread((TRCThread)null);
				return;
			case TracePackage.TRC_THREAD_WAITING_FOR_OBJECT_EVENT__TIMEOUT:
				setTimeout(TIMEOUT_EDEFAULT);
				return;
			case TracePackage.TRC_THREAD_WAITING_FOR_OBJECT_EVENT__OBJECT_WAITING_FOR:
				setObjectWaitingFor((TRCObject)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_THREAD_WAITING_FOR_OBJECT_EVENT__TIME:
				return time != TIME_EDEFAULT;
			case TracePackage.TRC_THREAD_WAITING_FOR_OBJECT_EVENT__THREAD:
				return getThread() != null;
			case TracePackage.TRC_THREAD_WAITING_FOR_OBJECT_EVENT__TIMEOUT:
				return timeout != TIMEOUT_EDEFAULT;
			case TracePackage.TRC_THREAD_WAITING_FOR_OBJECT_EVENT__OBJECT_WAITING_FOR:
				return objectWaitingFor != null;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (timeout: ");
		result.append(timeout);
		result.append(')');
		return result.toString();
	}

} //TRCThreadWaitingForObjectEventImpl
