/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.harness;

import org.eclipse.hyades.execution.core.IExecutableObject;
import org.eclipse.hyades.execution.local.JavaProcessExecutableObjectStub;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;

/**
 * This is an adapter that knows how to configure the ManualProcessExecutorImpl
 * at runtime.
 * 
 * @author marcelop
 * @since 1.0.2
 */
public class ManualExecutableObjectAdapter
implements IExecutableObjectAdapter
{
	public final static String TEST_SCRIPT_PROPERTY_NAME = "testScript";
	
	/**
	 * @see org.eclipse.hyades.execution.harness.IExecutableObjectAdapter#setupExecutableObject(org.eclipse.hyades.execution.core.IExecutableObject, org.eclipse.hyades.models.common.testprofile.TPFTestSuite, org.eclipse.hyades.models.common.testprofile.TPFTest)
	 */
	public void setupExecutableObject(IExecutableObject execObj, CFGClass rootResource, IImplementor theImplementor, TPFDeployment deployment)
	throws ClassCastException
	{
		JavaProcessExecutableObjectStub objectStub = (JavaProcessExecutableObjectStub)execObj;
		objectStub.setArgs("org.eclipse.hyades.test.manual.runner.HyadesManualRunner " + rootResource.getId());
		objectStub.setAgentData(getScript(theImplementor));
	}
	
	protected String getScript(IImplementor theImplementor)
	{
		return theImplementor.getResource();
	}
}