/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sdb.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.*;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class SDbPluginImages {

  private static URL fgIconBaseURL= null;

	static {
		String pathSuffix= "icons/full/"; //$NON-NLS-1$
		try {
			fgIconBaseURL= new URL(SDbPlugin.getDefault().getDescriptor().getInstallURL(), pathSuffix);
		} catch (MalformedURLException e) {
			
			e.printStackTrace();
		}
	}  
	
	/*
	 * Set of predefined Image Descriptors.
	 * the following String are all $NON-NLS-1$
	 */
	public static final String T_OBJ		= "obj16"; //$NON-NLS-1$
	public static final String T_WIZBAN	= "wizban"; //$NON-NLS-1$

	public static final String IMG_IMPORT_LOG = "importactivitylog_wiz.gif";//$NON-NLS-1$
	public static final String IMG_NEW_DB_WIZ_BAN = "new_symptomdb_wiz.gif";//$NON-NLS-1$	
	public static final String IMG_IMPORT_DB_WIZ_BAN = "import_symptomdb_wiz.gif";//$NON-NLS-1$	
	public static final String IMG_EXPORT_DB_WIZ_BAN = "export_symptomdb_wiz.gif";//$NON-NLS-1$	
	public static final String IMG_SYMPTOM_DB = "symptomdb_obj.gif"; //$NON-NLS-1$
	public static final String IMG_SYMPTOM_SOL = "symptomdb_solution_obj.gif"; //$NON-NLS-1$
	public static final String IMG_SYMPTOM_DESC = "symptomdb_desc_obj.gif"; //$NON-NLS-1$
	public static final String IMG_DB_EDITOR_BAN = "page_banner.gif";//$NON-NLS-1$
	public static final String IMG_SYMPTOM_DIRECTIVE = "trcdirective_obj.gif";//$NON-NLS-1$		
		    	
   public static final ImageDescriptor DESC_IMG_NEW_DB_WIZ_BAN = createManaged(T_WIZBAN,IMG_NEW_DB_WIZ_BAN);//$NON-NLS-1$      
   public static final ImageDescriptor DESC_IMG_IMPORT_DB_WIZ_BAN = createManaged(T_WIZBAN,IMG_IMPORT_DB_WIZ_BAN);//$NON-NLS-1$      
   public static final ImageDescriptor DESC_IMG_EXPORT_DB_WIZ_BAN = createManaged(T_WIZBAN,IMG_EXPORT_DB_WIZ_BAN);//$NON-NLS-1$         
   public static final ImageDescriptor DESC_IMG_SYMPTOM_DB = createManaged(T_OBJ,IMG_SYMPTOM_DB);//$NON-NLS-1$
   public static final ImageDescriptor DESC_IMG_SYMPTOM_SOL = createManaged(T_OBJ,IMG_SYMPTOM_SOL);//$NON-NLS-1$
   public static final ImageDescriptor DESC_IMG_SYMPTOM_DESC = createManaged(T_OBJ,IMG_SYMPTOM_DESC);//$NON-NLS-1$
   public static final ImageDescriptor DESC_IMG_DB_EDITOR_BAN = createManaged(T_WIZBAN,IMG_DB_EDITOR_BAN);//$NON-NLS-1$   
   public static final ImageDescriptor DESC_IMG_SYMPTOM_DIRECTIVE = createManaged(T_OBJ,IMG_SYMPTOM_DIRECTIVE);//$NON-NLS-1$   

	protected static HashMap _images;
	protected static HashMap _imageDescriptors;	

	public static Image getImage(String name)
	{
		return (Image)_images.get(name);
	}


	/**
	 * Insert the method's description here.
	 * Creation date: (2/16/2001 4:57:29 PM)
	 * @return com.ibm.jface.resource.ImageDescriptor
	 * @param name java.lang.String
	 */
	public static ImageDescriptor getImageDescriptor(String name) {
		
		return (ImageDescriptor) _imageDescriptors.get(name);
	}

	private static ImageDescriptor createManaged(String prefix, String name) {
		try {
			ImageDescriptor result =
				ImageDescriptor.createFromURL(makeIconFileURL(prefix, name));

			if (_images == null || _imageDescriptors == null) {
				_images = new HashMap();
				_imageDescriptors = new HashMap();
			}

			_imageDescriptors.put(name, result);
			_images.put(name, result.createImage());
			return result;

		} catch (MalformedURLException e) {
			return ImageDescriptor.getMissingImageDescriptor();
		}
	}

	public static void setImageDescriptors(
		IAction action,
		String type,
		String relPath) {
		try {
			ImageDescriptor id =
				ImageDescriptor.createFromURL(makeIconFileURL("d" + type, relPath));
			//$NON-NLS-1$
			if (id != null) {
				action.setDisabledImageDescriptor(id);
			}
		} catch (MalformedURLException e) {
		}

		try {
			ImageDescriptor id =
				ImageDescriptor.createFromURL(makeIconFileURL("c" + type, relPath));//$NON-NLS-1$
			if (id != null) {
				action.setHoverImageDescriptor(id);
			}
		} catch (MalformedURLException e) {
		}

		action.setImageDescriptor(create("e" + type, relPath)); //$NON-NLS-1$
	}

	private static URL makeIconFileURL(String prefix, String name)
		throws MalformedURLException {
		if (fgIconBaseURL == null)
			throw new MalformedURLException();

		StringBuffer buffer;
		if (prefix != null) {
			buffer = new StringBuffer(prefix);
			buffer.append('/');
			buffer.append(name);
		} else {
			buffer = new StringBuffer(name);
		}
		return new URL(fgIconBaseURL, buffer.toString());
	}
	
	private static ImageDescriptor create(String prefix, String name) {
		try {
			return ImageDescriptor.createFromURL(makeIconFileURL(prefix, name));
		} catch (MalformedURLException e) {
			return ImageDescriptor.getMissingImageDescriptor();
		}
	}	
	
	public static void shutdown() {
		if (_images == null)
			return;

		for (Iterator e = _images.values().iterator(); e.hasNext();) {
			Object next = e.next();
			if (next instanceof Image && !((Image) next).isDisposed()) {
				((Image) next).dispose();
			}
		}

		_images.clear();
		_images = null;
		_imageDescriptors.clear();
		_imageDescriptors = null;
	}
}
