/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.execution.local;

import java.net.UnknownHostException;
import java.security.Principal;

import org.eclipse.hyades.execution.core.DaemonConnectException;
import org.eclipse.hyades.execution.core.ExecutionComponentStateChangeEvent;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.IExecutionComponentStateChangeListener;
import org.eclipse.hyades.execution.core.ISession;
import org.eclipse.hyades.execution.core.UnknownDaemonException;

/**
 * This class extends the default NodeImpl class by overriding the connect method.
 * in this implementation, it allows for session reuse. Connect method will return an
 * existing session if an appropriate session already exists.
 * */
public class HyadesTestNodeImpl extends NodeImpl {

	/**
	 * @param name
	 */
	public HyadesTestNodeImpl(String name) {
		super(name);
		// TODO Auto-generated constructor stub
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.core.INode#connect(java.lang.String, java.security.Principal)
	 */
	public ISession connect(String daemonType, Principal principal)
		throws UnknownDaemonException, DaemonConnectException, UnknownHostException {

		SessionContext ctx = new SessionContext(getName(), daemonType, principal);
		final SessionContextToSessionMap sessionCache = SessionContextToSessionMap.getInstance();
		ISession session = sessionCache.getSessionEntry(ctx);

		// TODO should the state of the session be checked here?
		if (session == null){
			session = super.connect(daemonType, principal);
			if (session != null){
				/* Add a state change listener to the ISession so we know when the session is dead so it can be removed from the map */
				session.addExecutionComponentStateChangeListener(new IExecutionComponentStateChangeListener() {
					public void stateChanged(ExecutionComponentStateChangeEvent event) {
						if(event.getState()==IExecutionComponent.DEAD) {
							ISession session = (ISession) event.getComponent();
							sessionCache.removeSessionEntry(session);
						}	
					}
				});
				sessionCache.addSessionEntry(ctx, session); 
			}
		}
		
		return session;
	}
	
}