/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.ui.internal.views;

import java.util.HashMap;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType;

public class AcadGuiModelManager {
	
	//map of current models, map by the configuration file
	private static HashMap modelMap = new HashMap();
	//model mapping to the current adapter editor
	private static AcadGuiModel currentModel;
	
	public static final void disposeModel(IFile file)
	{
		
		if(file == null || modelMap == null)
		  return;
		  
		String fileName = file.getFullPath().toOSString();
		
		Object[] keys = modelMap.keySet().toArray();
		for(int i=0; i<keys.length; i++)
		{
			ContextInstanceType context = (ContextInstanceType) keys[i];
			
			if(context.eResource() == null)
			{
				Object model = modelMap.get(context);
				if(model != null)
				{
					((AcadGuiModel)model).dispose();
					
					if(currentModel == model)
					  currentModel = null;
					  
					modelMap.remove(context);					
				}

			}
			else
			{
				String path = context.eResource().getURI().path();
				if(path.startsWith("/resource"))
				  path = path.substring(9);
				
				IPath ipath = new Path(path);
				
				if(ipath.toOSString().equals(fileName))
				{  
					Object model = modelMap.get(context);
					if(model != null)
					{
						((AcadGuiModel)model).dispose();
					
						if(currentModel == model)
						  currentModel = null;
					  
						modelMap.remove(context);					
					}					
				}
			}
		}
		
		LogView logView = LogView.getLogView(false);				
		if(logView != null)
		  logView.set_Title();		  
	}
	
	public static final void setCurrentModel(ContextInstanceType context)
	{
		boolean isNewModel = false;
		AcadGuiModel model = null;
		Object obj = modelMap.get(context);
		if(obj == null)
		{
			model = new AcadGuiModel();
			model.setContextInstance(context);
			modelMap.put(context, model);
			isNewModel = true;
		}
		else
		  model = (AcadGuiModel)obj;
		
		if(currentModel != null && currentModel.getContextInstance() == model.getContextInstance())
		  return;

		currentModel = model;

    	model.updateTestShow();
    	model.updateResult();
       
		LogView logView = LogView.getLogView(true);				
		if(logView != null)
		{
			logView.set_Title();
		}
		
	}

    public static final AcadGuiModel getCurrentModel()
    {
    	return currentModel;
    }
    
	public static final AcadGuiModel getModel(ContextInstanceType context)
	{
		if(context == null)
		  return null;
		  
		return (AcadGuiModel)modelMap.get(context);
	}
    
    /**
     * Returns the template log file associated with this adapter model
     * @param model - the model for the current adapter configuration
     * @return template log file associated with the current configuration
     */
    public static final SensorConfigType getLogForConfiguration(AcadGuiModel model)
    {
		if(model == null || model.getContextInstance() == null
		   || model.getContextInstance().eContainer() == null)
		  return null;
    	
    	return model.getContextInstance().getSensor();
    }
    
}
