/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.perfmon;

import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.*;
import org.eclipse.core.runtime.*;
import org.eclipse.core.runtime.jobs.*;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.*;

import org.eclipse.core.resources.*;

import org.eclipse.emf.common.util.*;
import org.eclipse.emf.ecore.resource.*;
import org.eclipse.emf.ecore.resource.impl.*;
import org.eclipse.hyades.trace.internal.ui.PDPerspective;
import org.eclipse.hyades.trace.ui.UIPlugin;


public class PerfmonLauncher implements ILaunchConfigurationDelegate {

	

	/**
	 * Open Profiling Monitor view
	 */
	private void openProfilingView() {
		
        Display.getDefault().syncExec(new Runnable() {
        	public void run() {
        		try{
        			UIPlugin.getActivePage().showView(PDPerspective.ID_PD_NAVIGATOR_VIEW);
        		} catch (Exception exc) {
        			exc.printStackTrace();
        		}
        	}
        });
	}

	class PerfmonLaunchJob extends Job {
		String rac_host, reg_host;
		URI smodel_uri, monitor_uri;
		public PerfmonLaunchJob(String rac_host, String reg_host, URI smodel_uri, URI monitor_uri) {
			super(PerfmonPlugin.getString("PROGRESS_LAUNCHING"));
			this.rac_host = rac_host;
			this.reg_host = reg_host;
			this.smodel_uri = smodel_uri;
			this.monitor_uri = monitor_uri;
		}
		public IStatus run(IProgressMonitor monitor) {
			PerfmonModuleTrace trace = new PerfmonModuleTrace(monitor,rac_host,reg_host,smodel_uri,monitor_uri);
			
			return new Status(IStatus.OK,"org.eclipse.hyades.perfmon",IStatus.OK,"",null);
		}
	}
	
	public void launch(ILaunchConfiguration conf, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
		
		IWorkbench workbench = PlatformUI.getWorkbench();
		workbench.getDisplay().syncExec(new StatConRun(conf,monitor));
	}

	private Resource createResource(URI uri) {

		ResourceSet resourceSet = new ResourceSetImpl();
		Resource resource = resourceSet.getResource(uri,false);
		if (resource == null) return resourceSet.createResource(uri);
		return resource;		
	}
	
	class StatConRun implements Runnable {
		IProgressMonitor monitor;
		ILaunchConfiguration conf;
		public StatConRun(ILaunchConfiguration conf,IProgressMonitor monitor) {
			this.monitor = monitor;
			this.conf = conf;
		}
		public void run() {
			try {

				monitor.setTaskName(PerfmonPlugin.getString("PROGRESS_GETCONFIGS"));

				//get necessary connection info
				IPath smodel_path = new Path(conf.getAttribute("smodel_container","")); 
				PerfmonPlugin.DBG.info("PERFMON SMODEL PATH = "+smodel_path);

				String spath = smodel_path.toString().replaceFirst("platform:/resource/","");

// we may or may not have the platform:/resource thing
				URI smodel_uri = URI.createPlatformResourceURI(spath);
				PerfmonPlugin.DBG.info("PERFMON plat SMODEL URI = "+smodel_uri);
//				if (smodel_path.toString().toLowerCase().startsWith("platform:/resource/")) {
//					smodel_uri = URI.createURI(spath);
//					PerfmonPlugin.DBG.info("PERFMON SMODEL URI = "+smodel_uri);
//				}
								
				String rac_host = conf.getAttribute("host_rac","");
				String reg_host = conf.getAttribute("host_reg","");
				
				if (!conf.getAttribute("hosts_same",false)) {
					reg_host = rac_host;
				}
				
				IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();

				//create the project if necessary
				String project = smodel_uri.toString().replaceFirst("platform:/resource/","");
				PerfmonPlugin.DBG.info("profiling project = "+project);
				
				if (project.indexOf('/') != -1) {
					project = project.substring(0,project.indexOf('/')+1);
				}
				PerfmonPlugin.DBG.info("profiling project = "+project);
				IProject pproject = workspaceRoot.getProject(project);
				if (!pproject.exists()) {
					pproject.create(null);
					PerfmonPlugin.DBG.info("created project OK");
				}
				
				pproject.open(null);
				
				//create any folders under the project
				try {
					String folderpath = smodel_uri.toString().replaceFirst("platform:/resource/","/");
					PerfmonPlugin.DBG.info("profiling project Folder path = "+folderpath);
					IPath path = new Path(folderpath);
					PerfmonPlugin.DBG.info("profiling project IPath = "+path);

					if (path.segmentCount() > 1) {
						PerfmonPlugin.DBG.info("profiling container is subfolder within project - creating if necessary now");
						//user has specified a project and one or more folders in the project as the container
						IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
						if (!folder.exists()) {
//							pproject.open(null);
							folder.create(true,true,null);
							PerfmonPlugin.DBG.info("created subfolder ok");
						}
					} else {
						PerfmonPlugin.DBG.info("profiling container is top level project");
					}
					
				} catch (Exception e) {
					e.printStackTrace();
				}
					

//			Path container_savepath = null;
//			IContainer container = null;
//				try {
//				container_savepath = new Path(""+container_text.getText());
//				container = workspaceRoot.getFolder(container_savepath);

				String tmonitor = conf.getAttribute("monitor",PerfmonPlugin.getString("DEFAULT_MONITOR"));
				URI monitor_uri = null;
				if (tmonitor.indexOf('/') != -1 || tmonitor.indexOf('\\') != -1) {
//				if (tmonitor.startsWith("platform:/resource/")) {
					//user specified a path
					if (!tmonitor.toLowerCase().endsWith(".trcmxmi")) {
						tmonitor += ".trcmxmi";
					}
					monitor_uri = URI.createPlatformResourceURI(tmonitor);
				} else {
					//user specified a name, not a path
					tmonitor = smodel_uri.toString()+"/"+tmonitor;
					if (!tmonitor.toLowerCase().endsWith(".trcmxmi")) {
						tmonitor += ".trcmxmi";
					}
					monitor_uri = URI.createURI(tmonitor);
				}
				
				PerfmonPlugin.DBG.info("MONITOR PATH = "+monitor_uri);

/*
				IPath path = new Path(conf.getAttribute("statcon_file","")); 
				createResource(URI.createPlatformResourceURI(path.toString()));
				IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);

				if (!file.exists()) {
					file.create(new ByteArrayInputStream(new byte[0]),true,null);
				}

				PerfmonPlugin.DBG.info("Launching statcon on file "+file);
				IEditorPart part = PerfmonLauncher.openInEditor(file,true);
				
				PerfmonPlugin.DBG.info("Got back StatCon EditorPart, null="+(part==null));
				
				StatisticalModelGraphEditor editor = (StatisticalModelGraphEditor)part;

				PerfmonPlugin.DBG.info("Got back StatCon Editor OK, null="+(part==null));

				StatConInterface statcon = editor.getStatCon();
				PerfmonStatConModule perfmon = (PerfmonStatConModule)statcon.getModuleByRef("org.eclipse.hyades.perfmon");

				PerfmonPlugin.DBG.info("Got Perfmon StatCon module, null="+(perfmon==null));
				
				perfmon.startPerfmonTrace(rac_host,reg_host,smodel_uri);
*/	
				IProgressMonitor pmonitor = Platform.getJobManager().createProgressGroup();
				pmonitor.beginTask(PerfmonPlugin.getString("PROGRESS_LAUNCHING"), IProgressMonitor.UNKNOWN);
				PerfmonLaunchJob job = new PerfmonLaunchJob(rac_host,reg_host,smodel_uri,monitor_uri);
				job.setProgressGroup(pmonitor,IProgressMonitor.UNKNOWN);
				job.schedule();
				
//				PerfmonModuleTrace trace = new PerfmonModuleTrace(monitor,rac_host,reg_host,smodel_uri);

				openProfilingView();
				
			} catch (Throwable t) {
				PerfmonPlugin.DBG.logVisibleError(t,PerfmonPlugin.getString("ERROR_LAUNCH_VIEW"),true);
			}
		}
	}

}