/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.remote;


/**
 * RemoteClientListener is an interface used to inform implementers
 * when a remote client has detached from the agent.  This can happen
 * either because the remote client has specified to detach and also
 * in cases where the remote client dies unexpectedly.  This is used
 * in conjuntion with the MonitorListener to determine what the
 * agents current state is.
 *
 * @version 0.0.1
 * Creation date: (2/19/02 7:55:57 PM)
 * @author: Richard K. Duggan
 */
public interface RemoteClientListener {

public void clientActive();

public void clientInactive();

}