/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui;

/**
 * A profile event describes an event in an application being profiled 
 * <p>
 * The <code>getSource()</code> method of a profile event
 * returns the element associated with the event.
 * </p>
 * <p>
 * The <code>getType()</code> method of a profile event
 * returns the type of the event.
 * </p>
 * <p>
 * Clients may instantiate this class. Clients are not intended to subclass this class.
 * </p>
 */
public final class ProfileEvent
{
	

	/**
	 * the source of the event
	 */
	private Object source;
	
	/**
	 * the type of the event
	 */
	private int type = UNSPECIFIED;
	
	/**
	 * Start Monitoring event type
	 */
	public static final int START_MONITOR= 0x0001;

	/**
	 * Stop Monitoring event type
	 */
	public static final int STOP_MONITOR= 0x0002;

	/**
	 * Attach event type
	 */
	public static final int ATTACH= 0x0004;

	/**
	 * Detach event type
	 */
	public static final int DETACH= 0x0008;
	
	/**
	 * Terminate event type
	 */
	public static final int TERMINATE= 0x0010;

	/**
	 * RefreshViews event type
	 */
	public static final int REFRESH_VIEWS = 0x0040;
	
	/**
	 * Update Model event type
	 */
	public static final int UPDATE_MODEL = 0x0020;

	/**
	 * Unspecified event type
	 */
	public static final int UNSPECIFIED= 0x0080;		
	
	/**
	 * Selection changed event type
	 */	
	public static final int SELECTION_CHANGED= 0x0100;
	
	/**
	 * Collecting event type
	 */	
	public static final int COLLECTING= 0x0200;
	
	/**
	 * Stop collecting event type
	 */	
	public static final int STOP_COLLECTING= 0x0400;
	
	/**
	 * Update node delta time event type
	 */	
	public static final int UPDATE_DELTA_TIME = 0x0800;

	/**
	 * Cleanup the actions
	 */	
	public static final int CLEAN_UP = 0x1000;
	
	/**
	 * Refreshes Log Navigator
	 *
	 */
	public static final int REFRESH_LOG_NAVIGATOR = 0x1200;
	
	/**
	 * Refreshes PD Explorer
	 *
	 */
	public static final int REFRESH_PD_EXPLORER = 0x1400;
	
	
	/**
	 * Constructs a default event, with no type and data specified
	 *
	 */
	public ProfileEvent() {
	}
	
	/**
	 * Constructs an event with a specified type
	 * 
	 * @param eventType the type of the event
	 */
	public ProfileEvent(int eventType)
	{
		type = eventType;
	}
					
	/**
	 * Returns this event's type - one of the type constants defined by this class.
	 * 
	 * @return the event type
	 */
	public int getType() {
		return type;
	}
	
	/**
	 * 
	 * @param tmpType set the event type - one of the type constants defined by this class.
	 */
	public void setType(int tmpType)
	{
		type = tmpType;
	}
	
	/**
	 * Return the source of this event
	 * 
	 * @return the source of the event
	 */
	public Object getSource()
	{
		return source;
	}
	
	/**
	 * Set the source of this event
	 * 
	 * @param eventSource the source of the event
	 */
	public void setSource(Object eventSource)
	{
		source = eventSource;
	}
	
}

