/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.actions;

import java.util.List;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.*;
import org.eclipse.ui.actions.SelectionProviderAction;

/*
* CONTEXT_ID refl0000 for refresh from local action
*/

public class RefreshFromLocalAction extends SelectionProviderAction
									implements ISelectionChangedListener
{
  private INavigator fViewer;

  public RefreshFromLocalAction(INavigator viewer)
  {
	super(viewer.getViewer(), UIPlugin.getResourceString("RELOAD"));
	setDescription(UIPlugin.getResourceString("RELOAD_LOCAL_FILE"));
	fViewer = viewer;

	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		this,
		UIPlugin.getPluginId()+".refl0000");
	
	setToolTipText(UIPlugin.getResourceString("RELOAD_LOCAL_FILE_TOOLTIP"));	
  }    
  public void run()
  {
	String title = UIPlugin.getResourceString("TRACE_MSG");	
	String msg = UIPlugin.getResourceString("RELOAD_QUESTION");
	
	if(! MessageDialog.openQuestion(fViewer.getViewSite().getShell(), title, msg))
		return;

	ProfileEvent event = new ProfileEvent();
	event.setSource(ResourcesPlugin.getWorkspace().getRoot());

	handleResources();
	
	event.setType(ProfileEvent.REFRESH_PD_EXPLORER);		
	UIPlugin.getDefault().notifyProfileEventListener(event);
	
	if(!(fViewer instanceof PDProjectExplorer))	{	
		event.setType(ProfileEvent.REFRESH_LOG_NAVIGATOR);
		UIPlugin.getDefault().notifyProfileEventListener(event);		
	}
  }  
  /**
 * 
 */

public void selectionChanged(IStructuredSelection selection)
  {
	setEnabled(true);
  }
  
  public void dispose() {
		
	  super.dispose();
		
	  fViewer = null;
  }
  
  private void handleResources(){

	PDContentProvider.resetMonitors();
	
	Object[] resources = HierarchyResourceSetImpl.getInstance().getResources().toArray();
	for (int idx=0;idx < resources.length;idx++) {

		Resource element = (Resource) resources[idx];
		if(element!=null && element.isLoaded()){
			Object[] elements = element.getContents().toArray();
			for(int i=0;i<elements.length;i++)
			{
				Object obj = elements[i];

				List deletelist = UIPlugin.getDefault().getDeleteListeners();
				for(int j=0; j<deletelist.size();j++)
				{
					((IDeleteListener)deletelist.get(j)).deregister(obj);
				}

				element.unload();		    						    
			}
		}
		
	}
  }

}
