/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher;

import org.eclipse.hyades.trace.ui.*;

/**
 * @author znensi
 *
 * Constants for storing profiling options/parameters in an <code>
 * ILaunchConfiguration</code>. All the data must be converted to string
 * form in order to persist after the workbench is shut down (no object
 * references allowed).
 * 
 * @see ILaunchConfiguration#getAttribute()
 * @see ILaunchConfiguration#setAttribute()
 */
public interface IProfileLaunchConfigurationConstants
{
	/**
	 * A <code>String</code> containing the hostname, e.g. "localhost".
	 */
	public static final String ATTR_HOSTNAME = UIPlugin.getPluginId() + ".ATTR_HOSTNAME";

	/**
	 * An <code>int</code> containing the port number, e.g. 10002.
	 */
	public static final String ATTR_PORT = UIPlugin.getPluginId() + ".ATTR_PORT";

	/**
	 * A <code>List</code> of agent strings of the form:
	 * "pid:agent1Name,agent2Name,..."
	 */
	public static final String ATTR_AGENTS = UIPlugin.getPluginId() + ".ATTR_AGENTS";

	/**
	 * A <code>String</code> containing the classpath as it would appear on
	 * the command line, e.g. ".:/dir:/dir/file.jar"
	 */
	public static final String ATTR_CLASSPATH = UIPlugin.getPluginId() + ".ATTR_CLASSPATH";

	/**
	 * A <code>List</code> of <code>String</code>s of the form: "name:value".
	 * These are environment variable names and values.
	 */
	public static final String ATTR_ENVIRONMENT_VARIABLES = UIPlugin.getPluginId() + ".ATTR_ENVIRONMENT_VARIABLES";
	
	/**
	 * A <code>String</code> containing the name of the project in which to
	 * store the profiling data, e.g. "ProfileProject".
	 */
	public static final String ATTR_DESTINATION_PROJECT = UIPlugin.getPluginId() + ".ATTR_DESTINATION_PROJECT";
	
	/**
	 * A <code>String</code> containing the name of the monitor to profile
	 * under, e.g. "DefaultMonitor".
	 */
	public static final String ATTR_DESTINATION_MONITOR = UIPlugin.getPluginId() + ".ATTR_DESTINATION_MONITOR";

	/**
	 * A <code>String</code> containing the name of the file to
	 * send profiling data to.
	 */
	public static final String ATTR_DESTINATION_FILE = UIPlugin.getPluginId() + ".ATTR_DESTINATION_FILE";

	/**
	 * A <code>boolean</code> specifying whether or not the
	 * profiling data should be written to a file.
	 */
	public static final String ATTR_PROFILE_TO_FILE = UIPlugin.getPluginId() + ".ATTR_PROFILE_TO_FILE";
	
	/**
	 * A <code>String</code> specifying the id of the active profiling
	 * set.
	 */
	public static final String ATTR_PROFILING_SET = UIPlugin.getPluginId() + ".ATTR_PROFILING_SET";

	/**
	 * A <code>String</code> specifying the id of the active filter
	 * set.
	 */
	public static final String ATTR_FILTER_SET = UIPlugin.getPluginId() + ".ATTR_FILTER_SET";

	/**
	 * A <code>boolean</code> specifying whether or not instance-level
	 * information should be collected for Heap.
	 */
	public static final String ATTR_SHOW_HEAP_INSTANCES = UIPlugin.getPluginId() + ".ATTR_SHOW_HEAP_INSTANCES";

	/**
	 * A <code>boolean</code> specifying whether or not instance-level
	 * information should be collected for Execition Flow.
	 */
	public static final String ATTR_SHOW_EXEC_INSTANCES = UIPlugin.getPluginId() + ".ATTR_SHOW_EXEC_INSTANCES";

	
	/**
	 * A <code>boolean</code> specifying <code>true</code> if the "Show
	 * Execution Statistics Details" box is checked, or <code>false</code> if
	 * the "Show Execution Flow" box is checked.
	 */
	public static final String ATTR_SHOW_EXECUTION_FLOW = UIPlugin.getPluginId() + ".ATTR_SHOW_EXECUTION_FLOW";

	/**
	 * A <code>boolean</code> specifying whether or not the number of method
	 * invocations should be limited.
	 */
	public static final String ATTR_PROFILING_LIMIT_INVOCATIONS = UIPlugin.getPluginId() + ".ATTR_PROFILING_LIMIT_INVOCATIONS";

	/**
	 * An <code>int</code> containing the number of method invocations to
	 * limit to (-1 if no limit).
	 */
	public static final String ATTR_PROFILING_LIMIT_INVOCATIONS_NUM = UIPlugin.getPluginId() + ".ATTR_PROFILING_LIMIT_INVOCATIONS_NUM";

	/**
	 * A <code>boolean</code> specifying whether or not the number of seconds
	 * to limit profiling to is selected.
	 */
	public static final String ATTR_PROFILING_LIMIT_SECONDS = UIPlugin.getPluginId() + ".ATTR_PROFILING_LIMIT_SECONDS";

	/**
	 * An <code>int</code> containing the number of seconds to profile for
	 * (-1 if no limit).
	 */
	public static final String ATTR_PROFILING_LIMIT_SECONDS_NUM = UIPlugin.getPluginId() + ".ATTR_PROFILING_LIMIT_SECONDS_NUM";
	
	/**
	 * A <code>boolean</code> specifying whether or not the agent should
	 * automatically start monitoring upon launch/attach.
	 */
	public static final String ATTR_AUTO_MONITORING = UIPlugin.getPluginId() + ".ATTR_AUTO_MONITORING";
}

