/*******************************************************************************
 * Copyright (c) 2000, 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.trace.ui.internal.preferences;

import java.util.ArrayList;
import java.util.Arrays;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceAssociationManager;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.extension.IAssociationMappingRegistry;
import org.eclipse.hyades.ui.internal.extension.AssociationMappingRegistry;
import org.eclipse.hyades.ui.internal.preference.AssociationMappingPreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;

/**
 * This class represents a preference page that
 * is contributed to the Preferences dialog. By 
 * subclassing <samp>FieldEditorPreferencePage</samp>, we
 * can use the field support built into JFace that allows
 * us to create a page that is small and knows how to 
 * save, restore and apply itself.
 * <p>
 * This page is used to modify preferences only. They
 * are stored in the preference store that belongs to
 * the main plug-in class. That way, preferences can
 * be accessed directly via the preference store.
 */

public class TraceViewMappingPreferencePage
	extends AssociationMappingPreferencePage
{		
	private IAssociationMappingRegistry registry;
	
	/**
	 * Constructor for TestSuiteAssocitation
	 */
	public TraceViewMappingPreferencePage()
	{
		super();	
		registry = (AssociationMappingRegistry)TraceAssociationManager.getTraceViewMappingRegistry();
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.preference.AssociationMappingPreferencePage#beforeIsPresented()
	 */
	protected void beforeIsPresented()
	{
		registry.checkpoint();
	}

	/**
	 * @see org.eclipse.jface.dialogs.IDialogPage#dispose()
	 */
	public void dispose()
	{
		registry.clearCheckpoint();
		registry = null;
		
		super.dispose();
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.preference.AssociationPreferencePage#getSelectionAssociationMapping()
	 */
	protected IAssociationMapping getSelectionAssociationMapping()
	{
		return registry.getAssociationMapping(HyadesUIPlugin.EP_TYPE_DESCRIPTIONS);
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.preference.AssociationRegistryPreferencePage#getDetailMappings()
	 */
	public IAssociationMapping[] getDetailMappings()
	{
		ArrayList arrayList = new ArrayList(Arrays.asList(registry.getAssociationMappings()));
		arrayList.remove(getSelectionAssociationMapping());
		return (IAssociationMapping[])arrayList.toArray(new IAssociationMapping[arrayList.size()]);
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.preference.AssociationPreferencePage#getSelectionLabel()
	 */
	public String getSelectionLabel()
	{
		return UIPlugin.getResourceString("traceSelectionLabel");
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.preference.AssociationPreferencePage#getLabel(IAssociationMapping)
	 */
	protected String getLabel(IAssociationMapping associationMapping)
	{
		if(HyadesUIPlugin.EP_TYPE_DESCRIPTIONS.equals(associationMapping.getExtensionPoint()))
			return UIPlugin.getResourceString("TRACE_TYPES");

		if(HyadesUIPlugin.EP_ANALYZER_EXTENSIONS.equals(associationMapping.getExtensionPoint()))
			return UIPlugin.getResourceString("TRACE_VIEWS");
			
		return null;
	}
	
	/**
	 * @see org.eclipse.jface.preference.IPreferencePage#performCancel()
	 */
	public boolean performCancel()
	{
		return registry.rollback();
	}

	/**
	 * @see org.eclipse.jface.preference.IPreferencePage#performOk()
	 */
	public boolean performOk()
	{
		if(!registry.commit())
			return false;
			
		UIPlugin.getDefault().savePluginPreferences();
		return true;
	}
	
	protected Control createContents(Composite parent)
	{
		Control control = super.createContents(parent);
		
		WorkbenchHelp.setHelp(parent, UIPlugin.getPluginId() + ".tprp0001");												
		
		return control;
	}	
	
}