/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;

/*
* CONTEXT_ID onwp0000 for open node wizard page
*/

public class OpenNodeWizardPage  extends NewNodeWizardPage implements ModifyListener
{
  public OpenNodeWizardPage(String name)
  {
	super(name);
	setTitle(UIPlugin.getResourceString("NODE_PROPERTIES_TITLE"));
	setDescription(UIPlugin.getResourceString("NODE_PROPERTIES_DESC"));
  }    
  public void createControl(Composite parent)
  {
	super.createControl(parent);

	_nodeUI.setEnabled(false);
		
	populateData();
	setPageComplete(true);

	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		parent,
	UIPlugin.getPluginId()+".onwp0000");
  }  
  public boolean finish()
  {
	TRCNode node = ((OpenNodeWizard)getWizard()).getNode();

	if(node == null )
	  return true;
  	
	if (node.getDeltaTime() != _nodeUI.getDeltaTime()) {
		node.setDeltaTime(_nodeUI.getDeltaTime());
		
		ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
		event.setSource(node);
		event.setType(ProfileEvent.UPDATE_DELTA_TIME);
		UIPlugin.getDefault().notifyProfileEventListener(event);
	}
	
	return(true);
  }  

public void modifyText(ModifyEvent event)
{
	setPageComplete(true);

	String port = _nodeUI.getPortNumberUI().getText().trim();
	
	if (event.widget == _nodeUI.getPortNumberUI())
	{
		try {
			int value = Integer.parseInt(port);
			if (value<0)
			{
				setErrorMessage(UIPlugin.getResourceString("RAC_INVALID_PORT"));
				setPageComplete(false);
				return;
			}
			setErrorMessage(null);  
			setPageComplete(true);
		} catch (NumberFormatException nfe) {
			setErrorMessage(UIPlugin.getResourceString("RAC_INVALID_PORT"));  
			setPageComplete(false);
		}
	}
	else if (event.widget == _nodeUI.getHourUI())
	{
		try {
			int hourValue = Integer.parseInt(_nodeUI.getHourUI().getText().trim());
			
			if (hourValue<0)
			{
				setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
				setPageComplete(false);
				return;
			}
			setErrorMessage(null);
			setPageComplete(true);
		}
		catch (NumberFormatException e)
		{
				if (_nodeUI.getHourUI().getText().trim().equals(""))
				{
					setErrorMessage(null);
					setPageComplete(true);
					return;
				}
				setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
				setPageComplete(false);			
		}
	}
	else if (event.widget == _nodeUI.getMinUI())
	{
		try {
			int minValue = Integer.parseInt(_nodeUI.getMinUI().getText().trim());
			
			if (minValue<0 || minValue >59)
			{
				setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
				setPageComplete(false);
				return;
			}
			setErrorMessage(null);
			setPageComplete(true);
		}
		catch (NumberFormatException e)
		{
				if (_nodeUI.getMinUI().getText().trim().equals(""))
				{
					setErrorMessage(null);
					setPageComplete(true);
					return;
				}
				setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
				setPageComplete(false);			
		}
	}
	else if (event.widget == _nodeUI.getSecUI())
	{
		try {
			int secValue = Integer.parseInt(_nodeUI.getSecUI().getText().trim());
			
			if (secValue<0 || secValue >59)
			{
				setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
				setPageComplete(false);
				return;
			}
			setErrorMessage(null);
			setPageComplete(true);
		}
		catch (NumberFormatException e)
		{
				if (_nodeUI.getSecUI().getText().trim().equals(""))
				{
					setErrorMessage(null);
					setPageComplete(true);
					return;
				}
				setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
				setPageComplete(false);			
		}
	}
	else if (event.widget == _nodeUI.getMicSecUI())
	{
		try {
			int micsecValue = Integer.parseInt(_nodeUI.getMicSecUI().getText().trim());
			
			if (micsecValue<0 || micsecValue >1000000)
			{
				setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
				setPageComplete(false);
				return;
			}
			setErrorMessage(null);
			setPageComplete(true);
		}
		catch (NumberFormatException e)
		{
				if (_nodeUI.getMicSecUI().getText().trim().equals(""))
				{
					setErrorMessage(null);
					setPageComplete(true);
					return;
				}
				setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
				setPageComplete(false);			
		}
	}
	
}

/**
 * Insert the method's description here.
 * Creation date: (10/05/2000 3:17:53 PM)
 */
protected void populateData()
{	
	TRCNode node = ((OpenNodeWizard)getWizard()).getNode();

	if(node == null)
	  return;

	_nodeUI.getNodeNameUI().setText(node.getName());
	_nodeUI.getPortNumberUI().setText(String.valueOf(node.getPort()));
	if (node.getIpAddress() != null) 
		_nodeUI.getAddressUI().setText(node.getIpAddress());

	_locationUI.setMonitor(node.getMonitor().getName());    
	
	double delta = node.getDeltaTime();
	if(delta != 0)
	  _nodeUI.setDeltaTime(delta);	
}


}
