/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.manual.runner;

import org.eclipse.hyades.test.common.event.ExecutionEvent;
import org.eclipse.hyades.test.manual.runner.model.TestInvocation;
import org.eclipse.hyades.test.manual.runner.model.TestSuite;
import org.eclipse.hyades.test.manual.runner.model.util.EventLogger;
import org.eclipse.hyades.test.manual.runner.model.util.ModelUtil;
import org.eclipse.hyades.test.manual.runner.model.util.ScriptParser;
import org.eclipse.hyades.test.manual.runner.ui.RemoteAppFrame;

/**
 * @author marcelop
 * @since 1.0.2
 */
public class RemoteApp
{
	public static void main(String[] args)
	throws Exception
	{
		if(args.length != 1)
			throw new IllegalArgumentException("args.lenght must be equals 1");
		
		ModelUtil.setEventLogger(new EventLogger()
		{
			public void log(ExecutionEvent executionEvent)
			{
				if(executionEvent != null)
					System.out.println(executionEvent.toString());
			}
		});
		new RemoteApp().initialize(args[0]);
		new RemoteAppFrame().show();
	}
	
	protected void initialize(String xml)
	throws Exception
	{
		RemoteAppResourceBundle.initialize();

		TestInvocation.addListener(ModelUtil.DEFAULT_EXECUTION_MANAGER);
	
		ScriptParser scriptParser = new ScriptParser();
		TestSuite testSuite = scriptParser.parse(xml.getBytes("UTF-8"));
		if(testSuite == null)
		{
			System.err.println("\n" + xml);
			throw new IllegalArgumentException(RemoteAppResourceBundle.getString("exception.parse.Fail"));
		}
		
		ModelUtil.DEFAULT_EXECUTION_MANAGER.setRoot(testSuite);
		ModelUtil.DEFAULT_EXECUTION_MANAGER.registerTestInvocations(scriptParser.getTestInvocations());
		ModelUtil.setVerdicts(scriptParser.getVerdics());
	
		scriptParser.dispose();
	}
}
