/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.manual.runner.ui.panel;

import java.awt.Component;
import java.util.EventObject;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import org.eclipse.hyades.test.common.util.BaseString;
import org.eclipse.hyades.test.manual.runner.RemoteAppResourceBundle;
import org.eclipse.hyades.test.manual.runner.model.TestSuite;
import org.eclipse.hyades.test.manual.runner.model.util.ModelUtil;
import org.eclipse.hyades.test.manual.runner.ui.RemoteAppFrame;
import org.eclipse.hyades.test.manual.runner.ui.util.SwingUtil;

/**
 * @author marcelop
 * @since 1.0.2
 */
public class TestSuitePanel 
extends NamedElementPanel
{
	private RemoteAppFrame remoteAppFrame;
	private JTextField locationText;
	private JPanel buttonPanel;
	private JButton finishButton;

	public TestSuitePanel(RemoteAppFrame remoteAppFrame)
	{
		this.remoteAppFrame = remoteAppFrame;
	}

	public TestSuitePanel()
	{
	}

	/**
	 * @see CommonAttributesPanel#addControls(JPanel, JPanel)
	 */
	protected void addControls(JPanel northPanel, JPanel centerPanel, JPanel southPanel)
	{
		locationText = new JTextField();
		locationText.setAlignmentX(Component.LEFT_ALIGNMENT);
		JLabel label = new JLabel(RemoteAppResourceBundle.getString("label.Location"));
		label.setLabelFor(locationText);
		label.setAlignmentX(Component.LEFT_ALIGNMENT);
		SwingUtil.adjustMnemonic(label);
		
		northPanel.add(label);
		northPanel.add(locationText);	

		buttonPanel = new JPanel();
		buttonPanel.setLayout(new BoxLayout(buttonPanel, BoxLayout.X_AXIS));
		buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));

		finishButton = new JButton();
		finishButton.setText(RemoteAppResourceBundle.getString("action.InterruptExecution"));
		SwingUtil.adjustMnemonic(finishButton);
		finishButton.setToolTipText(RemoteAppResourceBundle.getString("button.finish.Description"));
		finishButton.setAlignmentY(Component.RIGHT_ALIGNMENT);
		finishButton.addActionListener(this);
		buttonPanel.add(Box.createHorizontalGlue());
		buttonPanel.add(finishButton);
		southPanel.add(buttonPanel);
	}
	
	/**
	 * @see BasePanel#isValidData(Object)
	 */
	protected boolean isValidData(Object data)
	{
		return super.isValidData(data) && (data instanceof TestSuite);
	}
	
	/**
	 * @see BasePanel#invalidData()
	 */
	protected void invalidData()
	{
		super.invalidData();
		locationText.setText("");
	}

	/**
	 * @see BasePanel#refreshPanel(boolean)
	 */
	protected void refreshPanel(boolean sameObject)
	{
		super.refreshPanel(sameObject);
		locationText.setText(BaseString.toString(getTestSuite().getLocation()));

		if(getTestSuite() == ModelUtil.DEFAULT_EXECUTION_MANAGER.getRoot())
		{
			buttonPanel.setVisible(true);
			if(!ModelUtil.DEFAULT_EXECUTION_MANAGER.hasNext())
			{
				finishButton.setText(RemoteAppResourceBundle.getString("action.StopExecution"));
				finishButton.setMnemonic(0);
				SwingUtil.adjustMnemonic(finishButton);
			}
		}
		else
		{
			buttonPanel.setVisible(false);
		}
	}

	/**
	 * @see BasePanel#setEditable(boolean)
	 */
	protected void setEditable(boolean editable)
	{
		super.setEditable(editable);
		locationText.setEditable(editable);
	}
	
	public TestSuite getTestSuite()
	{
		return (TestSuite)getCurrentData();
	}
	
	/**
	 * @see com.ibm.etools.comptest.manual.remoteapp.ui.panel.BasePanel#updateCurrentData(EventObject)
	 */
	protected void updateCurrentData(EventObject event)
	{
		if(event.getSource() == finishButton)
		{
			remoteAppFrame.doClose(false);
		}
		else
		{
			super.updateCurrentData(event);
		}
	}	
}