/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.manual.runner.ui.tree;

import java.awt.GridLayout;

import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.TreeSelectionModel;

import org.eclipse.hyades.test.manual.runner.model.NamedElement;

/**
 * @author marcelop
 * @since 1.0.2
 */
public class TestSuiteTreePanel 
extends JPanel
{
	private TestSuiteTreeModel testSuiteModel;

	public TestSuiteTreePanel()
	{
		JTree tree = new JTree(testSuiteModel);
		testSuiteModel = new TestSuiteTreeModel();
		testSuiteModel.setTree(tree);
		
		tree.setEditable(false);
		tree.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
		tree.setCellRenderer(new TestSuiteTreeCellRenderer());
		tree.setShowsRootHandles(true);
		tree.putClientProperty("JTree.lineStyle", "Angled");

		ToolTipManager.sharedInstance().registerComponent(tree);

		JScrollPane scrollPane = new JScrollPane(tree);
		setLayout(new GridLayout(1, 0));
		add(scrollPane);		
	}

	public void dispose()
	{
		testSuiteModel.dispose();
	}
	
	public JTree getTree()
	{
		return testSuiteModel.getTree();
	}
	
	public void select(NamedElement namedElement)
	{
		testSuiteModel.select(namedElement);
	}
}