/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.common.internal.codegen;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.ui.internal.util.ResourceUtil;

public abstract class Generator {
    public void generate(ITestSuite iTestSuite, IProgressMonitor iProgressMonitor) throws Exception {
        IFile iFile = this.getFileHandle(iTestSuite);
        IContainer iContainer = this.getSourceContainerHandle(iTestSuite);
        if (iFile.exists()) {
            iFile.delete(true, true, iProgressMonitor);
        } else {
            ResourceUtil.createContainer((IContainer)iContainer, (IProgressMonitor)iProgressMonitor);
        }
        this.doGenerateFile(iTestSuite, iContainer, iFile, iProgressMonitor);
    }

    protected void doGenerateFile(ITestSuite iTestSuite, IContainer iContainer, IFile iFile, IProgressMonitor iProgressMonitor) throws Exception {
        this.generateFile(iTestSuite, iFile, iProgressMonitor);
    }

    public IFile getFileHandle(ITestSuite iTestSuite) {
        IContainer iContainer = this.getSourceContainerHandle(iTestSuite);
        return iContainer.getFile((IPath)new Path(iTestSuite.getImplementor().getResource()));
    }

    protected IContainer getSourceContainerHandle(ITestSuite iTestSuite) {
        Object object = null;
        Path path = new Path(iTestSuite.getImplementor().getLocation());
        object = path.segmentCount() == 1 ? ResourcesPlugin.getWorkspace().getRoot().getProject(path.toString()) : ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)path);
        return object;
    }

    protected abstract void generateFile(ITestSuite var1, IFile var2, IProgressMonitor var3) throws Exception;
}

