/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.manual.internal.wizard;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.common.internal.wizard.RunLocationPage;
import org.eclipse.hyades.test.java.internal.junit.wizard.RunJavaWizard;
import org.eclipse.hyades.test.manual.TestManualPlugin;
import org.eclipse.hyades.test.manual.internal.codegen.ManualGenerator;
import org.eclipse.hyades.test.manual.runner.RemoteApp;
import org.eclipse.hyades.ui.internal.util.StringUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class ManualRunWizard
extends RunJavaWizard {
    protected RunLocationPage createLocationPage() {
        return new RunLocationPage(false);
    }

    public boolean doPerformFinish() {
        ITestSuite iTestSuite = this.getTestSuite();
        Resource resource = ((TPFTestSuite)iTestSuite).eResource();
        boolean bl = resource.isModified();
        iTestSuite.getImplementor().setResource(this.createTestScript(iTestSuite));
        if (!bl) {
            resource.setModified(false);
        }
        return super.doPerformFinish();
    }

    protected ITestSuite getTestSuite() {
        ITestSuite iTestSuite = null;
        if (this.getTest() instanceof ITestSuite) {
            iTestSuite = (ITestSuite)this.getTest();
        } else if (this.getTest() instanceof ITestCase) {
            iTestSuite = ((ITestCase)this.getTest()).getOwner();
        }
        return iTestSuite;
    }

    protected String createTestScript(ITestSuite iTestSuite) {
        String string = ManualGenerator.generateScript(iTestSuite);
        if (string == null) {
            return null;
        }
        string = StringUtil.replace((String)string, (String)"\r", (String)"");
        return StringUtil.replace((String)string, (String)"\n", (String)"");
    }

    protected boolean _doPerformFinish() {
        String string = this.createTestScript(this.getTestSuite());
        try {
            if (string != null) {
                RemoteApp.main((String[])new String[]{string});
                return true;
            }
        }
        catch (Exception exception) {
            MessageDialog.openError((Shell)this.getShell(), (String)TestManualPlugin.getString("W_ERROR"), (String)exception.getMessage());
        }
        return false;
    }
}

