/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.control;

import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolCell;
import org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.edit.datapool.IDatapoolFactory;
import org.eclipse.hyades.edit.datapool.IDatapoolListener;
import org.eclipse.hyades.edit.datapool.IDatapoolSuggestedType;
import org.eclipse.hyades.edit.datapool.IDatapoolVariable;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolRecord;
import org.eclipse.hyades.test.ui.datapool.DatapoolPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.action.CopyAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.CutAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.PasteAction;
import org.eclipse.hyades.test.ui.datapool.internal.control.DatapoolClipboard;
import org.eclipse.hyades.test.ui.datapool.internal.control.DatapoolMenuManager;
import org.eclipse.hyades.test.ui.datapool.internal.control.DatapoolTableUtil;
import org.eclipse.hyades.test.ui.datapool.internal.dialog.DatapoolAddDialogSimple;
import org.eclipse.hyades.test.ui.datapool.internal.dialog.DatapoolColumnDialog;
import org.eclipse.hyades.test.ui.datapool.internal.dialog.DatapoolDeleteColumnDialog;
import org.eclipse.hyades.test.ui.datapool.internal.dialog.DatapoolRowDialog;
import org.eclipse.hyades.test.ui.datapool.internal.dialog.DatapoolRowGroupDialog;
import org.eclipse.hyades.test.ui.datapool.internal.interfaces.IDatapoolPart;
import org.eclipse.hyades.test.ui.datapool.internal.interfaces.IDatapoolPartExtended;
import org.eclipse.hyades.test.ui.datapool.internal.interfaces.IValidateValueClass;
import org.eclipse.hyades.test.ui.datapool.internal.interfaces.IValueClassFactory;
import org.eclipse.hyades.test.ui.datapool.internal.util.TypeChecker;
import org.eclipse.hyades.test.ui.datapool.internal.util.ValueClassMap;
import org.eclipse.hyades.test.ui.datapool.internal.util.ValueObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IWorkbenchPartSite;

public class DatapoolTable
implements IMenuListener,
SelectionListener,
IDatapoolListener {
    private static final String START_LITERAL = "<Literal>";
    private static final String END_LITERAL = "</Literal>";
    private static final String TAG_DATA = "data";
    private static final String TAG_RECORD = "record";
    private static final String TAG_VARIABLE = "variable";
    private static final String TAG_VARIABLE_INDEX = "variableIndex";
    private static final String TAG_EQUIVALENCE_CLASS = "equivalenceClass";
    private static final int MAX_TABLE_WIDTH = 60;
    private static final int MAX_TABLE_HEIGHT = 60;
    private IDatapool datapool = null;
    private Table table = null;
    private DatapoolTableUtil tableUtil = null;
    private TableViewer viewer = null;
    private Composite parent = null;
    private Menu contextMenu = null;
    private TableCursor cursor = null;
    private ControlEditor controlEditor = null;
    private IDatapoolPart datapoolPart = null;
    private IDatapoolFactory datapoolFactory = null;
    private CellEditor cellEditor = null;
    private ValueObject valueObject = null;
    private DatapoolMenuManager datapoolMenuManager = null;
    private boolean ignoreECNotification = false;
    private boolean controlKeyDown = false;
    private boolean altKeyDown = false;
    private boolean alreadySaved = false;
    private boolean isInputValid = true;
    private boolean showEquivlenceClasses = true;
    private boolean showVariables = true;
    private boolean showRecords = true;
    private boolean isF2Mode = false;
    private FocusListener focusListener;
    private ICellEditorListener cellEditorListener;
    private String vendorID = null;
    private CutAction cutAction;
    private CopyAction copyAction;
    private PasteAction pasteAction;
    protected SelectionListener headerListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            DatapoolTable.this.datapoolPart.notifyEdit();
            if (DatapoolTable.this.datapoolPart.isReadOnly()) {
                return;
            }
            DatapoolTable.this.clearCellEditor();
            TableColumn tableColumn = (TableColumn)event.widget;
            DatapoolTable.this.editColumnAux(tableColumn);
        }
    };
    private ControlListener resizeListener = new ControlAdapter(){

        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
        }
    };
    protected ControlListener resizeColumnListener = new ControlAdapter(){

        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
            if (DatapoolTable.this.cursor != null && !DatapoolTable.this.cursor.isDisposed() && DatapoolTable.this.table.getSelectionIndex() >= 0 && DatapoolTable.this.cursor.getColumn() >= 0) {
                DatapoolTable.this.cursor.setSelection(DatapoolTable.this.table.getSelectionIndex(), DatapoolTable.this.cursor.getColumn());
            }
        }
    };

    private void clearCellEditor() {
        if (this.cellEditor != null) {
            this.cellEditor.dispose();
            this.cellEditor = null;
        }
        if (this.valueObject != null) {
            this.valueObject = null;
        }
        if (this.cursor != null && !this.cursor.isDisposed()) {
            this.cursor.setFocus();
        }
    }

    private void clearCellEditor(CellEditor cellEditor) {
        if (cellEditor != null) {
            cellEditor.dispose();
            cellEditor = null;
        }
        if (this.valueObject != null) {
            this.valueObject = null;
        }
        if (this.cursor != null && !this.cursor.isDisposed()) {
            this.cursor.setFocus();
        }
    }

    public DatapoolTable(Composite parent, IDatapoolPart datapoolPart, IDatapool datapool, IDatapoolFactory datapoolFactory, String vendorID) {
        this.vendorID = vendorID;
        ValueClassMap.setVendorID(vendorID);
        this.DatapoolTableConstructor(parent, datapoolPart, datapool, datapoolFactory);
    }

    public DatapoolTable(Composite parent, IDatapoolPart datapoolPart, IDatapool datapool, IDatapoolFactory datapoolFactory) {
        this.DatapoolTableConstructor(parent, datapoolPart, datapool, datapoolFactory);
    }

    private void DatapoolTableConstructor(Composite parent, IDatapoolPart datapoolPart, IDatapool datapool, IDatapoolFactory datapoolFactory) {
        if (parent == null || datapoolPart == null || datapoolFactory == null) {
            return;
        }
        this.datapool = datapool;
        this.datapoolFactory = datapoolFactory;
        this.parent = new Composite(parent, 0);
        this.parent.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.parent.setLayout((Layout)layout);
        this.setWaitCursor();
        this.setVendorConfiguration();
        this.datapoolPart = datapoolPart;
        DatapoolClipboard.getInstance().setClipboard(datapoolPart.getClipboard());
        this.createTable(this.parent);
        this.tableUtil = new DatapoolTableUtil(this);
        this.createMenu();
        this.table.addSelectionListener((SelectionListener)this);
        if (datapool != null) {
            datapool.addDatapoolListener((IDatapoolListener)this);
        }
        this.datapoolMenuManager = new DatapoolMenuManager(this, this.vendorID, this.showEquivlenceClasses, this.showVariables, this.showRecords);
        this.setMenuMode(this.datapoolMenuManager);
        this.unsetWaitCursor();
    }

    private void createMenu() {
        MenuManager menuMgr = new MenuManager("#DatapoolEditor");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        this.contextMenu = menuMgr.createContextMenu((Control)this.table);
        this.table.setMenu(this.contextMenu);
    }

    private void createTable(Composite parent) {
        this.table = new Table(parent, 67584);
        this.viewer = new TableViewer(this.table);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 60;
        gd.heightHint = 60;
        this.table.setLayoutData((Object)gd);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(100, false));
        this.table.setLayout((Layout)layout);
        if (this.isWithoutColumns()) {
            this.makeHeaderColumn();
        } else {
            this.makeColumns();
        }
        if (!this.isWithoutRows()) {
            this.makeRows();
        }
        this.createCursor();
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 262144 && (e.stateMask & 0x20000) != 0) {
                    return;
                }
                if (e.keyCode == 131072 && (e.stateMask & 0x40000) != 0) {
                    return;
                }
                if (e.keyCode != 262144 && (e.stateMask & 0x40000) != 0) {
                    return;
                }
                if (e.keyCode != 131072 && (e.stateMask & 0x20000) != 0) {
                    return;
                }
                if (DatapoolTable.this.table.getItemCount() != 0) {
                    TableItem[] selection = DatapoolTable.this.table.getSelection();
                    TableItem row = selection.length == 0 ? DatapoolTable.this.table.getItem(DatapoolTable.this.table.getTopIndex()) : selection[0];
                    DatapoolTable.this.table.showItem(row);
                    if (DatapoolTable.this.cursor != null && !DatapoolTable.this.cursor.isDisposed()) {
                        DatapoolTable.this.cursor.setSelection(row, 0);
                        DatapoolTable.this.cursor.setVisible(true);
                        DatapoolTable.this.cursor.setFocus();
                    }
                }
            }
        });
        this.table.addMouseListener((MouseListener)new TableMouseAdapter());
        this.table.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -3) {
                    TableItem[] selection = DatapoolTable.this.table.getSelection();
                    if (selection != null && selection.length > 0 && DatapoolTable.this.cursor != null && !DatapoolTable.this.cursor.isDisposed()) {
                        try {
                            e.result = selection[0].getText(DatapoolTable.this.cursor.getColumn());
                        }
                        catch (Exception exception) {}
                    }
                } else {
                    e.result = DatapoolPlugin.getResourceString("W_DATATABLE");
                }
            }
        });
        if (this.datapool == null) {
            this.hideTable();
        }
    }

    private void createCursor() {
        if (this.datapool == null || this.datapool.getEquivalenceClassCount() == 0 || this.datapool.getEquivalenceClassCount() == 1 && this.datapool.getEquivalenceClass(0).getRecordCount() == 0) {
            return;
        }
        this.cursor = new TableCursor(this.table, 0);
        this.controlEditor = new ControlEditor((Composite)this.cursor);
        this.controlEditor.grabHorizontal = true;
        this.controlEditor.grabVertical = true;
        this.cursor.setMenu(this.contextMenu);
        this.cursor.addSelectionListener((SelectionListener)new CursorSelectionAdapter(this.cursor, this.cellEditor, this.datapoolPart));
        this.cursor.addKeyListener((KeyListener)new CursorKeyAdapter(this.cursor, this.cellEditor, this.datapoolPart));
        this.cursor.addMouseListener((MouseListener)new CursorMouseAdapter(this.cursor, this.cellEditor, this.datapoolPart));
        this.cursor.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                TableItem[] selection = DatapoolTable.this.table.getSelection();
                if (selection != null && selection.length > 0 && DatapoolTable.this.cursor != null && !DatapoolTable.this.cursor.isDisposed()) {
                    try {
                        e.result = selection[0].getText(DatapoolTable.this.cursor.getColumn());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        if (this.table.getItemCount() > 0) {
            this.table.select(0);
            this.cursor.setSelection(0, 0);
        }
    }

    private void resetCursor() {
        if (this.cursor == null || this.cursor.isDisposed()) {
            this.createCursor();
        } else if (this.table.getItemCount() > 0) {
            this.table.select(0);
            this.cursor.setSelection(0, 0);
            this.cursor.redraw();
        }
    }

    private void setWaitCursor() {
        if (this.parent == null) {
            return;
        }
        Display display = this.parent.getShell().getDisplay();
        Cursor waitCursor = new Cursor((Device)display, 1);
        this.setDisplayCursor(waitCursor);
    }

    private void unsetWaitCursor() {
        this.setDisplayCursor(null);
    }

    private void setDisplayCursor(Cursor c) {
        if (this.parent == null) {
            return;
        }
        Display display = this.parent.getShell().getDisplay();
        Shell[] shells = display.getShells();
        for (int i = 0; i < shells.length; ++i) {
            shells[i].setCursor(c);
        }
    }

    private void startCellEditing(TableItem row, int column) {
        IDatapoolCell[] cells = (IDatapoolCell[])row.getData(TAG_DATA);
        IDatapoolCell cell = cells[column - 1];
        IDatapoolVariable variable = (IDatapoolVariable)cell.getCellVariable();
        IDatapoolSuggestedType suggestedType = (IDatapoolSuggestedType)variable.getSuggestedType();
        Object rawValue = cell.getCellValue();
        if (suggestedType.getSuggestedType() == 3) {
            String[] stringArray = suggestedType.getEnumerationLiterals();
            if (stringArray != null && stringArray.length > 0) {
                this.cellEditor = new ComboBoxCellEditor((Composite)this.cursor, stringArray);
                if (rawValue instanceof String) {
                    ((CCombo)this.cellEditor.getControl()).setText((String)rawValue);
                }
            }
        } else if (suggestedType.getSuggestedType() == 2) {
            String[] boolList = new String[]{Boolean.toString(true), Boolean.toString(false)};
            this.cellEditor = new ComboBoxCellEditor((Composite)this.cursor, boolList, 8);
            ((CCombo)this.cellEditor.getControl()).setText((String)rawValue);
        }
        if (this.cellEditor == null) {
            if (rawValue == null) {
                String typeName = suggestedType.getSuggestedClassName();
                rawValue = typeName == null || typeName.length() == 0 ? new String() : this.createEmptyCellObject(typeName);
            }
            this.valueObject = new ValueObject(rawValue);
            this.cellEditor = (CellEditor)this.valueObject.getPropertyDisplay((Composite)this.cursor);
        }
        if (this.cellEditor != null) {
            if (this.cellEditor.getControl() != null) {
                this.cellEditor.getControl().addKeyListener((KeyListener)new TableCellKeyAdapter(this.cellEditor, this.valueObject, row, column));
                this.cellEditor.getControl().addPaintListener((PaintListener)new TableCellPaintAdapter());
            }
            this.cellEditor.addListener((ICellEditorListener)new TableCellEditorAdapter(this.cellEditor, this.valueObject, row, column));
            this.controlEditor.setEditor(this.cellEditor.getControl());
            this.cellEditor.setValidator((ICellEditorValidator)new TableCellValidator(ValueClassMap.getValueValidatorClass(rawValue)));
            this.cellEditor.setFocus();
            if (this.cellEditor instanceof TextCellEditor) {
                String currentText = row.getText(column);
                ((Text)this.cellEditor.getControl()).setSelection(currentText.length());
            }
            this.datapoolPart.markDirty();
        }
    }

    private Object createEmptyCellObject(String typeName) {
        Object value;
        IValueClassFactory valueFactory = ValueClassMap.getValueClassFactory(typeName);
        if (valueFactory != null) {
            value = valueFactory.createEmptyObject();
        } else {
            try {
                Class<?> objectClass = Class.forName(typeName);
                Constructor<?> objectConstructor = objectClass.getConstructor(new Class[0]);
                value = objectConstructor.newInstance(new Object[0]);
            }
            catch (Exception exception) {
                value = new String();
            }
        }
        return value;
    }

    private void applyEditingValue(boolean dispose) {
        if (this.cellEditor != null) {
            if (this.cursor != null && this.cursor.getColumn() > 0) {
                Object updatedValue = null;
                String newDescription = null;
                boolean update = true;
                TableItem selectedTableItem = this.cursor.getRow();
                int selectedColumnIndex = this.cursor.getColumn();
                if (selectedTableItem == null || selectedTableItem.isDisposed()) {
                    return;
                }
                IDatapoolCell[] rowData = (IDatapoolCell[])selectedTableItem.getData(TAG_DATA);
                IDatapoolCell cell = rowData[this.cursor.getColumn() - 1];
                IDatapoolSuggestedType suggestedType = (IDatapoolSuggestedType)cell.getCellVariable().getSuggestedType();
                if (suggestedType.getSuggestedType() == 3 || suggestedType.getSuggestedType() == 2) {
                    updatedValue = ((CCombo)this.cellEditor.getControl()).getText();
                    newDescription = updatedValue.toString();
                } else if (this.valueObject == null) {
                    update = false;
                } else {
                    String oldDescription = this.valueObject.getDescription();
                    updatedValue = this.valueObject.updateObject();
                    newDescription = this.valueObject.getDescription();
                    if (newDescription == null && oldDescription == null || newDescription != null && newDescription.equals(oldDescription)) {
                        update = false;
                    }
                }
                if (update) {
                    cell.setCellValue(updatedValue);
                    selectedTableItem.setText(selectedColumnIndex, newDescription);
                    this.cursor.setSelection(this.table.getSelectionIndex(), selectedColumnIndex);
                    this.datapoolPart.markDirty();
                }
            }
            if (dispose) {
                this.clearCellEditor();
            }
        }
    }

    private void makeColumns() {
        this.makeHeaderColumn();
        for (int i = 0; i < this.datapool.getVariableCount(); ++i) {
            TableColumn tableColumn = new TableColumn(this.table, 0, i + 1);
            IDatapoolVariable variable = (IDatapoolVariable)this.datapool.getVariable(i);
            tableColumn.setResizable(true);
            IDatapoolSuggestedType suggestedType = (IDatapoolSuggestedType)variable.getSuggestedType();
            String type = new String();
            if (suggestedType != null) {
                // empty if block
            }
            type = suggestedType.getSuggestedClassName();
            tableColumn.setText(variable.getName() + DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER") + type);
            tableColumn.setData(TAG_VARIABLE, (Object)variable);
            tableColumn.setData(TAG_VARIABLE_INDEX, (Object)new Integer(i));
            tableColumn.setWidth(100);
            tableColumn.addSelectionListener(this.headerListener);
            tableColumn.addControlListener(this.resizeColumnListener);
        }
    }

    private void makeHeaderColumn() {
        TableColumn recordTableColumn = new TableColumn(this.table, 0, 0);
        recordTableColumn.setResizable(true);
        if (!this.showEquivlenceClasses) {
            recordTableColumn.setWidth(20);
        } else {
            recordTableColumn.setWidth(100);
        }
        recordTableColumn.setData(TAG_VARIABLE, null);
        recordTableColumn.addControlListener(this.resizeColumnListener);
    }

    private void makeRows() {
        for (int i = 0; i < this.datapool.getEquivalenceClassCount(); ++i) {
            IDatapoolEquivalenceClass equivalenceClass = (IDatapoolEquivalenceClass)this.datapool.getEquivalenceClass(i);
            for (int j = 0; j < equivalenceClass.getRecordCount(); ++j) {
                org.eclipse.hyades.edit.datapool.IDatapoolRecord record = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)equivalenceClass.getRecord(j);
                int cellCount = record.getCellCount();
                String[] rowContents = new String[this.datapool.getVariableCount() + 1];
                IDatapoolCell[] rowData = new IDatapoolCell[this.datapool.getVariableCount()];
                rowContents[0] = this.showEquivlenceClasses ? equivalenceClass.getName() + DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER") + String.valueOf(j) : String.valueOf(j);
                for (int k = 0; k < cellCount; ++k) {
                    IDatapoolCell cell = (IDatapoolCell)record.getCell(k);
                    IDatapoolVariable cellVariable = (IDatapoolVariable)cell.getCellVariable();
                    int index = this.findColumnIndex(cellVariable.getName());
                    String cellValue = cell.getStringValue();
                    ValueObject valueObject = new ValueObject(cell.getCellValue());
                    if (valueObject != null) {
                        cellValue = valueObject.getDescription();
                    }
                    rowContents[index] = cellValue;
                    rowData[index - 1] = cell;
                }
                TableItem item = new TableItem(this.table, 0);
                item.setText(rowContents);
                item.setData(TAG_DATA, (Object)rowData);
                item.setData(TAG_RECORD, (Object)record);
                item.setData(TAG_EQUIVALENCE_CLASS, (Object)equivalenceClass);
            }
        }
    }

    private boolean isWithoutRows() {
        if (this.datapool == null) {
            return true;
        }
        if (this.datapool.getEquivalenceClassCount() > 0) {
            if (this.datapool.getEquivalenceClassCount() == 1) {
                IDatapoolEquivalenceClass equivalenceClass = (IDatapoolEquivalenceClass)this.datapool.getEquivalenceClass(0);
                return equivalenceClass.getRecordCount() == 0;
            }
            return false;
        }
        return true;
    }

    private boolean isWithoutColumns() {
        if (this.datapool == null) {
            return true;
        }
        return this.datapool.getVariableCount() == 0;
    }

    private int findColumnIndex(String name) {
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            TableColumn tableColumn = this.table.getColumn(i);
            IDatapoolVariable variable = (IDatapoolVariable)tableColumn.getData(TAG_VARIABLE);
            if (variable == null || !name.equals(variable.getName())) continue;
            return i;
        }
        return -1;
    }

    public void widgetSelected(SelectionEvent e) {
        int selectedColumnIndex;
        int selectedRowIndex = this.table.getSelectionIndex();
        if (this.cursor != null && !this.cursor.isDisposed() && (selectedColumnIndex = this.cursor.getColumn()) >= 0) {
            this.cursor.setSelection(selectedRowIndex, selectedColumnIndex);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void menuAboutToShow(IMenuManager imenuMgr) {
        this.datapoolMenuManager.addActions(imenuMgr);
        this.setMenuMode(this.datapoolMenuManager);
    }

    private void setMenuMode(DatapoolMenuManager dpMenuManager) {
        if (dpMenuManager == null) {
            return;
        }
        int menuMode = 0;
        if (this.datapool == null) {
            menuMode = 5;
        } else {
            if (this.cursor != null && !this.cursor.isDisposed()) {
                menuMode = this.cursor.getColumn() == 0 ? 0 : 1;
            }
            if (this.table.getSelectionIndex() == -1) {
                menuMode = 2;
            }
            if (this.datapool.getEquivalenceClassCount() == 0 && this.datapool.getVariableCount() > 0) {
                menuMode = 3;
            }
            if (this.datapool.getEquivalenceClassCount() == 0 && this.datapool.getVariableCount() == 0) {
                menuMode = 4;
            }
            if (this.datapoolPart.isReadOnly()) {
                menuMode = 5;
            }
        }
        boolean isCutCopyPasteable = false;
        if (this.table.getSelectionCount() > 0 && this.tableUtil.getColumnCount() > 1) {
            isCutCopyPasteable = true;
        }
        dpMenuManager.setDisplayMode(menuMode, isCutCopyPasteable);
    }

    public void insertRowGroup() {
        DatapoolRowGroupDialog dialog;
        if (!this.showEquivlenceClasses) {
            return;
        }
        TableItem previousTableItem = null;
        if (this.cursor != null && !this.cursor.isDisposed()) {
            previousTableItem = this.cursor.getRow();
        }
        IDatapoolEquivalenceClass previousEquivalenceClass = null;
        if (previousTableItem != null) {
            previousEquivalenceClass = (IDatapoolEquivalenceClass)previousTableItem.getData(TAG_EQUIVALENCE_CLASS);
        }
        if ((dialog = new DatapoolRowGroupDialog(Display.getCurrent().getActiveShell(), this.datapool, this.table, null, previousEquivalenceClass, DatapoolPlugin.getResourceString("DATA_ROW_GRP_DLG_TITLE_INS"))).open() == 0) {
            this.setWaitCursor();
            String name = dialog.getName();
            if (name != null && name.length() != 0) {
                IDatapoolEquivalenceClass equivalenceClass = null;
                if (this.datapool.getEquivalenceClassCount() == 1 && this.datapool.getEquivalenceClass(0).getRecordCount() == 0) {
                    equivalenceClass = (IDatapoolEquivalenceClass)this.datapool.getEquivalenceClass(0);
                } else {
                    equivalenceClass = this.datapool.constructEquivalenceClass();
                    int insertionIndex = dialog.getInsertionIndex();
                    this.datapool.insertEquivalenceClass(equivalenceClass, insertionIndex + 1);
                }
                equivalenceClass.setName(name);
                org.eclipse.hyades.edit.datapool.IDatapoolRecord record = equivalenceClass.constructRecord(this.createCells(this.datapool));
                equivalenceClass.insertRecord(record, 0);
            }
            this.unsetWaitCursor();
        }
    }

    public void deleteRowGroup() {
        if (!this.showEquivlenceClasses) {
            return;
        }
        TableItem tableItem = null;
        if (this.cursor == null || this.cursor.isDisposed()) {
            return;
        }
        tableItem = this.cursor.getRow();
        this.setWaitCursor();
        IDatapoolEquivalenceClass equivalenceClass = (IDatapoolEquivalenceClass)tableItem.getData(TAG_EQUIVALENCE_CLASS);
        int equivalenceClassIndex = this.datapool.getEquivalenceClassIndexById(equivalenceClass.getId());
        this.datapool.removeEquivalenceClass(equivalenceClassIndex);
        this.unsetWaitCursor();
    }

    public void editRowGroup() {
        TableItem tableItem = null;
        if (this.cursor == null || this.cursor.isDisposed()) {
            return;
        }
        tableItem = this.cursor.getRow();
        this.editRowGroupAux(tableItem);
    }

    private void editRowGroupAux(TableItem tableItem) {
        DatapoolRowGroupDialog dialog;
        if (!this.showEquivlenceClasses) {
            return;
        }
        IDatapoolEquivalenceClass selectedEquivalenceClass = null;
        if (tableItem != null) {
            selectedEquivalenceClass = (IDatapoolEquivalenceClass)tableItem.getData(TAG_EQUIVALENCE_CLASS);
        }
        int selectedEquivalenceClassIndex = -1;
        if (selectedEquivalenceClass != null) {
            selectedEquivalenceClassIndex = this.datapool.getEquivalenceClassIndexById(selectedEquivalenceClass.getId());
        }
        IDatapoolEquivalenceClass previousEquivalenceClass = null;
        if (selectedEquivalenceClassIndex != -1 && selectedEquivalenceClassIndex != 0) {
            previousEquivalenceClass = (IDatapoolEquivalenceClass)this.datapool.getEquivalenceClass(selectedEquivalenceClassIndex - 1);
        }
        if ((dialog = new DatapoolRowGroupDialog(Display.getCurrent().getActiveShell(), this.datapool, this.table, selectedEquivalenceClass, previousEquivalenceClass, DatapoolPlugin.getResourceString("DATA_ROW_GRP_DLG_TITLE_EDIT"))).open() == 0) {
            int insertionIndex;
            this.setWaitCursor();
            String name = dialog.getName();
            if (!selectedEquivalenceClass.getName().equals(name)) {
                selectedEquivalenceClass.setName(name);
            }
            if ((insertionIndex = dialog.getInsertionIndex()) == selectedEquivalenceClassIndex - 1) {
                this.unsetWaitCursor();
                return;
            }
            this.datapool.moveEquivalenceClass(selectedEquivalenceClassIndex, insertionIndex);
            this.unsetWaitCursor();
        }
    }

    public void insertRow() {
        DatapoolRowDialog dialog;
        TableItem previousTableItem = null;
        if (this.cursor != null && !this.cursor.isDisposed()) {
            previousTableItem = this.cursor.getRow();
        }
        if (!this.showRecords) {
            return;
        }
        if (!this.showEquivlenceClasses) {
            if (this.datapool.getEquivalenceClassCount() == 0) {
                this.setWaitCursor();
                IDatapoolEquivalenceClass equivalenceClass = this.datapool.constructEquivalenceClass();
                this.datapool.insertEquivalenceClass(equivalenceClass, 0);
                equivalenceClass.setName(this.vendorID);
                org.eclipse.hyades.edit.datapool.IDatapoolRecord record = equivalenceClass.constructRecord(this.createCells(this.datapool));
                equivalenceClass.insertRecord(record, 0);
                this.unsetWaitCursor();
                return;
            }
            if (this.datapool.getEquivalenceClassCount() == 1 && this.datapool.getEquivalenceClass(0).getRecordCount() == 0) {
                this.setWaitCursor();
                IDatapoolEquivalenceClass equivalenceClass = (IDatapoolEquivalenceClass)this.datapool.getEquivalenceClass(0);
                equivalenceClass.setName(this.vendorID);
                org.eclipse.hyades.edit.datapool.IDatapoolRecord record = equivalenceClass.constructRecord(this.createCells(this.datapool));
                equivalenceClass.insertRecord(record, 0);
                this.unsetWaitCursor();
                return;
            }
            if (previousTableItem != null) {
                int insertionIndex = this.table.indexOf(previousTableItem);
                IDatapoolEquivalenceClass equivalenceClass = (IDatapoolEquivalenceClass)previousTableItem.getData(TAG_EQUIVALENCE_CLASS);
                org.eclipse.hyades.edit.datapool.IDatapoolRecord record = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)previousTableItem.getData(TAG_RECORD);
                if (equivalenceClass == null || record == null) {
                    return;
                }
                if (equivalenceClass.getRecordCount() == 0) {
                    return;
                }
                org.eclipse.hyades.edit.datapool.IDatapoolRecord firstECRecord = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)equivalenceClass.getRecord(0);
                if (firstECRecord.equals(record)) {
                    DatapoolAddDialogSimple dialog2 = new DatapoolAddDialogSimple(Display.getCurrent().getActiveShell(), DatapoolPlugin.getResourceString("DATA_ADD_ROW_TITLE"));
                    if (dialog2.open() == 0) {
                        insertionIndex += dialog2.getIndexAdjustment();
                    } else {
                        return;
                    }
                }
                this.setWaitCursor();
                org.eclipse.hyades.edit.datapool.IDatapoolRecord newRecord = equivalenceClass.constructRecord(this.createCells(this.datapool));
                equivalenceClass.insertRecord(newRecord, insertionIndex + 1);
                this.unsetWaitCursor();
                return;
            }
        }
        if ((dialog = new DatapoolRowDialog(Display.getCurrent().getActiveShell(), this.datapool, this.table, null, previousTableItem, DatapoolPlugin.getResourceString("DATA_ROW_DLG_TITLE_INS"), this.showEquivlenceClasses)).open() == 0) {
            this.setWaitCursor();
            int insertionEquivalenceClassIndex = dialog.getInsertionEquivalenceClassIndex();
            int insertionRecordIndex = dialog.getInsertionRecordIndex();
            if (insertionEquivalenceClassIndex != -1 && insertionRecordIndex != -1) {
                IDatapoolEquivalenceClass equivalenceClass = (IDatapoolEquivalenceClass)this.datapool.getEquivalenceClass(insertionEquivalenceClassIndex);
                org.eclipse.hyades.edit.datapool.IDatapoolRecord record = equivalenceClass.constructRecord(this.createCells(this.datapool));
                equivalenceClass.insertRecord(record, insertionRecordIndex + 1);
            } else {
                IDatapoolEquivalenceClass equivalenceClass = (IDatapoolEquivalenceClass)this.datapool.getEquivalenceClass(insertionEquivalenceClassIndex);
                org.eclipse.hyades.edit.datapool.IDatapoolRecord record = equivalenceClass.constructRecord(this.createCells(this.datapool));
                equivalenceClass.insertRecord(record, 0);
            }
            this.unsetWaitCursor();
        }
    }

    public void deleteRow() {
        if (!this.showRecords) {
            return;
        }
        TableItem tableItem = null;
        if (this.cursor == null || this.cursor.isDisposed()) {
            return;
        }
        tableItem = this.cursor.getRow();
        this.setWaitCursor();
        IDatapoolEquivalenceClass equivalenceClass = (IDatapoolEquivalenceClass)tableItem.getData(TAG_EQUIVALENCE_CLASS);
        org.eclipse.hyades.edit.datapool.IDatapoolRecord record = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)tableItem.getData(TAG_RECORD);
        int equivalenceClassIndex = this.datapool.getEquivalenceClassIndexById(equivalenceClass.getId());
        int recordIndex = this.getRecordIndex(equivalenceClass, record);
        equivalenceClass.removeRecord(recordIndex);
        if (equivalenceClass.getRecordCount() == 0) {
            this.ignoreECNotification = true;
            this.datapool.removeEquivalenceClass(equivalenceClassIndex);
        }
        this.unsetWaitCursor();
    }

    public void editRow() {
        TableItem tableItem = null;
        if (this.cursor == null || this.cursor.isDisposed()) {
            return;
        }
        tableItem = this.cursor.getRow();
        this.editRowAux(tableItem);
    }

    private void editRowAux(TableItem tableItem) {
        DatapoolRowDialog dialog;
        if (!this.showRecords) {
            return;
        }
        int rowIndex = this.table.getSelectionIndex();
        TableItem previousTableItem = null;
        if (rowIndex != 0) {
            previousTableItem = this.table.getItem(rowIndex - 1);
        }
        if ((dialog = new DatapoolRowDialog(Display.getCurrent().getActiveShell(), this.datapool, this.table, tableItem, previousTableItem, DatapoolPlugin.getResourceString("DATA_ROW_DLG_TITLE_EDIT"), this.showEquivlenceClasses)).open() == 0) {
            this.setWaitCursor();
            IDatapoolEquivalenceClass equivalenceClass = (IDatapoolEquivalenceClass)tableItem.getData(TAG_EQUIVALENCE_CLASS);
            int equivalenceClassIndex = this.datapool.getEquivalenceClassIndexById(equivalenceClass.getId());
            org.eclipse.hyades.edit.datapool.IDatapoolRecord record = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)tableItem.getData(TAG_RECORD);
            int recordIndex = this.getRecordIndex(equivalenceClass, record);
            int insertionEquivalenceClassIndex = dialog.getInsertionEquivalenceClassIndex();
            int insertionRecordIndex = dialog.getInsertionRecordIndex();
            if (equivalenceClassIndex == insertionEquivalenceClassIndex) {
                if (recordIndex != insertionRecordIndex + 1) {
                    if (insertionRecordIndex > recordIndex) {
                        equivalenceClass.moveRecord(recordIndex, insertionRecordIndex);
                    } else {
                        equivalenceClass.moveRecord(recordIndex, insertionRecordIndex + 1);
                    }
                }
            } else if (insertionEquivalenceClassIndex != -1 && insertionRecordIndex != -1) {
                IDatapoolEquivalenceClass targetEquivalenceClass = (IDatapoolEquivalenceClass)this.datapool.getEquivalenceClass(insertionEquivalenceClassIndex);
                equivalenceClass.removeRecord(recordIndex);
                targetEquivalenceClass.insertRecord(record, insertionRecordIndex + 1);
                if (equivalenceClass.getRecordCount() == 0) {
                    this.ignoreECNotification = true;
                    this.datapool.removeEquivalenceClass(equivalenceClassIndex);
                }
            } else {
                IDatapoolEquivalenceClass targetEquivalenceClass = (IDatapoolEquivalenceClass)this.datapool.getEquivalenceClass(insertionEquivalenceClassIndex);
                equivalenceClass.removeRecord(recordIndex);
                targetEquivalenceClass.insertRecord(record, 0);
                if (equivalenceClass.getRecordCount() == 0) {
                    this.ignoreECNotification = true;
                    this.datapool.removeEquivalenceClass(equivalenceClassIndex);
                }
            }
            this.unsetWaitCursor();
        }
    }

    public void insertColumn() {
        DatapoolColumnDialog dialog;
        if (!this.showVariables) {
            return;
        }
        int selectedColumnIndex = -1;
        if (this.cursor != null && !this.cursor.isDisposed()) {
            selectedColumnIndex = this.cursor.getColumn();
        }
        TableColumn previousTableColumn = null;
        if (selectedColumnIndex > 0) {
            previousTableColumn = this.table.getColumn(selectedColumnIndex);
        }
        IDatapoolVariable previousVariable = null;
        if (previousTableColumn != null) {
            previousVariable = (IDatapoolVariable)previousTableColumn.getData(TAG_VARIABLE);
        }
        if ((dialog = new DatapoolColumnDialog(Display.getCurrent().getActiveShell(), this.datapool, null, previousVariable, DatapoolPlugin.getResourceString("DATA_COL_DLG_TITLE_INS"))).open() == 0) {
            this.setWaitCursor();
            IDatapoolVariable variable = this.datapool.constructVariable();
            variable.setName(dialog.getName());
            IDatapoolSuggestedType suggestedType = (IDatapoolSuggestedType)variable.getSuggestedType();
            this.setVariableType(suggestedType, dialog.getType());
            variable.setSuggestedType(suggestedType);
            int insertionIndex = this.findColumnIndex(dialog.getInsertionVariableName());
            if (insertionIndex == -1) {
                insertionIndex = 0;
            }
            this.datapool.insertVariable(variable, insertionIndex);
            this.unsetWaitCursor();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteColumn() {
        if (!this.showVariables) {
            return;
        }
        if (this.cursor == null || this.cursor.isDisposed()) {
            if (this.table.getItemCount() != 0 || this.tableUtil.getColumnCount() <= 0) return;
            DatapoolDeleteColumnDialog dialog = new DatapoolDeleteColumnDialog(Display.getCurrent().getActiveShell(), this.datapool);
            if (dialog.open() != 0) return;
            this.setWaitCursor();
            String variableID = dialog.getDeletedVariableID();
            int variableIndex = this.datapool.getVariableIndexById(variableID);
            this.datapool.removeVariable(variableIndex);
            this.unsetWaitCursor();
            return;
        } else {
            int selectedColumnIndex = this.cursor.getColumn();
            int selectedRowIndex = this.table.getSelectionIndex();
            if (selectedColumnIndex < 1) {
                return;
            }
            this.setWaitCursor();
            TableColumn tableColumn = this.table.getColumn(selectedColumnIndex);
            IDatapoolVariable variable = (IDatapoolVariable)tableColumn.getData(TAG_VARIABLE);
            int variableIndex = this.datapool.getVariableIndexById(variable.getId());
            this.datapool.removeVariable(variableIndex);
            this.unsetWaitCursor();
        }
    }

    public void editColumn() {
        int selectedColumnIndex = this.cursor.getColumn();
        TableColumn tableColumn = this.table.getColumn(selectedColumnIndex);
        this.editColumnAux(tableColumn);
    }

    private void editColumnAux(TableColumn tableColumn) {
        if (!this.showVariables) {
            return;
        }
        int columnIndex = this.table.indexOf(tableColumn);
        TableColumn previousTableColumn = null;
        if (columnIndex != 0) {
            previousTableColumn = this.table.getColumn(columnIndex - 1);
        }
        IDatapoolVariable previousVariable = null;
        if (previousTableColumn != null) {
            previousVariable = (IDatapoolVariable)previousTableColumn.getData(TAG_VARIABLE);
        }
        IDatapoolVariable variable = (IDatapoolVariable)tableColumn.getData(TAG_VARIABLE);
        DatapoolColumnDialog dialog = new DatapoolColumnDialog(Display.getCurrent().getActiveShell(), this.datapool, variable, previousVariable, DatapoolPlugin.getResourceString("DATA_COL_DLG_TITLE_EDIT"));
        if (dialog.open() == 0) {
            this.setWaitCursor();
            String name = dialog.getName();
            String type = dialog.getType();
            String insertionVariableID = dialog.getInsertionVariableID();
            String previousVariableID = new String();
            if (previousVariable != null) {
                previousVariableID = previousVariable.getId();
            }
            IDatapoolSuggestedType suggestedType = (IDatapoolSuggestedType)variable.getSuggestedType();
            if (name.equals(variable.getName()) && type.equals(suggestedType.getSuggestedClassName()) && insertionVariableID.equals(previousVariableID)) {
                this.unsetWaitCursor();
                return;
            }
            variable.setName(dialog.getName());
            this.setVariableType(suggestedType, dialog.getType());
            variable.setSuggestedType(suggestedType);
            Integer variableIndex = (Integer)tableColumn.getData(TAG_VARIABLE_INDEX);
            int insertionIndex = this.findColumnIndex(dialog.getInsertionVariableName());
            if (insertionIndex == columnIndex - 1) {
                this.unsetWaitCursor();
                return;
            }
            if (insertionIndex == -1) {
                this.datapool.moveVariable(columnIndex - 1, 0);
            } else if (insertionIndex > columnIndex) {
                this.datapool.moveVariable(columnIndex - 1, insertionIndex - 1);
            } else {
                this.datapool.moveVariable(columnIndex - 1, insertionIndex);
            }
            this.unsetWaitCursor();
        }
    }

    public void clearCell() {
        this.clearCellEditor();
        if (this.cursor != null && !this.cursor.isDisposed() && this.cursor.getColumn() > 0) {
            TableItem selectedTableItem = this.cursor.getRow();
            int selectedColumnIndex = this.cursor.getColumn();
            if (selectedTableItem != null && !selectedTableItem.isDisposed()) {
                IDatapoolCell[] rowData = (IDatapoolCell[])selectedTableItem.getData(TAG_DATA);
                IDatapoolCell cell = rowData[this.cursor.getColumn() - 1];
                Object value = cell.getCellValue();
                if (value == null) {
                    return;
                }
                if (value instanceof String) {
                    if (((String)value).length() == 0) {
                        return;
                    }
                    value = new String();
                } else {
                    value = this.createEmptyCellObject(value.getClass().getName());
                }
                cell.setCellValue(value);
                selectedTableItem.setText(selectedColumnIndex, new ValueObject(value).getDescription());
                this.cursor.setSelection(this.table.getSelectionIndex(), selectedColumnIndex);
                this.cursor.redraw();
                this.datapoolPart.markDirty();
            }
        }
    }

    private IDatapoolCell[] getSelectedCells() {
        IDatapoolCell[] cells = new IDatapoolCell[]{};
        if (this.cursor != null && this.cursor.getColumn() > 0) {
            TableItem selectedTableItem = this.cursor.getRow();
            int selectedColumnIndex = this.cursor.getColumn();
            if (selectedTableItem != null && !selectedTableItem.isDisposed()) {
                IDatapoolCell[] rowData = (IDatapoolCell[])selectedTableItem.getData(TAG_DATA);
                IDatapoolCell cell = rowData[this.cursor.getColumn() - 1];
                cells = new IDatapoolCell[]{cell};
            }
        }
        return cells;
    }

    public void variableAdded(IDatapool datapool, int newVariableIndex) {
        int selectedRowIndex;
        TableColumn tableColumn = new TableColumn(this.table, 0, newVariableIndex + 1);
        IDatapoolVariable variable = (IDatapoolVariable)datapool.getVariable(newVariableIndex);
        tableColumn.setResizable(true);
        IDatapoolSuggestedType suggestedType = (IDatapoolSuggestedType)variable.getSuggestedType();
        String type = new String();
        if (suggestedType != null) {
            // empty if block
        }
        type = suggestedType.getSuggestedClassName();
        tableColumn.setText(variable.getName() + DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER") + type);
        tableColumn.setData(TAG_VARIABLE, (Object)variable);
        tableColumn.setData(TAG_VARIABLE_INDEX, (Object)new Integer(newVariableIndex));
        tableColumn.setWidth(100);
        tableColumn.addSelectionListener(this.headerListener);
        tableColumn.addControlListener(this.resizeColumnListener);
        this.tableUtil.insertColumn(tableColumn, newVariableIndex);
        if (this.cursor != null && !this.cursor.isDisposed() && (selectedRowIndex = this.table.getSelectionIndex()) >= 0) {
            this.table.setSelection(selectedRowIndex);
            this.cursor.setSelection(selectedRowIndex, newVariableIndex + 1);
            this.cursor.setFocus();
        }
        this.datapoolPart.markDirty();
    }

    public void variableRemoved(IDatapool datapool, int variableIndex) {
        this.tableUtil.deleteColumn(variableIndex + 1);
        if (this.cursor != null && !this.cursor.isDisposed()) {
            if (variableIndex > 0) {
                int selectedRowIndex = this.table.getSelectionIndex();
                if (selectedRowIndex >= 0) {
                    this.table.select(selectedRowIndex);
                    this.cursor.setSelection(selectedRowIndex, variableIndex);
                }
            } else {
                this.table.deselectAll();
            }
        }
        this.datapoolPart.markDirty();
    }

    public void variableMoved(IDatapool datapool, int sourceVariableIndex, int targetVariableIndex) {
        int selectedIndex;
        this.tableUtil.moveColumn(sourceVariableIndex + 1, targetVariableIndex + 1);
        if (this.cursor != null && !this.cursor.isDisposed() && targetVariableIndex > 0 && (selectedIndex = this.table.getSelectionIndex()) >= 0) {
            this.table.select(selectedIndex);
            this.cursor.setSelection(selectedIndex, targetVariableIndex);
        }
        this.datapoolPart.markDirty();
    }

    public void variableChanged(IDatapool datapool, int variableIndex) {
        IDatapoolVariable variable = (IDatapoolVariable)datapool.getVariable(variableIndex);
        int columnIndex = this.findColumnIndex(variable.getName());
        TableColumn tableColumn = this.table.getColumn(columnIndex);
        IDatapoolSuggestedType suggestedType = (IDatapoolSuggestedType)variable.getSuggestedType();
        String type = new String();
        if (suggestedType != null) {
            // empty if block
        }
        type = suggestedType.getSuggestedClassName();
        tableColumn.setText(variable.getName() + DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER") + type);
        tableColumn.setData(TAG_VARIABLE, (Object)variable);
        tableColumn.setData(TAG_VARIABLE_INDEX, (Object)new Integer(variableIndex));
        this.datapoolPart.markDirty();
    }

    public void variableChanged(IDatapool datapool, int variableIndex, String oldName) {
        this.variableChanged(datapool, variableIndex);
    }

    public void equivalenceClassChanged(IDatapool datapool, int equivalenceClassIndex) {
        IDatapoolEquivalenceClass equivalenceClass = (IDatapoolEquivalenceClass)datapool.getEquivalenceClass(equivalenceClassIndex);
        for (int i = 0; i < equivalenceClass.getRecordCount(); ++i) {
            int tableRowIndex = this.findRowIndex(equivalenceClassIndex, i);
            TableItem tableItem = this.table.getItem(tableRowIndex);
            tableItem.setText(0, equivalenceClass.getName() + DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER") + String.valueOf(i));
            if (this.cursor != null && !this.cursor.isDisposed()) {
                this.cursor.redraw();
            }
            this.datapoolPart.markDirty();
        }
    }

    public void equivalenceClassChanged(IDatapool datapool, int equivalenceClassIndex, String oldName) {
        this.equivalenceClassChanged(datapool, equivalenceClassIndex);
    }

    public void equivalenceClassAdded(IDatapool datapool, int newEquivalenceClassIndex) {
        IDatapoolEquivalenceClass equivalenceClass = (IDatapoolEquivalenceClass)datapool.getEquivalenceClass(newEquivalenceClassIndex);
        IDatapoolEquivalenceClass previousEquivalenceClass = null;
        int insertionIndex = 0;
        if (newEquivalenceClassIndex > 0) {
            previousEquivalenceClass = (IDatapoolEquivalenceClass)datapool.getEquivalenceClass(newEquivalenceClassIndex - 1);
            insertionIndex = this.findRowIndex(newEquivalenceClassIndex - 1, previousEquivalenceClass.getRecordCount() - 1) + 1;
        }
        for (int j = 0; j < equivalenceClass.getRecordCount(); ++j) {
            org.eclipse.hyades.edit.datapool.IDatapoolRecord record = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)equivalenceClass.getRecord(j);
            String[] rowContents = new String[this.table.getColumnCount()];
            IDatapoolCell[] rowData = new IDatapoolCell[this.table.getColumnCount() - 1];
            rowContents[0] = equivalenceClass.getName() + DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER") + String.valueOf(j);
            for (int k = 0; k < record.getCellCount(); ++k) {
                IDatapoolCell cell = (IDatapoolCell)record.getCell(k);
                org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable cellVariable = cell.getCellVariable();
                int index = this.findColumnIndex(cellVariable.getName());
                String cellValue = cell.getStringValue();
                ValueObject valueObject = new ValueObject(cell.getCellValue());
                if (valueObject != null) {
                    cellValue = valueObject.getDescription();
                }
                rowContents[index] = cellValue;
                rowData[index - 1] = cell;
            }
            TableItem item = new TableItem(this.table, 0, insertionIndex + j);
            item.setText(rowContents);
            item.setData(TAG_DATA, (Object)rowData);
            item.setData(TAG_RECORD, (Object)record);
            item.setData(TAG_EQUIVALENCE_CLASS, (Object)equivalenceClass);
        }
        this.datapoolPart.markDirty();
    }

    public void equivalenceClassRemoved(IDatapool datapool, int equivalenceClassIndex) {
        if (this.ignoreECNotification) {
            this.ignoreECNotification = false;
            return;
        }
        int tableRowIndex = this.findRowIndex(equivalenceClassIndex, 0);
        TableItem tableItem = this.table.getItem(tableRowIndex);
        IDatapoolEquivalenceClass equivalenceClass = (IDatapoolEquivalenceClass)tableItem.getData(TAG_EQUIVALENCE_CLASS);
        boolean removeRow = true;
        while (removeRow) {
            this.table.remove(tableRowIndex);
            if (tableRowIndex < this.table.getItemCount()) {
                tableItem = this.table.getItem(tableRowIndex);
                IDatapoolEquivalenceClass nextEquivalenceClass = (IDatapoolEquivalenceClass)tableItem.getData(TAG_EQUIVALENCE_CLASS);
                if (nextEquivalenceClass.equals(equivalenceClass)) continue;
                removeRow = false;
                continue;
            }
            removeRow = false;
        }
        this.datapoolPart.markDirty();
        if (this.cursor != null && !this.cursor.isDisposed() && this.table != null) {
            int tableSize = this.table.getItemCount();
            if (tableSize == 0) {
                this.table.deselectAll();
                return;
            }
            if (tableSize > tableRowIndex) {
                this.table.setSelection(tableRowIndex);
                this.cursor.setSelection(tableRowIndex, 0);
                return;
            }
            if (tableSize > tableRowIndex - 1) {
                this.table.setSelection(tableRowIndex - 1);
                this.cursor.setSelection(tableRowIndex - 1, 0);
            }
        }
    }

    public void equivalenceClassMoved(IDatapool datapool, int sourceEquivalenceClassIndex, int targetEquivalenceClassIndex) {
        if (sourceEquivalenceClassIndex == targetEquivalenceClassIndex) {
            return;
        }
        int targetIndex = 0;
        if (targetEquivalenceClassIndex != -1) {
            IDatapoolEquivalenceClass targetEquivalenceClass = (IDatapoolEquivalenceClass)datapool.getEquivalenceClass(targetEquivalenceClassIndex);
            int targetRecordCount = targetEquivalenceClass.getRecordCount();
            if (sourceEquivalenceClassIndex < targetEquivalenceClassIndex) {
                --targetRecordCount;
            }
            targetIndex = this.findRowIndex(targetEquivalenceClassIndex, targetRecordCount);
        }
        IDatapoolEquivalenceClass sourceEquivalenceClass = (IDatapoolEquivalenceClass)datapool.getEquivalenceClass(sourceEquivalenceClassIndex);
        int sourceRecordCount = sourceEquivalenceClass.getRecordCount();
        int sourceIndex = this.findRowIndex(sourceEquivalenceClassIndex, 0);
        for (int i = 0; i < sourceEquivalenceClass.getRecordCount(); ++i) {
            if (sourceEquivalenceClassIndex > targetEquivalenceClassIndex) {
                this.tableUtil.moveRow(sourceIndex + sourceRecordCount - 1, targetIndex);
                continue;
            }
            this.tableUtil.moveRow(sourceIndex, targetIndex);
        }
        if (this.cursor != null && !this.cursor.isDisposed() && this.table != null) {
            this.table.setSelection(targetIndex);
            this.cursor.setSelection(targetIndex, 0);
        }
        this.datapoolPart.markDirty();
    }

    public void recordAdded(IDatapool datapool, int equivalenceClassIndex, int newRecordIndex) {
        IDatapoolEquivalenceClass equivalenceClass = (IDatapoolEquivalenceClass)datapool.getEquivalenceClass(equivalenceClassIndex);
        org.eclipse.hyades.edit.datapool.IDatapoolRecord record = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)equivalenceClass.getRecord(newRecordIndex);
        String[] rowContents = new String[this.table.getColumnCount()];
        IDatapoolCell[] rowData = new IDatapoolCell[this.table.getColumnCount() - 1];
        rowContents[0] = this.showEquivlenceClasses ? equivalenceClass.getName() + DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER") + String.valueOf(newRecordIndex) : String.valueOf(newRecordIndex);
        for (int i = 0; i < record.getCellCount(); ++i) {
            IDatapoolCell cell = (IDatapoolCell)record.getCell(i);
            org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable cellVariable = cell.getCellVariable();
            int index = this.findColumnIndex(cellVariable.getName());
            String cellValue = cell.getStringValue();
            ValueObject valueObject = new ValueObject(cell.getCellValue());
            if (valueObject != null) {
                cellValue = valueObject.getDescription();
            }
            rowContents[index] = cellValue;
            rowData[index - 1] = cell;
        }
        int insertionIndex = this.findRowIndex(equivalenceClassIndex, newRecordIndex);
        TableItem tableItem = new TableItem(this.table, 0, insertionIndex);
        tableItem.setText(rowContents);
        tableItem.setData(TAG_DATA, (Object)rowData);
        tableItem.setData(TAG_RECORD, (Object)record);
        tableItem.setData(TAG_EQUIVALENCE_CLASS, (Object)equivalenceClass);
        this.repopulateRowLabels(equivalenceClassIndex);
        if (this.table.getItemCount() == 1) {
            this.createCursor();
        }
        if (this.cursor != null && !this.cursor.isDisposed() && this.table != null) {
            this.table.setSelection(insertionIndex);
            this.cursor.setSelection(insertionIndex, 0);
            this.cursor.setFocus();
        }
        this.datapoolPart.markDirty();
    }

    public void recordRemoved(IDatapool datapool, int equivalenceClassIndex, int recordIndex) {
        int tableRowIndex = this.findRowIndex(equivalenceClassIndex, recordIndex);
        this.table.remove(tableRowIndex);
        this.repopulateRowLabels(equivalenceClassIndex);
        this.datapoolPart.markDirty();
        if (this.cursor != null && !this.cursor.isDisposed() && this.table != null) {
            int tableSize = this.table.getItemCount();
            if (tableSize == 0) {
                this.table.deselectAll();
                return;
            }
            if (tableSize > tableRowIndex) {
                this.table.setSelection(tableRowIndex);
                this.cursor.setSelection(tableRowIndex, 0);
                return;
            }
            if (tableSize > tableRowIndex - 1) {
                this.table.setSelection(tableRowIndex - 1);
                this.cursor.setSelection(tableRowIndex - 1, 0);
            }
        }
    }

    public void recordMoved(IDatapool datapool, int equivalenceClassIndex, int sourceRecordIndex, int targetRecordIndex) {
        int sourceRowIndex = this.findRowIndex(equivalenceClassIndex, sourceRecordIndex);
        int targetRowIndex = this.findRowIndex(equivalenceClassIndex, targetRecordIndex);
        this.tableUtil.moveRow(sourceRowIndex, targetRowIndex);
        this.repopulateRowLabels(equivalenceClassIndex);
        this.datapoolPart.markDirty();
    }

    public void cellChanged(IDatapool datapool, int equivalenceClassIndex, int recordIndex, int variableIndex) {
        IDatapoolEquivalenceClass equivalenceClass = (IDatapoolEquivalenceClass)datapool.getEquivalenceClass(equivalenceClassIndex);
        org.eclipse.hyades.edit.datapool.IDatapoolRecord record = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)equivalenceClass.getRecord(recordIndex);
        IDatapoolVariable variable = (IDatapoolVariable)datapool.getVariable(variableIndex);
        IDatapoolCell cell = null;
        for (int i = 0; i < record.getCellCount() && !(cell = (IDatapoolCell)record.getCell(i)).getCellVariable().equals(variable); ++i) {
            cell = null;
        }
        if (cell != null) {
            String cellValue = cell.getStringValue();
            ValueObject valueObject = new ValueObject(cell.getCellValue());
            if (valueObject != null) {
                cellValue = valueObject.getDescription();
            }
            String value = cellValue;
            int tableRowIndex = this.findRowIndex(equivalenceClassIndex, recordIndex);
            TableItem tableItem = this.table.getItem(tableRowIndex);
            tableItem.setText(variableIndex + 1, value);
            this.cursor.setSelection(tableRowIndex, equivalenceClassIndex + 1);
            this.datapoolPart.markDirty();
        }
        this.datapoolPart.markDirty();
    }

    public void equivalenceClassReordered(IDatapool datapool, int equivalenceClassIndex) {
        IDatapoolEquivalenceClass equivalenceClass = (IDatapoolEquivalenceClass)datapool.getEquivalenceClass(equivalenceClassIndex);
        for (int i = 0; i < equivalenceClass.getRecordCount(); ++i) {
            org.eclipse.hyades.edit.datapool.IDatapoolRecord record = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)equivalenceClass.getRecord(i);
            int newTableRowIndex = this.findRowIndex(equivalenceClassIndex, i);
            int oldTableRowIndex = this.findRowIndex(equivalenceClassIndex, record);
            this.tableUtil.swapRow(oldTableRowIndex, newTableRowIndex);
        }
        this.datapoolPart.markDirty();
    }

    public void recordChanged(IDatapool datapool, int EquivClassIndex, int recordIndex) {
    }

    public void save(IDatapool datapool) {
        this.alreadySaved = true;
    }

    private int findRowIndex(int equivalenceClassIndex, org.eclipse.hyades.edit.datapool.IDatapoolRecord record) {
        IDatapoolEquivalenceClass equivalenceClass = (IDatapoolEquivalenceClass)this.datapool.getEquivalenceClass(equivalenceClassIndex);
        int startingRowIndex = this.findRowIndex(equivalenceClassIndex, 0);
        for (int i = 0; i < equivalenceClass.getRecordCount(); ++i) {
            org.eclipse.hyades.edit.datapool.IDatapoolRecord currentRecord = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)this.table.getItem(startingRowIndex + i).getData(TAG_RECORD);
            if (!currentRecord.equals(record)) continue;
            return startingRowIndex + i;
        }
        return -1;
    }

    private int findRowIndex(int equivalenceClassIndex, int recordIndex) {
        int count = recordIndex;
        for (int i = 0; i < equivalenceClassIndex; ++i) {
            IDatapoolEquivalenceClass equivalenceClass = (IDatapoolEquivalenceClass)this.datapool.getEquivalenceClass(i);
            count += equivalenceClass.getRecordCount();
        }
        return count;
    }

    private void repopulateRowLabels(int equivalenceClassIndex) {
        IDatapoolEquivalenceClass equivalenceClass = (IDatapoolEquivalenceClass)this.datapool.getEquivalenceClass(equivalenceClassIndex);
        String name = equivalenceClass.getName();
        int tableRowIndex = this.findRowIndex(equivalenceClassIndex, 0);
        for (int i = 0; i < equivalenceClass.getRecordCount(); ++i) {
            if (this.table.getItemCount() <= tableRowIndex + 1) continue;
            TableItem tableItem = this.table.getItem(tableRowIndex + i);
            if (this.showEquivlenceClasses) {
                tableItem.setText(0, name + DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER") + String.valueOf(i));
                continue;
            }
            tableItem.setText(0, String.valueOf(i));
        }
    }

    private int getRecordIndex(IDatapoolEquivalenceClass equivalenceClass, org.eclipse.hyades.edit.datapool.IDatapoolRecord record) {
        for (int i = 0; i < equivalenceClass.getRecordCount(); ++i) {
            IDatapoolRecord compRecord = equivalenceClass.getRecord(i);
            if (!compRecord.equals(record)) continue;
            return i;
        }
        return -1;
    }

    protected Object[] createCells(IDatapool datapool) {
        Object[] cells = new Object[datapool.getVariableCount()];
        for (int i = 0; i < datapool.getVariableCount(); ++i) {
            cells[i] = new String();
        }
        return cells;
    }

    private void setVendorConfiguration() {
        if (this.vendorID == null) {
            return;
        }
        IExtensionPoint extensionPoint = Platform.getPluginRegistry().getExtensionPoint("org.eclipse.hyades.test.ui.datapool.vendorConfigurationExtension");
        if (extensionPoint != null) {
            try {
                IConfigurationElement[] extensionPoints = extensionPoint.getConfigurationElements();
                for (int i = 0; i < extensionPoints.length; ++i) {
                    String extVendorID = extensionPoints[i].getAttribute("vendorID");
                    if (!this.vendorID.equals(extVendorID)) continue;
                    String strShowEC = extensionPoints[i].getAttribute("showEquivalenceClassCommands");
                    Boolean boolShowEC = Boolean.valueOf(strShowEC);
                    this.showEquivlenceClasses = boolShowEC;
                    String strShowVar = extensionPoints[i].getAttribute("showVariableCommands");
                    Boolean boolShowVar = Boolean.valueOf(strShowVar);
                    this.showVariables = boolShowVar;
                    String strShowRec = extensionPoints[i].getAttribute("showRecordCommands");
                    Boolean boolShowRec = Boolean.valueOf(strShowRec);
                    this.showRecords = boolShowVar;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    private void setVariableType(IDatapoolSuggestedType suggestedType, String type) {
        if (suggestedType == null) {
            return;
        }
        if (TypeChecker.getInstance().isBoolean(type)) {
            suggestedType.setSuggestedType(2);
        } else if (TypeChecker.getInstance().isNumber(type)) {
            suggestedType.setSuggestedType(1);
        } else if (TypeChecker.getInstance().isString(type)) {
            suggestedType.setSuggestedType(0);
        } else if (TypeChecker.getInstance().isEnumeration(type)) {
            suggestedType.setSuggestedType(3);
        } else {
            suggestedType.setSuggestedType(4);
        }
        suggestedType.setSuggestedClassName(type);
    }

    public void save() {
        this.datapoolFactory.save(this.datapool);
        this.alreadySaved = true;
    }

    public void dispose() {
        this.clearCellEditor();
        if (!this.cursor.isDisposed()) {
            this.cursor.dispose();
        }
        if (!this.contextMenu.isDisposed()) {
            this.contextMenu.dispose();
        }
        if (!this.table.isDisposed()) {
            this.table.dispose();
        }
        if (this.viewer != null) {
            this.viewer = null;
        }
        this.datapool = null;
        this.tableUtil = null;
        this.datapoolPart = null;
        this.datapoolFactory = null;
        this.vendorID = null;
        this.controlEditor = null;
        this.focusListener = null;
        this.cellEditorListener = null;
    }

    public IDatapool getDatapool() {
        return this.datapool;
    }

    private void connectCutCopyPasteActions(IDatapoolPart part) {
        IWorkbenchPartSite site;
        if (part instanceof IDatapoolPartExtended && (site = ((IDatapoolPartExtended)part).getPartSite()) != null) {
            if (this.cutAction == null) {
                this.cutAction = new CutAction((ISelectionProvider)this.getViewer(), this);
            }
            if (this.copyAction == null) {
                this.copyAction = new CopyAction((ISelectionProvider)this.getViewer(), this);
            }
            if (this.pasteAction == null) {
                this.pasteAction = new PasteAction((ISelectionProvider)this.getViewer(), this);
            }
            IKeyBindingService keyBindingService = site.getKeyBindingService();
            keyBindingService.registerAction((IAction)this.cutAction);
            keyBindingService.registerAction((IAction)this.copyAction);
            keyBindingService.registerAction((IAction)this.pasteAction);
        }
    }

    public void cut() {
        DatapoolClipboard.getInstance().clear();
        int columnIndex = -1;
        if (this.cursor != null && !this.cursor.isDisposed()) {
            columnIndex = this.cursor.getColumn();
        }
        if (columnIndex == -1) {
            return;
        }
        if (columnIndex == 0) {
            this.cutRecords();
        } else {
            this.cutCell();
        }
    }

    public void copy() {
        DatapoolClipboard.getInstance().clear();
        int columnIndex = -1;
        if (this.cursor != null && !this.cursor.isDisposed()) {
            columnIndex = this.cursor.getColumn();
        }
        if (columnIndex == -1) {
            return;
        }
        if (columnIndex == 0) {
            this.copyRecords();
        } else {
            this.copyCell();
        }
    }

    public void paste() {
        int columnIndex = -1;
        if (this.cursor != null && !this.cursor.isDisposed()) {
            columnIndex = this.cursor.getColumn();
        }
        if (columnIndex == -1) {
            return;
        }
        if (columnIndex == 0) {
            this.pasteRecords();
        } else {
            this.pasteCell();
        }
    }

    private void cutRecords() {
        TableItem[] tableItems = this.table.getSelection();
        if (tableItems == null || this.table.getSelectionCount() == 0) {
            return;
        }
        for (int i = 0; i < tableItems.length; ++i) {
            this.cutRecord(tableItems[i]);
        }
        DatapoolClipboard.getInstance().update();
    }

    private void cutRecord(TableItem item) {
        this.copyRecord(item);
        this.clearRecord(item);
    }

    private void clearRecord(TableItem item) {
        org.eclipse.hyades.edit.datapool.IDatapoolRecord record = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)item.getData(TAG_RECORD);
        if (record == null || record.getCellCount() == 0) {
            return;
        }
        int cellCount = record.getCellCount();
        for (int i = 0; i < cellCount; ++i) {
            IDatapoolCell cell = (IDatapoolCell)record.getCell(i);
            cell.setCellValue(null);
            item.setText(i + 1, new String());
        }
        this.datapoolPart.markDirty();
    }

    private void cutCell() {
        this.copyCell();
        this.clearCell();
    }

    private void copyRecords() {
        TableItem[] tableItems = this.table.getSelection();
        if (tableItems == null || this.table.getSelectionCount() == 0) {
            return;
        }
        for (int i = 0; i < tableItems.length; ++i) {
            this.copyRecord(tableItems[i]);
        }
        DatapoolClipboard.getInstance().update();
    }

    private void copyRecord(TableItem item) {
        org.eclipse.hyades.edit.datapool.IDatapoolRecord record = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)item.getData(TAG_RECORD);
        if (record == null || record.getCellCount() == 0) {
            return;
        }
        DatapoolClipboard.getInstance().addRecordData(record);
    }

    private void copyCell() {
        int rowIndex = -1;
        TableItem row = null;
        int columnIndex = -1;
        if (this.cursor == null || this.cursor.isDisposed()) {
            return;
        }
        columnIndex = this.cursor.getColumn();
        row = this.cursor.getRow();
        if (row != null) {
            rowIndex = this.table.indexOf(row);
        }
        if (columnIndex == -1 || rowIndex == -1 || row == null) {
            return;
        }
        org.eclipse.hyades.edit.datapool.IDatapoolRecord record = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)row.getData(TAG_RECORD);
        IDatapoolCell cell = (IDatapoolCell)record.getCell(columnIndex - 1);
        DatapoolClipboard.getInstance().addCellData(cell);
        DatapoolClipboard.getInstance().update();
    }

    private void pasteRecords() {
        Object[] messageElements = new Object[]{DatapoolPlugin.getResourceString("DATA_PASTE_OVERWRITE")};
        String message = MessageFormat.format("{0}", messageElements);
        MessageDialog overwriteDialog = new MessageDialog(this.parent.getShell(), DatapoolPlugin.getResourceString("PASTE_TEXT"), null, message, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        if (overwriteDialog.open() != 0) {
            return;
        }
        TableItem[] tableItems = this.table.getSelection();
        if (tableItems == null || this.table.getSelectionCount() == 0) {
            return;
        }
        TableItem firstItem = tableItems[0];
        int firstItemIndex = this.table.indexOf(firstItem);
        Object[] recordDataSet = DatapoolClipboard.getInstance().getRecordDataSet();
        if (recordDataSet == null || recordDataSet.length == 0) {
            return;
        }
        for (int i = 0; i < recordDataSet.length; ++i) {
            Object[] recordData;
            if (firstItemIndex + i >= this.table.getItemCount() || (recordData = (Object[])recordDataSet[i]) == null) continue;
            TableItem tableItem = this.table.getItem(firstItemIndex + i);
            org.eclipse.hyades.edit.datapool.IDatapoolRecord record = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)tableItem.getData(TAG_RECORD);
            for (int j = 0; j < recordData.length; ++j) {
                if (j >= record.getCellCount()) continue;
                IDatapoolCell cell = (IDatapoolCell)record.getCell(j);
                cell.setCellValue(recordData[j]);
                String cellValue = cell.getStringValue();
                ValueObject valueObject = new ValueObject(cell.getCellValue());
                if (valueObject != null) {
                    cellValue = valueObject.getDescription();
                }
                tableItem.setText(j + 1, cellValue);
                this.datapoolPart.markDirty();
            }
        }
    }

    private void pasteCell() {
        int rowIndex = -1;
        TableItem row = null;
        int columnIndex = -1;
        if (this.cursor == null || this.cursor.isDisposed()) {
            return;
        }
        columnIndex = this.cursor.getColumn();
        row = this.cursor.getRow();
        if (row != null) {
            rowIndex = this.table.indexOf(row);
        }
        if (columnIndex == -1 || rowIndex == -1 || row == null) {
            return;
        }
        org.eclipse.hyades.edit.datapool.IDatapoolRecord record = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)row.getData(TAG_RECORD);
        IDatapoolCell cell = (IDatapoolCell)record.getCell(columnIndex - 1);
        Object cellValue = DatapoolClipboard.getInstance().getCellData();
        cell.setCellValue(cellValue);
        String cellStringValue = cell.getStringValue();
        ValueObject valueObject = new ValueObject(cell.getCellValue());
        if (valueObject != null) {
            cellStringValue = valueObject.getDescription();
        }
        row.setText(columnIndex, cellStringValue);
        this.cursor.setSelection(this.table.getSelectionIndex(), columnIndex);
        this.cursor.redraw();
        this.datapoolPart.markDirty();
    }

    public IDatapoolPart getIDatapoolPart() {
        return this.datapoolPart;
    }

    public void refresh() {
        this.refresh(this.datapool);
    }

    public void refresh(IDatapool datapool) {
        if (this.datapool != null && this.datapool != datapool) {
            this.datapool.removeDatapoolListener((IDatapoolListener)this);
        }
        if (datapool != null && datapool != this.datapool) {
            datapool.addDatapoolListener((IDatapoolListener)this);
        }
        this.datapool = datapool;
        if (datapool == null) {
            this.hideTable();
            return;
        }
        this.restoreTable();
        this.refreshColumns();
        this.refreshRows();
        this.resetCursor();
    }

    private void hideTable() {
        this.table.setVisible(false);
        this.table.setEnabled(false);
        this.table.setHeaderVisible(false);
    }

    private void restoreTable() {
        this.table.setEnabled(true);
        this.table.setVisible(true);
        this.table.setHeaderVisible(true);
    }

    private void refreshColumns() {
        int newColumnCount = this.datapool.getVariableCount();
        int oldColumnCount = this.tableUtil.getColumnCount() - 1;
        if (this.cursor != null && !this.cursor.isDisposed()) {
            int selectedColumnIndex = this.cursor.getColumn();
            TableItem selectedItem = this.cursor.getRow();
            if (selectedColumnIndex > newColumnCount) {
                this.cursor.setSelection(selectedItem, newColumnCount);
            } else {
                this.cursor.setSelection(selectedItem, selectedColumnIndex);
            }
        }
        if (oldColumnCount > newColumnCount) {
            int numberToDelete = oldColumnCount - newColumnCount;
            for (int i = 0; i < numberToDelete; ++i) {
                this.tableUtil.deleteColumn(newColumnCount + 1);
            }
        }
        for (int i = 0; i < this.datapool.getVariableCount(); ++i) {
            int index = i + 1;
            TableColumn tableColumn = null;
            if (index < this.tableUtil.getColumnCount()) {
                tableColumn = this.table.getColumn(index);
            } else {
                tableColumn = new TableColumn(this.table, 0, index);
                tableColumn.setWidth(100);
                tableColumn.addSelectionListener(this.headerListener);
                tableColumn.addControlListener(this.resizeColumnListener);
            }
            IDatapoolVariable variable = (IDatapoolVariable)this.datapool.getVariable(i);
            tableColumn.setResizable(true);
            IDatapoolSuggestedType suggestedType = (IDatapoolSuggestedType)variable.getSuggestedType();
            String type = new String();
            if (suggestedType != null) {
                // empty if block
            }
            type = suggestedType.getSuggestedClassName();
            tableColumn.setText(variable.getName() + DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER") + type);
            tableColumn.setData(TAG_VARIABLE, (Object)variable);
            tableColumn.setData(TAG_VARIABLE_INDEX, (Object)new Integer(i));
        }
    }

    private void refreshRows() {
        int oldRowCount = this.table.getItemCount();
        int rowIndex = 0;
        for (int i = 0; i < this.datapool.getEquivalenceClassCount(); ++i) {
            IDatapoolEquivalenceClass equivalenceClass = (IDatapoolEquivalenceClass)this.datapool.getEquivalenceClass(i);
            for (int j = 0; j < equivalenceClass.getRecordCount(); ++j) {
                org.eclipse.hyades.edit.datapool.IDatapoolRecord record = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)equivalenceClass.getRecord(j);
                int cellCount = record.getCellCount();
                String[] rowContents = new String[this.datapool.getVariableCount() + 1];
                IDatapoolCell[] rowData = new IDatapoolCell[this.datapool.getVariableCount()];
                rowContents[0] = this.showEquivlenceClasses ? equivalenceClass.getName() + DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER") + String.valueOf(j) : String.valueOf(j);
                for (int k = 0; k < cellCount; ++k) {
                    IDatapoolCell cell = (IDatapoolCell)record.getCell(k);
                    IDatapoolVariable cellVariable = (IDatapoolVariable)cell.getCellVariable();
                    int index = this.findColumnIndex(cellVariable.getName());
                    String cellValue = cell.getStringValue();
                    ValueObject valueObject = new ValueObject(cell.getCellValue());
                    if (valueObject != null) {
                        cellValue = valueObject.getDescription();
                    }
                    rowContents[index] = cellValue;
                    rowData[index - 1] = cell;
                }
                TableItem item = null;
                item = rowIndex < this.table.getItemCount() ? this.table.getItem(rowIndex) : new TableItem(this.table, 0);
                item.setText(rowContents);
                item.setData(TAG_DATA, (Object)rowData);
                item.setData(TAG_RECORD, (Object)record);
                item.setData(TAG_EQUIVALENCE_CLASS, (Object)equivalenceClass);
                ++rowIndex;
            }
        }
        try {
            if (this.cursor == null || this.cursor.isDisposed()) {
                this.createCursor();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        int newRowCount = rowIndex;
        if (this.cursor != null && !this.cursor.isDisposed()) {
            int selectedColumnIndex = this.cursor.getColumn();
            TableItem selectedItem = this.cursor.getRow();
            int selectedRowIndex = this.table.indexOf(selectedItem);
            if (selectedRowIndex > newRowCount - 1) {
                if (newRowCount - 1 < 0) {
                    this.table.deselectAll();
                    if (this.cursor != null && !this.cursor.isDisposed()) {
                        this.cursor.dispose();
                    }
                } else {
                    this.table.setSelection(newRowCount - 1);
                    this.cursor.setSelection(newRowCount - 1, selectedColumnIndex);
                }
            } else {
                this.cursor.setSelection(selectedRowIndex, selectedColumnIndex);
            }
        }
        if (oldRowCount > newRowCount) {
            int numberToDelete = oldRowCount - newRowCount;
            for (int i = 0; i < numberToDelete; ++i) {
                this.table.remove(newRowCount);
            }
        }
    }

    class TableMouseAdapter
    implements MouseListener {
        TableMouseAdapter() {
        }

        public void mouseDoubleClick(MouseEvent event) {
        }

        public void mouseDown(MouseEvent event) {
        }

        public void mouseUp(MouseEvent event) {
            if (event.button == 3 && DatapoolTable.this.contextMenu.isDisposed()) {
                DatapoolTable.this.createMenu();
                DatapoolTable.this.contextMenu.setEnabled(true);
                DatapoolTable.this.contextMenu.setVisible(true);
            }
        }
    }

    class CursorSelectionAdapter
    implements SelectionListener {
        private CellEditor editor = null;
        private TableCursor cursor = null;
        private IDatapoolPart datapoolPart = null;

        public CursorSelectionAdapter(TableCursor cursor, CellEditor cellEditor, IDatapoolPart datapoolPart) {
            this.editor = cellEditor;
            this.cursor = cursor;
            this.datapoolPart = datapoolPart;
        }

        public void widgetSelected(SelectionEvent event) {
            if (this.datapoolPart.isReadOnly()) {
                return;
            }
            DatapoolTable.this.clearCellEditor();
            if (!DatapoolTable.this.isInputValid) {
                return;
            }
            DatapoolTable.this.table.setSelection(new TableItem[]{this.cursor.getRow()});
            if (DatapoolTable.this.datapoolMenuManager != null) {
                DatapoolTable.this.setMenuMode(DatapoolTable.this.datapoolMenuManager);
            }
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            DatapoolTable.this.clearCellEditor();
            TableItem row = this.cursor.getRow();
            int columnIndex = this.cursor.getColumn();
            int rowIndex = DatapoolTable.this.table.indexOf(row);
            int maxRowIndex = DatapoolTable.this.table.getItemCount();
            if (rowIndex + 1 >= maxRowIndex) {
                return;
            }
            this.cursor.setSelection(rowIndex + 1, columnIndex);
            DatapoolTable.this.table.setSelection(rowIndex + 1);
        }
    }

    class CursorMouseAdapter
    implements MouseListener {
        private CellEditor editor = null;
        private TableCursor cursor = null;
        private IDatapoolPart datapoolPart = null;

        public CursorMouseAdapter(TableCursor cursor, CellEditor cellEditor, IDatapoolPart datapoolPart) {
            this.editor = cellEditor;
            this.cursor = cursor;
            this.datapoolPart = datapoolPart;
        }

        public void mouseDoubleClick(MouseEvent event) {
            if (DatapoolTable.this.datapool == null) {
                return;
            }
            this.datapoolPart.notifyEdit();
            if (this.datapoolPart.isReadOnly()) {
                return;
            }
            TableItem row = this.cursor.getRow();
            int column = this.cursor.getColumn();
            if (column == 0) {
                DatapoolTable.this.editRowAux(row);
                return;
            }
            DatapoolTable.this.startCellEditing(row, column);
            if (DatapoolTable.this.cellEditor != null) {
                DatapoolTable.this.isF2Mode = true;
            }
        }

        public void mouseDown(MouseEvent event) {
            if (event.button != 1) {
                return;
            }
            DatapoolTable.this.clearCellEditor();
        }

        public void mouseUp(MouseEvent event) {
            if (event.button == 3) {
                DatapoolTable.this.contextMenu.setEnabled(true);
                DatapoolTable.this.contextMenu.setVisible(true);
            }
        }
    }

    class CursorKeyAdapter
    implements KeyListener {
        private CellEditor editor = null;
        private TableCursor cursor = null;
        private IDatapoolPart datapoolPart = null;

        public CursorKeyAdapter(TableCursor cursor, CellEditor cellEditor, IDatapoolPart datapoolPart) {
            this.editor = cellEditor;
            this.cursor = cursor;
            this.datapoolPart = datapoolPart;
        }

        public void keyPressed(KeyEvent e) {
            if (DatapoolTable.this.datapool == null) {
                return;
            }
            if (e.keyCode == 0x1000013 && (e.stateMask & 0x20000) != 0) {
                if (DatapoolTable.this.contextMenu == null || DatapoolTable.this.contextMenu.isDisposed()) {
                    DatapoolTable.this.createMenu();
                }
                DatapoolTable.this.contextMenu.setEnabled(true);
                DatapoolTable.this.contextMenu.setVisible(true);
                return;
            }
            if (e.keyCode == 65536) {
                DatapoolTable.this.altKeyDown = true;
            }
            if (e.keyCode == 262144) {
                DatapoolTable.this.controlKeyDown = true;
                DatapoolTable.this.connectCutCopyPasteActions(DatapoolTable.this.datapoolPart);
            }
            int selectedColumnIndex = this.cursor.getColumn();
            TableItem row = this.cursor.getRow();
            if (e.keyCode == 27 || e.keyCode == 13 || e.keyCode == 65536 || e.keyCode == 0x1000006 || e.keyCode == 0x1000005 || e.keyCode == 0x1000007 || e.keyCode == 0x1000008 || e.keyCode == 262144 || e.keyCode == 131072 || e.keyCode == 0x100000A || e.keyCode >= 0x100000C && e.keyCode <= 0x1000015) {
                return;
            }
            if (!DatapoolTable.this.isF2Mode && e.keyCode == 0x1000002 || e.keyCode == 0x1000001 || e.keyCode == 0x1000003 || e.keyCode == 0x1000004) {
                int visibleColumnCount;
                int maxRowIndex;
                if (!DatapoolTable.this.isInputValid) {
                    return;
                }
                DatapoolTable.this.clearCellEditor();
                int selectedRowIndex = DatapoolTable.this.table.indexOf(row);
                if (e.keyCode == 0x1000002 && selectedRowIndex < (maxRowIndex = DatapoolTable.this.table.getItemCount())) {
                    DatapoolTable.this.table.setSelection(selectedRowIndex);
                }
                if (e.keyCode == 0x1000001 && selectedRowIndex >= 0) {
                    DatapoolTable.this.table.setSelection(selectedRowIndex);
                }
                if (e.keyCode == 0x1000004 && selectedColumnIndex > (visibleColumnCount = DatapoolTable.this.tableUtil.getColumnCount()) - 1) {
                    this.cursor.setSelection(selectedRowIndex, selectedColumnIndex - 1);
                }
                return;
            }
            this.datapoolPart.notifyEdit();
            if (this.datapoolPart.isReadOnly()) {
                return;
            }
            if (e.keyCode == 0x1000009 && (e.stateMask & 0x40000) != 0) {
                if (selectedColumnIndex == 0) {
                    DatapoolTable.this.insertRowGroup();
                }
                if (selectedColumnIndex > 0) {
                    DatapoolTable.this.insertColumn();
                }
                return;
            }
            if (e.keyCode == 127 && (e.stateMask & 0x40000) != 0) {
                if (selectedColumnIndex == 0) {
                    DatapoolTable.this.deleteRowGroup();
                }
                if (selectedColumnIndex > 0) {
                    DatapoolTable.this.deleteColumn();
                }
                return;
            }
            if ((e.stateMask & 0x40000) != 0 || (e.stateMask & 0x10000) != 0) {
                return;
            }
            if (e.keyCode == 0x1000009) {
                if (selectedColumnIndex == 0) {
                    DatapoolTable.this.insertRow();
                }
                if (selectedColumnIndex <= 0) {
                    return;
                }
            }
            if (e.keyCode == 127) {
                if (selectedColumnIndex == 0) {
                    DatapoolTable.this.deleteRow();
                }
                if (selectedColumnIndex > 0) {
                    DatapoolTable.this.clearCell();
                }
                return;
            }
            char inputCharacter = e.character;
            if (selectedColumnIndex == 0) {
                DatapoolTable.this.editRowAux(row);
                return;
            }
            DatapoolTable.this.startCellEditing(row, selectedColumnIndex);
            if (DatapoolTable.this.cellEditor instanceof TextCellEditor) {
                if (e.keyCode == 8) {
                    DatapoolTable.this.cellEditor.setValue((Object)new String());
                } else if (e.keyCode == 0x100000B) {
                    String currentText = row.getText(selectedColumnIndex);
                    DatapoolTable.this.cellEditor.setValue((Object)currentText);
                    ((Text)DatapoolTable.this.cellEditor.getControl()).setSelection(currentText.length());
                    DatapoolTable.this.isF2Mode = true;
                } else {
                    String characterValue = String.valueOf(inputCharacter);
                    if (DatapoolTable.this.cellEditor.getValidator() != null && DatapoolTable.this.cellEditor.getValidator().isValid((Object)characterValue) != null) {
                        DatapoolTable.this.isInputValid = false;
                    }
                    DatapoolTable.this.cellEditor.setValue((Object)characterValue);
                    ((Text)DatapoolTable.this.cellEditor.getControl()).setSelection(2);
                }
            }
        }

        public void keyReleased(KeyEvent e) {
            if (e.keyCode == 262144) {
                DatapoolTable.this.controlKeyDown = false;
                return;
            }
            if (DatapoolTable.this.altKeyDown) {
                DatapoolTable.this.altKeyDown = false;
                return;
            }
            if (e.keyCode == 0x1000009 && (e.stateMask & 0x40000) != 0) {
                int selectedColumnIndex = this.cursor.getColumn();
                if (selectedColumnIndex == 0) {
                    DatapoolTable.this.insertRowGroup();
                }
                if (selectedColumnIndex > 0) {
                    DatapoolTable.this.insertColumn();
                }
                return;
            }
        }
    }

    class TableCellValidator
    implements ICellEditorValidator {
        IValidateValueClass validator = null;

        public TableCellValidator(IValidateValueClass validator) {
            this.validator = validator;
        }

        public String isValid(Object value) {
            if (this.validator == null) {
                return null;
            }
            if (this.validator.checkValue(value)) {
                return null;
            }
            Error error = this.validator.getError();
            if (error != null) {
                return error.toString();
            }
            return "Error";
        }
    }

    class TableCellKeyAdapter
    implements KeyListener {
        private CellEditor editor = null;
        private ValueObject valueObject = null;
        private TableItem row = null;
        private int rowIndex = -1;
        private int column = -1;

        public TableCellKeyAdapter(CellEditor cellEditor, ValueObject valueObject, TableItem row, int column) {
            this.editor = cellEditor;
            this.valueObject = valueObject;
            this.row = row;
            this.column = column;
            if (row != null) {
                this.rowIndex = DatapoolTable.this.table.indexOf(row);
            }
        }

        public void keyPressed(KeyEvent e) {
            if (DatapoolTable.this.datapool == null) {
                return;
            }
            if (e.character == '\r') {
                if (!DatapoolTable.this.isInputValid) {
                    e.doit = false;
                    return;
                }
                return;
            }
            if (e.keyCode == 0x1000013 && (e.stateMask & 0x20000) != 0) {
                if (DatapoolTable.this.contextMenu == null || DatapoolTable.this.contextMenu.isDisposed()) {
                    DatapoolTable.this.createMenu();
                }
                DatapoolTable.this.contextMenu.setEnabled(true);
                DatapoolTable.this.contextMenu.setVisible(true);
                return;
            }
            if (!(DatapoolTable.this.isF2Mode || e.keyCode != 0x1000002 && e.keyCode != 0x1000001 && e.keyCode != 0x1000003 && e.keyCode != 0x1000004)) {
                if (!DatapoolTable.this.isInputValid) {
                    e.doit = false;
                    return;
                }
                DatapoolTable.this.applyEditingValue(true);
                if (DatapoolTable.this.cursor != null && !DatapoolTable.this.cursor.isDisposed()) {
                    if (e.keyCode == 0x1000002 && this.rowIndex + 1 < DatapoolTable.this.table.getItemCount()) {
                        DatapoolTable.this.table.setSelection(this.rowIndex + 1);
                        DatapoolTable.this.cursor.setSelection(this.rowIndex + 1, this.column);
                    }
                    if (e.keyCode == 0x1000001 && this.rowIndex > 0) {
                        DatapoolTable.this.table.setSelection(this.rowIndex - 1);
                        DatapoolTable.this.cursor.setSelection(this.rowIndex - 1, this.column);
                    }
                    if (e.keyCode == 0x1000004 && this.column + 1 < DatapoolTable.this.tableUtil.getColumnCount()) {
                        DatapoolTable.this.cursor.setSelection(this.rowIndex, this.column + 1);
                    }
                    if (e.keyCode == 0x1000003 && this.column > 0) {
                        DatapoolTable.this.cursor.setSelection(this.rowIndex, this.column - 1);
                    }
                    DatapoolTable.this.cursor.setFocus();
                }
                return;
            }
        }

        public void keyReleased(KeyEvent e) {
            if (e.character == '\u001b') {
                DatapoolTable.this.clearCellEditor(this.editor);
                return;
            }
            if (!(e.keyCode != 0x1000002 && e.keyCode != 0x1000001 && e.keyCode != 0x1000003 && e.keyCode != 0x1000004 || DatapoolTable.this.isInputValid)) {
                e.doit = false;
                return;
            }
        }
    }

    class TableCellPaintAdapter
    implements PaintListener {
        TableCellPaintAdapter() {
        }

        public void paintControl(PaintEvent event) {
            if (!DatapoolTable.this.isInputValid) {
                this.drawPolyline(event.gc, (Widget)event.getSource());
            } else {
                event.gc.drawPolyline(new int[0]);
            }
        }

        private void drawPolyline(GC gc, Widget widget) {
            char c;
            if (gc == null) {
                return;
            }
            Rectangle rect = gc.getClipping();
            String str = "";
            if (widget instanceof Text) {
                str = ((Text)widget).getText();
            } else if (widget instanceof CCombo) {
                str = ((CCombo)widget).getText();
            } else if (widget instanceof Combo) {
                str = ((Combo)widget).getText();
            } else {
                return;
            }
            int offset = 2;
            for (int i = 0; i < str.length() && Character.isWhitespace(c = str.charAt(i)); ++i) {
                offset += gc.getAdvanceWidth(c);
            }
            int length = gc.textExtent((String)str.trim()).x;
            Point left = new Point(offset, 0);
            Point right = new Point(length + offset + 2, 0);
            gc.setForeground(Display.getCurrent().getSystemColor(3));
            int[] polyline = this.computePolyline(left, right, rect.height);
            gc.drawPolyline(polyline);
        }

        private int[] computePolyline(Point left, Point right, int height) {
            int WIDTH = 4;
            int HEIGHT = 2;
            int leftX = left.x;
            int peeks = (right.x - left.x) / 4;
            int length = (2 * peeks + 1) * 2;
            if (length < 0) {
                return new int[0];
            }
            int[] coordinates = new int[length];
            int bottom = left.y + height - 1;
            int top = bottom - 2;
            for (int i = 0; i < peeks; ++i) {
                int index = 4 * i;
                coordinates[index] = leftX + 4 * i;
                coordinates[index + 1] = bottom;
                coordinates[index + 2] = coordinates[index] + 2;
                coordinates[index + 3] = top;
            }
            coordinates[length - 2] = left.x + 4 * peeks;
            coordinates[length - 1] = bottom;
            return coordinates;
        }
    }

    class TableCellEditorAdapter
    implements ICellEditorListener {
        private CellEditor editor = null;
        private ValueObject valueObject = null;
        private TableItem row = null;
        private int rowIndex = -1;
        private int column = -1;

        public TableCellEditorAdapter(CellEditor cellEditor, ValueObject valueObject, TableItem row, int column) {
            this.editor = cellEditor;
            this.valueObject = valueObject;
            this.row = row;
            this.column = column;
            if (row != null) {
                this.rowIndex = DatapoolTable.this.table.indexOf(row);
            }
        }

        public void applyEditorValue() {
            DatapoolTable.this.isF2Mode = false;
            if (!DatapoolTable.this.isInputValid) {
                return;
            }
            DatapoolTable.this.applyEditingValue(true);
        }

        public void cancelEditor() {
            DatapoolTable.this.isF2Mode = false;
        }

        public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            if (!newValidState) {
                DatapoolTable.this.isInputValid = false;
            } else {
                DatapoolTable.this.isInputValid = true;
            }
            this.editor.getControl().redraw();
        }
    }
}

