/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.util;

import java.util.Enumeration;

public class CSVTokenizer
implements Enumeration {
    private static final char DOUBLEQUOTE = '\"';
    private static final char COMMA = ',';
    private static final String TWOQUOTES = "\"\"";
    private static final String QUOTE = "\"";
    String input = null;
    String nextToken = null;

    public CSVTokenizer(String input) {
        this.input = input;
        this.setNextToken();
    }

    public String nextToken() {
        String returnToken = this.processToken(this.nextToken);
        this.setNextToken();
        return returnToken;
    }

    private void setNextToken() {
        if (this.input == null) {
            this.nextToken = null;
            return;
        }
        Object preprocessedToken = null;
        int quoteIndex = this.input.indexOf(34);
        int commaIndex = this.input.indexOf(44);
        if (commaIndex == -1) {
            this.nextToken = this.input;
            this.input = null;
            return;
        }
        if (quoteIndex != -1 && quoteIndex < commaIndex) {
            int quoteCount = 1;
            boolean inQuoteRegion = true;
            while (inQuoteRegion && (quoteIndex = this.input.indexOf(34, quoteIndex + 1)) != -1) {
                while (quoteIndex > commaIndex) {
                    if (quoteCount % 2 == 1) {
                        commaIndex = this.input.indexOf(44, commaIndex + 1);
                        continue;
                    }
                    inQuoteRegion = false;
                    break;
                }
                ++quoteCount;
            }
        }
        this.nextToken = this.input.substring(0, commaIndex);
        this.input = this.input.substring(commaIndex + 1);
    }

    public boolean hasMoreTokens() {
        return this.nextToken != null;
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() {
        return this.nextToken();
    }

    private String processToken(String preprocessedToken) {
        String returnToken = null;
        returnToken = preprocessedToken.trim();
        returnToken = returnToken.replaceAll(TWOQUOTES, QUOTE);
        returnToken = this.unwrapString(returnToken);
        return returnToken;
    }

    private String unwrapString(String value) {
        if (value == null || value.length() < 2) {
            return value;
        }
        int lastIndex = value.length() - 1;
        if (value.charAt(0) == '\"' && value.charAt(lastIndex) == '\"') {
            return value.substring(1, lastIndex);
        }
        return value;
    }
}

