/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.sample.svg.generator;

import java.io.Serializable;
import java.util.Date;
import org.eclipse.hyades.ui.sample.svg.generator.DataInputProcessingException;
import org.eclipse.hyades.ui.sample.svg.generator.DataPoint;
import org.eclipse.hyades.ui.sample.svg.generator.DataRange;
import org.eclipse.hyades.ui.sample.svg.generator.DataSet;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicAttributes;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicDocumentProperties;
import org.eclipse.hyades.ui.sample.svg.generator.IDataInputProcessingExceptionCodes;
import org.eclipse.hyades.ui.sample.svg.generator.IGraphicDocumentStyle;
import org.eclipse.hyades.ui.sample.svg.generator.SVGXYChart;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGLineChart
extends SVGXYChart
implements IGraphicDocumentStyle,
IDataInputProcessingExceptionCodes,
Serializable {
    public SVGLineChart() {
        this.graphicType = "line";
    }

    public Document generateGraphicDocument(GraphicDocumentProperties input) throws DataInputProcessingException {
        double maxAlloableLegendWidth;
        double maxLengthOfLegendLableWidth;
        double maxAllowableYMarkerWidth;
        GraphicAttributes graphicAttrs = this.createGraphicAttributes(input);
        Document newDataDocument = graphicAttrs.getDataDocument();
        int numberOfDatasets = 0;
        try {
            numberOfDatasets = this.dataRetriever.getNumberOfDatasets(newDataDocument);
        }
        catch (DataInputProcessingException e) {
            e.setWidgetType(this.graphicType);
            throw e;
        }
        String rangeMaxValue = null;
        int gridXOffset = 60;
        int halfGridXOffset = gridXOffset / 2;
        int gridYOffset = 50;
        try {
            this.xAxis = this.dataRetriever.getDataRange(newDataDocument, "S");
        }
        catch (DataInputProcessingException e) {
            e.setWidgetType(this.getGraphicType());
            throw e;
        }
        try {
            this.yAxis = this.dataRetriever.getDataRange(newDataDocument, "W");
        }
        catch (DataInputProcessingException e) {
            e.setWidgetType(this.getGraphicType());
            throw e;
        }
        if (this.xAxis == null || this.yAxis == null) {
            throw new DataInputProcessingException("", 126, "dataRange", this.getGraphicType());
        }
        if (this.xAxis.getType() != 0 || this.yAxis.getType() != 0) {
            throw new DataInputProcessingException("", 129, "dataRange", this.getGraphicType());
        }
        this.xMarkers = this.xAxis.getSegmentMarkers();
        this.yMarkers = this.yAxis.getSegmentMarkers();
        if (this.yMarkers != null && this.yMarkers.length > 0) {
            rangeMaxValue = this.yMarkers[this.yMarkers.length - 1].getValueString();
        }
        this.dataSets = new DataSet[numberOfDatasets];
        for (int i = 0; i < numberOfDatasets; ++i) {
            this.dataSets[i] = this.dataRetriever.getDatasetWithPosition(newDataDocument, Integer.toString(i));
        }
        this.legendFlyOverLabels = this.getLegendFlyOverLabels(this.dataSets);
        double maxLengthOfYmarkerWidth = this.getMaxLengthOfYmarker(this.yMarkers, graphicAttrs);
        if (maxLengthOfYmarkerWidth > (maxAllowableYMarkerWidth = (double)(graphicAttrs.getGraphicWidth() / 4))) {
            maxLengthOfYmarkerWidth = maxAllowableYMarkerWidth;
        }
        if ((maxLengthOfLegendLableWidth = this.getMaxLengthOfLegendLabel(graphicAttrs, this.dataSets)) > (maxAlloableLegendWidth = (double)(graphicAttrs.getGraphicWidth() / 3))) {
            maxLengthOfLegendLableWidth = maxAlloableLegendWidth;
        }
        if (graphicAttrs.isLegendSuppressed()) {
            maxLengthOfLegendLableWidth = 0.0;
        }
        int xAxisLength = (int)((double)graphicAttrs.getGraphicWidth() - (maxLengthOfLegendLableWidth + maxLengthOfYmarkerWidth + (double)gridXOffset));
        int xLabelRowCount = this.getNumberOfAxisLabels(graphicAttrs, xAxisLength, this.xAxis);
        int yAxisLength = (int)((double)graphicAttrs.getGraphicHeight() - (double)gridYOffset * 2.5 - (double)(xLabelRowCount * 10));
        Document generatedDocument = this.createSvgDocument(newDataDocument.getImplementation(), Short.toString(graphicAttrs.getGraphicWidth()), Short.toString(graphicAttrs.getGraphicHeight()));
        Element svgRoot = generatedDocument.getDocumentElement();
        this.registerEventHandler(svgRoot, "onload", "init(evt)");
        this.addDefinitions(generatedDocument, graphicAttrs, numberOfDatasets);
        this.addJavaScriptFunctions(generatedDocument, graphicAttrs, numberOfDatasets, gridXOffset, gridYOffset, xAxisLength, yAxisLength);
        if (!graphicAttrs.isOutlineSuppressed()) {
            this.addOutline(generatedDocument, graphicAttrs);
        }
        if (!graphicAttrs.isTimestampSuppressed()) {
            try {
                String timestamp = this.dataRetriever.getTimestamp(newDataDocument);
                Date date = GraphicAttributes.parseISO8601Date(timestamp);
                this.addTimeStamp(generatedDocument, graphicAttrs, date == null ? timestamp : graphicAttrs.formatDate(date));
            }
            catch (DataInputProcessingException e) {
                e.setWidgetType(this.graphicType);
                throw e;
            }
        }
        if (!graphicAttrs.isTitlebarSuppressed()) {
            this.addTitleBar(generatedDocument, graphicAttrs);
        } else {
            gridYOffset = super.resetGridOffsetForCenter(graphicAttrs.getGraphicHeight(), yAxisLength, 3.0);
        }
        if (!graphicAttrs.isUserPreferencesSuppressed() && graphicAttrs.getSvgFormatOnly()) {
            this.addPreferenceIcon(generatedDocument, graphicAttrs);
        }
        gridXOffset = halfGridXOffset + (int)maxLengthOfYmarkerWidth;
        this.addGrid(generatedDocument, svgRoot, xAxisLength, yAxisLength, gridXOffset, gridYOffset, this.xAxis, this.yAxis);
        this.addAxisLabels(generatedDocument, graphicAttrs, svgRoot, xAxisLength, yAxisLength, gridXOffset, gridYOffset, this.xAxis, this.yAxis);
        this.addTitles(generatedDocument, graphicAttrs, svgRoot, xAxisLength, yAxisLength, gridXOffset, gridYOffset, this.xAxis, this.yAxis, xLabelRowCount, rangeMaxValue);
        Element gTextBoxElement = generatedDocument.createElement("g");
        this.addDataSets(generatedDocument, graphicAttrs, svgRoot, gTextBoxElement, xAxisLength, yAxisLength, gridXOffset, gridYOffset, this.xAxis, this.yAxis, this.dataSets);
        if (!graphicAttrs.isLegendSuppressed()) {
            try {
                String[] legendLabels = this.dataRetriever.getLegendLabels(newDataDocument);
                this.addLegend(generatedDocument, graphicAttrs, gTextBoxElement, legendLabels, this.legendFlyOverLabels, (int)maxLengthOfYmarkerWidth + xAxisLength + halfGridXOffset, gridYOffset);
            }
            catch (DataInputProcessingException e) {
                e.setWidgetType(this.graphicType);
                throw e;
            }
        }
        svgRoot.appendChild(gTextBoxElement);
        return generatedDocument;
    }

    protected Element addLegendItemGraphic(Document generatedDocument, Element parent, int index, int fontSize, int x, int y) {
        String[] legendShapeType = new String[]{"#legendcircleshape", "#legendsquareshape", "#legendhorizontalrectshape", "#legendverticalrectshape", "#legendtriangleshape", "#legenddiamondshape"};
        super.addLegendItemGraphic(generatedDocument, parent, index, fontSize, x, y);
        Element useElementShape = generatedDocument.createElement("use");
        useElementShape.setAttribute("xlink:href", legendShapeType[index % legendShapeType.length]);
        useElementShape.setAttribute("x", Integer.toString(x));
        useElementShape.setAttribute("y", Integer.toString(y + fontSize - 8));
        Element gColourElement = generatedDocument.createElement("g");
        gColourElement.setAttribute("id", "shape" + index);
        gColourElement.setAttribute("onclick", "toggleVisibility('dataColour" + index + "');");
        gColourElement.setAttribute("class", "shape" + index);
        gColourElement.appendChild(useElementShape);
        return gColourElement;
    }

    private void addDataSets(Document generatedDocument, GraphicAttributes attrs, Element parent, Element gTextBoxElement, int xAxisLength, int yAxisLength, int gridXOffset, int gridYOffset, DataRange xAxis, DataRange yAxis, DataSet[] dataSets) throws DataInputProcessingException {
        double xMin = xAxis.getMinValue();
        double xMax = xAxis.getMaxValue();
        double yMin = yAxis.getMinValue();
        double yMax = yAxis.getMaxValue();
        if (xMin == xMax || yMin == yMax) {
            return;
        }
        for (int i = 0; i < dataSets.length; ++i) {
            DataSet dataset = dataSets[i];
            DataPoint[] dps = dataset.getDataPoints();
            double[] yPositions = new double[dps.length];
            double[] xPositions = new double[dps.length];
            for (int j = 0; j < dps.length; ++j) {
                xPositions[j] = (double)xAxisLength * (dps[j].getValue1() - xMin) / (xMax - xMin);
                yPositions[j] = (double)yAxisLength * (yMax - dps[j].getValue2()) / (yMax - yMin);
            }
            this.addLine(generatedDocument, parent, dps, i, xPositions, yPositions, xAxisLength, yAxisLength, gridXOffset, gridYOffset);
            String stylesheetClass = "dataValues anchorAtMiddle";
            Element gToggleElement = generatedDocument.createElement("g");
            gToggleElement.setAttribute("id", "textbox" + i);
            gToggleElement.setAttribute("class", stylesheetClass);
            gToggleElement.setAttribute("transform", "translate(" + gridXOffset + "," + gridYOffset + ")");
            gToggleElement.setAttribute("visibility", "hidden");
            gToggleElement.setAttribute("onclick", "toggleVisibility('textbox" + i + "');");
            gTextBoxElement.appendChild(gToggleElement);
            this.addTextBoxes(generatedDocument, attrs, gToggleElement, i, xPositions, yPositions, dps, xAxisLength, yAxisLength);
        }
    }

    private void addDefaultInternalStylesheet(Document generatedDocument, GraphicAttributes attrs, Element parent, int sets) {
        StringBuffer styleRules = new StringBuffer(" .st1{fill-rule:nonzero;clip-rule:nonzero;stroke:#000000;stroke-miterlimit:4;} .outline{stroke-width:0.75pt; stroke:#666666; fill:#ffffff;} .keyline{stroke-width:0.75pt; stroke:#666666;} .graphTitle {font-weight:bold; font-style:normal; font-size:11pt; fill:#000000; stroke-width:0.75pt;} .labelsValues {font-weight:normal; font-style:normal; font-size:10pt; fill:#000000;} .dataValues {font-weight:normal; font-style:normal; font-size:8pt; fill:#000000;} .timeStamp {font-weight:normal; font-style:normal; font-size:8pt; fill:#000000; text-anchor:end; opacity:0.5} .legendTitle {font-weight:normal; font-style:normal; font-size:10pt; fill:#000000; text-anchor:start; opacity:0.6} .legendData {font-weight:normal; font-style:normal; font-size:9pt; text-anchor:start; fill:#000000;} .anchorAtEnd {text-anchor: end;} .anchorAtStart {text-anchor: start;} .anchorAtMiddle {text-anchor: middle;}");
        styleRules.append(" .grid{stroke-width:0.75pt; stroke:#000000;} .gridline{stroke-width:0.75pt; stroke:#cccccc;} .griddashline{stroke-width:0.75pt; stroke:#cccccc; stroke-dasharray:2; fill:none;} .axisLines{fill:none;} .axisTicks{fill:none;} .solidLine{fill:none;stroke:#CCCCCC;stroke-width:1;} .dashLine{fill:none;stroke:#CCCCCC;stroke-width:1;stroke-dasharray:2;} .catOutline{fill:none;} .catColor{fill:#003399;stroke:none;} .exactValuesBox{fill:#FFFFCC;stroke:#999999;stroke-width:1;} .xyTitleLabels {font-weight:normal; font-style:normal; font-size:10pt; fill:#000000; opacity:0.6}");
        String[] palette = (String[])attrs.getGraphicColorPalette().get(attrs.getGraphicColorPaletteName());
        int paletteLength = palette.length;
        int j = 0;
        for (int i = 0; i < sets; ++i) {
            j = (i + 1) % paletteLength;
            j = j == 0 ? paletteLength - 1 : j - 1;
            styleRules.append(" .dataset" + i + "{stroke-linecap:round;stroke-width:0.75pt; stroke:" + palette[j] + ";}");
            if (attrs.isLegendSuppressed()) continue;
            styleRules.append(" .shapeline" + i + "{stroke-width:0.75pt;stroke:" + palette[j] + ";fill:" + palette[j] + ";}");
            styleRules.append(" .shape" + i + "{ fill:" + palette[j] + ";}");
        }
        CDATASection newCDATASection = generatedDocument.createCDATASection(styleRules.toString());
        Element newElement = generatedDocument.createElement("style");
        newElement.setAttribute("id", "defaultStyleRules");
        newElement.setAttribute("type", "text/css");
        newElement.appendChild(newCDATASection);
        parent.appendChild(newElement);
    }

    protected void addDefinitions(Document generatedDocument, GraphicAttributes attrs, int numberOfDatasets) {
        Element defsElement = super.addDefinitions(generatedDocument, attrs);
        this.addDefaultInternalStylesheet(generatedDocument, attrs, defsElement, numberOfDatasets);
        if (!attrs.isLegendSuppressed()) {
            Element gElement_legendsquare = generatedDocument.createElement("g");
            defsElement.appendChild(gElement_legendsquare);
            gElement_legendsquare.setAttribute("id", "legendsquareshape");
            Element legendsquareElement = generatedDocument.createElement("rect");
            gElement_legendsquare.appendChild(legendsquareElement);
            legendsquareElement.setAttribute("width", "8");
            legendsquareElement.setAttribute("height", "8");
            legendsquareElement.setAttribute("transform", "translate(3,0)");
            gElement_legendsquare.appendChild(this.addLegendShapeLine(generatedDocument));
            Element gElement_legendcircle = generatedDocument.createElement("g");
            defsElement.appendChild(gElement_legendcircle);
            gElement_legendcircle.setAttribute("id", "legendcircleshape");
            Element legendcircleElement = generatedDocument.createElement("circle");
            gElement_legendcircle.appendChild(legendcircleElement);
            legendcircleElement.setAttribute("r", "4");
            legendcircleElement.setAttribute("cx", "4");
            legendcircleElement.setAttribute("cy", "4");
            legendcircleElement.setAttribute("transform", "translate(3,0)");
            gElement_legendcircle.appendChild(this.addLegendShapeLine(generatedDocument));
            Element gElement_legenddiamond = generatedDocument.createElement("g");
            defsElement.appendChild(gElement_legenddiamond);
            gElement_legenddiamond.setAttribute("id", "legenddiamondshape");
            Element legenddiamondElement = generatedDocument.createElement("polygon");
            gElement_legenddiamond.appendChild(legenddiamondElement);
            legenddiamondElement.setAttribute("points", "0,4 4,0 8,4 4,8");
            legenddiamondElement.setAttribute("transform", "translate(3,0)");
            gElement_legenddiamond.appendChild(this.addLegendShapeLine(generatedDocument));
            Element gElement_legendhorizontalrectshape = generatedDocument.createElement("g");
            defsElement.appendChild(gElement_legendhorizontalrectshape);
            gElement_legendhorizontalrectshape.setAttribute("id", "legendhorizontalrectshape");
            Element legendhorizontalrectElement = generatedDocument.createElement("rect");
            gElement_legendhorizontalrectshape.appendChild(legendhorizontalrectElement);
            legendhorizontalrectElement.setAttribute("width", "8");
            legendhorizontalrectElement.setAttribute("height", "4");
            legendhorizontalrectElement.setAttribute("transform", "translate(3,2)");
            gElement_legendhorizontalrectshape.appendChild(this.addLegendShapeLine(generatedDocument));
            Element gElement_legendverticalrectshape = generatedDocument.createElement("g");
            defsElement.appendChild(gElement_legendverticalrectshape);
            gElement_legendverticalrectshape.setAttribute("id", "legendverticalrectshape");
            Element legendverticalrectElement = generatedDocument.createElement("rect");
            gElement_legendverticalrectshape.appendChild(legendverticalrectElement);
            legendverticalrectElement.setAttribute("width", "4");
            legendverticalrectElement.setAttribute("height", "8");
            legendverticalrectElement.setAttribute("transform", "translate(5,0)");
            gElement_legendverticalrectshape.appendChild(this.addLegendShapeLine(generatedDocument));
            Element gElement_legendtriangleshape = generatedDocument.createElement("g");
            defsElement.appendChild(gElement_legendtriangleshape);
            gElement_legendtriangleshape.setAttribute("id", "legendtriangleshape");
            Element legendtriangleElement = generatedDocument.createElement("polygon");
            legendtriangleElement.setAttribute("points", "4 0, 0 8, 8 8");
            legendtriangleElement.setAttribute("transform", "translate(3,0)");
            gElement_legendtriangleshape.appendChild(legendtriangleElement);
            gElement_legendtriangleshape.appendChild(this.addLegendShapeLine(generatedDocument));
        }
        Element gElement_square = generatedDocument.createElement("g");
        defsElement.appendChild(gElement_square);
        gElement_square.setAttribute("id", "squareshape");
        Element squareElement = generatedDocument.createElement("rect");
        gElement_square.appendChild(squareElement);
        squareElement.setAttribute("width", "5.6");
        squareElement.setAttribute("height", "5.6");
        Element gElement_circle = generatedDocument.createElement("g");
        defsElement.appendChild(gElement_circle);
        gElement_circle.setAttribute("id", "circleshape");
        Element circleElement = generatedDocument.createElement("circle");
        gElement_circle.appendChild(circleElement);
        circleElement.setAttribute("r", "2.8");
        circleElement.setAttribute("cx", "2.8");
        circleElement.setAttribute("cy", "2.8");
        Element gElement_hole = generatedDocument.createElement("g");
        defsElement.appendChild(gElement_hole);
        gElement_hole.setAttribute("id", "holeshape");
        Element holeElement = generatedDocument.createElement("circle");
        gElement_hole.appendChild(holeElement);
        holeElement.setAttribute("r", "2.8");
        holeElement.setAttribute("cx", "2.8");
        holeElement.setAttribute("cy", "2.8");
        holeElement.setAttribute("style", "fill:none;");
        Element gElement_diamond = generatedDocument.createElement("g");
        defsElement.appendChild(gElement_diamond);
        gElement_diamond.setAttribute("id", "diamondshape");
        Element diamondElement = generatedDocument.createElement("polygon");
        gElement_diamond.appendChild(diamondElement);
        diamondElement.setAttribute("points", "0,2.8 2.8,0 5.6,2.8 2.8,5.6");
        Element gElement_horizontalrectshape = generatedDocument.createElement("g");
        defsElement.appendChild(gElement_horizontalrectshape);
        gElement_horizontalrectshape.setAttribute("id", "horizontalrectshape");
        Element horizontalrectElement = generatedDocument.createElement("rect");
        gElement_horizontalrectshape.appendChild(horizontalrectElement);
        horizontalrectElement.setAttribute("width", "5.6");
        horizontalrectElement.setAttribute("height", "2.8");
        Element gElement_verticalrectshape = generatedDocument.createElement("g");
        defsElement.appendChild(gElement_verticalrectshape);
        gElement_verticalrectshape.setAttribute("id", "verticalrectshape");
        Element verticalrectElement = generatedDocument.createElement("rect");
        verticalrectElement.setAttribute("width", "2.8");
        verticalrectElement.setAttribute("height", "5.6");
        gElement_verticalrectshape.appendChild(verticalrectElement);
        Element gElement_triangleshape = generatedDocument.createElement("g");
        defsElement.appendChild(gElement_triangleshape);
        gElement_triangleshape.setAttribute("id", "triangleshape");
        Element triangleElement = generatedDocument.createElement("polygon");
        triangleElement.setAttribute("points", "2.8 0, 0 5.6, 5.6 5.6");
        gElement_triangleshape.appendChild(triangleElement);
    }

    private Element addLegendShapeLine(Document generatedDocument) {
        Element lineElement = generatedDocument.createElement("polyline");
        lineElement.setAttribute("points", "0 4, 14 4");
        return lineElement;
    }

    private void addLine(Document generatedDocument, Element parent, DataPoint[] dps, int linesetNumber, double[] xPositions, double[] yPositions, int xAxisLength, int yAxisLength, int gridXOffset, int gridYOffset) {
        String[] shapeType = new String[]{"#circleshape", "#squareshape", "#horizontalrectshape", "#verticalrectshape", "#triangleshape", "#diamondshape"};
        double[] shapeWidth = new double[]{5.6, 5.6, 5.6, 2.8, 5.6, 5.6};
        double[] shapeHeight = new double[]{5.6, 5.6, 2.8, 5.6, 4.85, 5.6};
        double BOX_HEIGHT = 18.0;
        int length = xPositions.length;
        double xPrevious = 0.0;
        double yPrevious = 0.0;
        Element gColourElement = generatedDocument.createElement("g");
        gColourElement.setAttribute("id", "dataColour" + linesetNumber);
        gColourElement.setAttribute("class", "dataset" + linesetNumber);
        gColourElement.setAttribute("visibility", "visible");
        gColourElement.setAttribute("onclick", "toggleVisibility('textbox" + linesetNumber + "');");
        parent.appendChild(gColourElement);
        int shapeNumber = linesetNumber % shapeType.length;
        for (int i = 0; i < length; ++i) {
            double shapeX;
            double xNext = xPositions[i];
            double yNext = yPositions[i];
            if (i > 0) {
                Element newElement = generatedDocument.createElement("polyline");
                String points = xPrevious + " " + yPrevious + "," + xNext + " " + yNext;
                newElement.setAttribute("points", points);
                if (dps[i].getType() == 1 || dps[i - 1].getType() == 1) {
                    newElement.setAttribute("style", "stroke-dasharray: 9, 5; stroke-width: 2;");
                }
                newElement.setAttribute("transform", "translate(" + gridXOffset + "," + gridYOffset + ")");
                gColourElement.appendChild(newElement);
            }
            if ((shapeX = xNext - shapeWidth[shapeNumber] / 2.0) <= 0.0) {
                shapeX = 0.0;
            } else if (shapeX + shapeWidth[shapeNumber] > (double)xAxisLength) {
                shapeX = (double)xAxisLength - shapeWidth[shapeNumber];
            }
            double shapeY = yNext - shapeHeight[shapeNumber] / 2.0;
            if (shapeY + shapeHeight[shapeNumber] > (double)yAxisLength) {
                shapeY = (double)yAxisLength - shapeHeight[shapeNumber];
            }
            Element shapeElement = generatedDocument.createElement("use");
            if (dps[i].getType() == 1) {
                shapeElement.setAttribute("xlink:href", "#holeshape");
            } else {
                shapeElement.setAttribute("xlink:href", shapeType[shapeNumber]);
            }
            shapeElement.setAttribute("transform", "translate(" + ((double)gridXOffset + shapeX) + "," + ((double)gridYOffset + shapeY) + ")");
            shapeElement.setAttribute("visibility", "visible");
            gColourElement.appendChild(shapeElement);
            xPrevious = xNext;
            yPrevious = yNext;
        }
    }

    protected void addTextBoxes(Document generatedDocument, GraphicAttributes attrs, Element parent, int id, double[] xPositions, double[] yPositions, DataPoint[] dps, int xAxisLength, int yAxisLength) {
        int length = xPositions.length;
        for (int i = 0; i < length; ++i) {
            String label = dps[i].getDisplayLabel(attrs);
            double textWidth = label.length();
            double boxWidth = 16.0 + (textWidth - 1.0) * 6.0;
            double boxHeight = 18.0;
            double xPos = xPositions[i];
            double yPos = yPositions[i];
            double boxXPos = xPos;
            double boxYPos = yPos;
            this.addEachTextBox(generatedDocument, attrs, parent, boxXPos, boxYPos, boxWidth, boxHeight, label, id, i);
        }
    }

    protected GraphicAttributes createGraphicAttributes(GraphicDocumentProperties input) throws DataInputProcessingException {
        GraphicAttributes graphicAttrs = new GraphicAttributes();
        graphicAttrs.setGraphicWidth("450");
        graphicAttrs.setPreferencesPage("prefs_line.htm");
        graphicAttrs.setPreferencesPageWidth("430");
        graphicAttrs.setPreferencesPageHeight("495");
        graphicAttrs.setConfigDocument(input.getConfigDocument());
        graphicAttrs.setDataDocument(input.getDataDocument());
        this.getConfigAttributes(graphicAttrs);
        graphicAttrs.setAttributesFrom(input);
        return graphicAttrs;
    }
}

