/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.sample.svg.generator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.hyades.ui.sample.svg.generator.DataInputProcessingException;
import org.eclipse.hyades.ui.sample.svg.generator.DataRange;
import org.eclipse.hyades.ui.sample.svg.generator.DataSet;
import org.eclipse.hyades.ui.sample.svg.generator.ECMAScriptGenerator;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicAttributes;
import org.eclipse.hyades.ui.sample.svg.generator.IDataInputConstants;
import org.eclipse.hyades.ui.sample.svg.generator.SVGDocumentGenerator;
import org.eclipse.hyades.ui.sample.svg.generator.SegmentMarker;
import org.eclipse.hyades.ui.sample.svg.generator.XYChartDataRetriever;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class SVGXYChart
extends SVGDocumentGenerator
implements IDataInputConstants,
Serializable {
    protected final XYChartDataRetriever dataRetriever = new XYChartDataRetriever();
    protected final int axisLabelFontSize = 8;
    protected String[] legendFlyOverLabels = null;
    protected DataRange xAxis = null;
    protected DataRange yAxis = null;
    protected SegmentMarker[] xMarkers = null;
    protected SegmentMarker[] yMarkers = null;
    protected DataSet[] dataSets = null;

    SVGXYChart() {
    }

    protected void addJavaScriptFunctions(Document generatedDocument, GraphicAttributes attrs, int numberOfSets, int gridXOffset, int gridYOffset, int xAxisLength, int yAxisLength) {
        Element parent = generatedDocument.getDocumentElement();
        super.addJavaScriptFunctions(generatedDocument, attrs, numberOfSets, gridXOffset, gridYOffset, xAxisLength, yAxisLength);
        Element newElement = generatedDocument.createElement("script");
        newElement.setAttribute("type", "text/ecmascript");
        parent.appendChild(newElement);
        ECMAScriptGenerator jscript = new ECMAScriptGenerator();
        StringBuffer functions = new StringBuffer(jscript.generateXYChartHelperFunctions());
        CDATASection newCDATASection = generatedDocument.createCDATASection(functions.toString());
        newElement.appendChild(newCDATASection);
    }

    protected void addEachTextBox(Document generatedDocument, GraphicAttributes attrs, Element parent, double x, double y, double width, double height, String value, int dataSet, int next) {
        String stylesheetClass = "dataValues anchorAtMiddle";
        Element rectElement = generatedDocument.createElement("rect");
        rectElement.setAttribute("x", Double.toString(x));
        rectElement.setAttribute("y", Double.toString(y));
        rectElement.setAttribute("width", Double.toString(width));
        rectElement.setAttribute("height", Double.toString(height));
        rectElement.setAttribute("fill", "#FFFFCC");
        rectElement.setAttribute("stroke", "gray");
        rectElement.setAttribute("stroke-width", "1");
        rectElement.setAttribute("id", "textboxRect" + Integer.toString(dataSet) + Integer.toString(next));
        parent.appendChild(rectElement);
        Element textElement = generatedDocument.createElement("text");
        textElement.setAttribute("id", "textboxText" + dataSet + next);
        textElement.setAttribute("style", "text-anchor: middle");
        textElement.setAttribute("class", stylesheetClass);
        textElement.appendChild(generatedDocument.createTextNode(value));
        parent.appendChild(textElement);
    }

    private Element genNamedPolyLine(Document d, String className, String points) {
        Element e = d.createElement("polyline");
        e.setAttribute("class", className);
        e.setAttribute("fill", "none");
        e.setAttribute("points", points);
        return e;
    }

    private Element genNamedPolyLineGroup(Document d, String id, String className, String points) {
        Element e = d.createElement("g");
        e.setAttribute("id", id);
        e.appendChild(this.genNamedPolyLine(d, className, points));
        return e;
    }

    private Element gen2NamedPolyLineGroup(Document d, String id, String className1, String points1, String className2, String points2) {
        Element e = d.createElement("g");
        e.setAttribute("id", id);
        e.appendChild(this.genNamedPolyLine(d, className1, points1));
        e.appendChild(this.genNamedPolyLine(d, className2, points2));
        return e;
    }

    private Element genUseWithOffsets(Document d, String id, double xOffset, double yOffset) {
        Element e = d.createElement("use");
        e.setAttribute("xlink:href", "#" + id);
        e.setAttribute("x", Double.toString(xOffset));
        e.setAttribute("y", Double.toString(yOffset));
        return e;
    }

    protected void addGrid(Document generatedDocument, Element parent, int xAxisLength, int yAxisLength, int gridXOffset, int gridYOffset, DataRange xAxis, DataRange yAxis) {
        double value;
        Element defs = generatedDocument.createElement("defs");
        parent.appendChild(defs);
        defs.appendChild(this.genNamedPolyLineGroup(generatedDocument, "solidgridline", "gridline", "0 0 " + xAxisLength + " 0"));
        defs.appendChild(this.genNamedPolyLineGroup(generatedDocument, "dashgridline", "griddashline", "0 0 " + xAxisLength + " 0"));
        defs.appendChild(this.gen2NamedPolyLineGroup(generatedDocument, "tickline", "grid", "0 0 5 0", "grid", xAxisLength - 5 + " 0 " + xAxisLength + " 0"));
        defs.appendChild(this.genNamedPolyLineGroup(generatedDocument, "xtickline", "grid", "0 0 0 -5"));
        Element top = generatedDocument.createElement("g");
        parent.appendChild(top);
        top.setAttribute("transform", "translate(" + gridXOffset + "," + gridYOffset + ")");
        top.appendChild(this.genNamedPolyLine(generatedDocument, "grid", "0 0 0 " + yAxisLength + " " + xAxisLength + " " + yAxisLength + " " + xAxisLength + " 0"));
        boolean xIsCategory = xAxis.getType() == 1;
        double xMin = xAxis.getMinValue();
        double xMax = xAxis.getMaxValue();
        SegmentMarker[] xsms = xAxis.getSegmentMarkers();
        for (int i = 0; i < xsms.length; ++i) {
            SegmentMarker sm = xsms[i];
            double x = 0.0;
            if (xIsCategory) {
                double position = xsms[i].getPosition();
                if (position < 0.0 || position > 1.0) continue;
                x = (double)xAxisLength * position;
            } else {
                double value2 = xsms[i].getValue();
                if (value2 < xMin || value2 > xMax) continue;
                x = (double)xAxisLength * (value2 - xMin) / (xMax - xMin);
            }
            top.appendChild(this.genUseWithOffsets(generatedDocument, "xtickline", x, yAxisLength));
        }
        double yMin = yAxis.getMinValue();
        double yMax = yAxis.getMaxValue();
        SegmentMarker[] ysms = yAxis.getSegmentMarkers();
        for (int i = 0; i < ysms.length; ++i) {
            SegmentMarker sm = ysms[i];
            value = ysms[i].getValue();
            if (value < yMin || value > yMax) continue;
            double y = (int)((double)yAxisLength * (yMax - value) / (yMax - yMin));
            top.appendChild(this.genUseWithOffsets(generatedDocument, "tickline", 0.0, y));
            top.appendChild(this.genUseWithOffsets(generatedDocument, "solidgridline", 0.0, y));
        }
        double[] dashGridYPos = this.calculateDashGridPositions(ysms);
        for (int i = 0; i < dashGridYPos.length; ++i) {
            value = dashGridYPos[i];
            if (value < yMin || value > yMax) continue;
            int y = (int)((double)yAxisLength * (yMax - value) / (yMax - yMin));
            top.appendChild(this.genUseWithOffsets(generatedDocument, "dashgridline", 0.0, y));
        }
    }

    protected double[] calculateDashGridPositions(SegmentMarker[] sms) {
        double prevY = 0.0;
        double yLabelValue = 0.0;
        double nextDashY = 0.0;
        if (sms.length <= 1) {
            return new double[0];
        }
        int n = sms.length - 1;
        double[] dashpos = new double[n];
        double prev = sms[0].getValue();
        for (int i = 0; i < n; ++i) {
            double value = sms[i + 1].getValue();
            dashpos[i] = (prev + value) / 2.0;
            prev = value;
        }
        return dashpos;
    }

    protected void addTitles(Document generatedDocument, GraphicAttributes attrs, Element parent, int xAxisLength, int yAxisLength, int gridXOffset, int gridYOffset, DataRange xAxis, DataRange yAxis, int numberOfXLabelRows, String rangeMaxValue) {
        String stylesheetClass = null;
        Element gElement = null;
        int xAxisLabelYValue = yAxisLength + 8 + 5;
        String title = xAxis.getLabel();
        if (title != null) {
            stylesheetClass = "xyTitleLabels anchorAtMiddle";
            gElement = generatedDocument.createElement("g");
            gElement.setAttribute("transform", "translate(" + gridXOffset + "," + gridYOffset + ")");
            gElement.setAttribute("id", "labelsValues0");
            gElement.setAttribute("class", stylesheetClass);
            parent.appendChild(gElement);
            double xTitleYPosition = xAxisLabelYValue + (numberOfXLabelRows + 1) * 12;
            double graphicHeight = attrs.getGraphicHeight();
            if (xTitleYPosition + 14.0 > graphicHeight) {
                this.addLabel(generatedDocument, attrs, gElement, title, null, xAxisLength / 2, graphicHeight - 8.0, 0);
            } else {
                this.addLabel(generatedDocument, attrs, gElement, title, null, xAxisLength / 2, xTitleYPosition, 0);
            }
        }
        if ((title = yAxis.getLabel()) != null) {
            stylesheetClass = "xyTitleLabels anchorAtMiddle";
            gElement = generatedDocument.createElement("g");
            gElement.setAttribute("transform", "translate(30," + gridYOffset + ")");
            gElement.setAttribute("id", "labelsValues1");
            gElement.setAttribute("class", stylesheetClass);
            parent.appendChild(gElement);
            this.addLabel(generatedDocument, attrs, gElement, title, null, 0.0, (double)yAxisLength / 2.0, 270);
        }
    }

    protected void evenlyDistributeSegmentMarkers(DataRange dataRange) {
        if (dataRange == null) {
            return;
        }
        SegmentMarker[] sms = dataRange.getSegmentMarkers();
        if (sms == null) {
            return;
        }
        double w = 1.0 / (double)sms.length;
        double o = w / 2.0;
        for (int i = 0; i < sms.length; ++i) {
            sms[i].setPosition(o + w * (double)i);
        }
    }

    protected void addAxisLabels(Document generatedDocument, GraphicAttributes attrs, Element parent, int xAxisLength, int yAxisLength, int gridXOffset, int gridYOffset, DataRange xAxis, DataRange yAxis) {
        String XstylesheetClass = "dataValues anchorAtMiddle";
        String YstylesheetClass = "dataValues anchorAtEnd";
        Element gElement = generatedDocument.createElement("g");
        parent.appendChild(gElement);
        gElement.setAttribute("transform", "translate(" + gridXOffset + "," + gridYOffset + ")");
        gElement.setAttribute("id", "dataValues0");
        gElement.setAttribute("class", XstylesheetClass);
        int xAxisLabelYValue = yAxisLength + 8 + 5;
        double xMin = xAxis.getMinValue();
        double xMax = xAxis.getMaxValue();
        SegmentMarker[] xsms = xAxis.getSegmentMarkers();
        boolean xIsCategory = xAxis.getType() == 1;
        for (int i = 0; i < xsms.length; ++i) {
            SegmentMarker sm = xsms[i];
            double x = 0.0;
            if (xIsCategory) {
                double position = xsms[i].getPosition();
                if (position < 0.0 || position > 1.0) continue;
                x = (double)xAxisLength * position;
            } else {
                double value = xsms[i].getValue();
                if (value < xMin || value > xMax) continue;
                x = (double)xAxisLength * (value - xMin) / (xMax - xMin);
            }
            String label = xsms[i].getLabel();
            if (label == null) {
                label = attrs.formatNumber(xsms[i].getValue());
            }
            String[] newXLabels = this.wrapXLabel(label);
            double y = xAxisLabelYValue;
            for (int j = 0; j < newXLabels.length; ++j) {
                this.addLabel(generatedDocument, attrs, gElement, newXLabels[j], XstylesheetClass, x, y, 0);
                y += 12.0;
            }
        }
        gElement = generatedDocument.createElement("g");
        parent.appendChild(gElement);
        gElement.setAttribute("transform", "translate(" + gridXOffset + "," + gridYOffset + ")");
        gElement.setAttribute("id", "dataValues1");
        gElement.setAttribute("class", YstylesheetClass);
        double x = -5.0;
        double yMin = yAxis.getMinValue();
        double yMax = yAxis.getMaxValue();
        SegmentMarker[] ysms = yAxis.getSegmentMarkers();
        double maxY = (double)yAxisLength + 4.0;
        for (int i = 0; i < ysms.length; ++i) {
            SegmentMarker sm = ysms[i];
            double value = ysms[i].getValue();
            if (value < yMin || value > yMax) continue;
            double y = (double)yAxisLength * (yMax - value) / (yMax - yMin) + 4.0;
            String label = ysms[i].getLabel();
            if (label == null) {
                label = attrs.formatNumber(ysms[i].getValue());
            }
            this.addLabel(generatedDocument, attrs, gElement, label, YstylesheetClass, x, y, 0);
        }
    }

    protected int getNumberOfAxisLabels(GraphicAttributes attrs, int xAxisLength, DataRange xAxis) {
        double xMin = xAxis.getMinValue();
        double xMax = xAxis.getMaxValue();
        SegmentMarker[] xsms = xAxis.getSegmentMarkers();
        int maxXLabelRows = 0;
        boolean xIsCategory = xAxis.getType() == 1;
        for (int i = 0; i < xsms.length; ++i) {
            String[] newXLabels;
            SegmentMarker sm = xsms[i];
            double x = 0.0;
            if (xIsCategory) {
                double position = xsms[i].getPosition();
                if (position < 0.0 || position > 1.0) continue;
                x = (double)xAxisLength * position;
            } else {
                double value = xsms[i].getValue();
                if (value < xMin || value > xMax) continue;
                x = (double)xAxisLength * (value - xMin) / (xMax - xMin);
            }
            String label = xsms[i].getLabel();
            if (label == null) {
                label = attrs.formatNumber(xsms[i].getValue());
            }
            if ((newXLabels = this.wrapXLabel(label)).length <= maxXLabelRows) continue;
            maxXLabelRows = newXLabels.length;
        }
        return maxXLabelRows;
    }

    private String[] wrapXLabel(String label) {
        ArrayList<String> wrapStrings = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(label, " ");
        while (st.hasMoreElements()) {
            wrapStrings.add(st.nextElement().toString());
        }
        return wrapStrings.toArray(new String[wrapStrings.size()]);
    }

    protected Vector calculateDashGridYPositions(String[] yAxisLabels) {
        double prevY = 0.0;
        double yLabelValue = 0.0;
        double nextDashY = 0.0;
        Vector<String> dashY = new Vector<String>();
        for (int i = 0; i < yAxisLabels.length; ++i) {
            yLabelValue = Double.parseDouble(yAxisLabels[i]);
            nextDashY = (prevY + yLabelValue) / 2.0;
            dashY.add(Double.toString(nextDashY));
            prevY = yLabelValue;
        }
        return dashY;
    }

    protected void getConfigAttributes(GraphicAttributes attrs) throws DataInputProcessingException {
        Hashtable configProperties = this.dataRetriever.getConfigurationAttributes(attrs.getConfigDocument(), attrs.getDataDocument());
        if (configProperties == null) {
            return;
        }
        String width = (String)configProperties.get("width");
        String height = (String)configProperties.get("height");
        String title = (String)configProperties.get("title");
        String timestampPrefix = (String)configProperties.get("timestampPrefix");
        String legendTitle = (String)configProperties.get("legendTitle");
        if (width != null) {
            attrs.setGraphicWidth(width);
        }
        if (height != null) {
            attrs.setGraphicHeight(height);
        }
        if (title != null) {
            attrs.setGraphicTitle(title);
        }
        if (timestampPrefix != null) {
            attrs.setGraphicTimestampPrefix(timestampPrefix);
        }
        if (legendTitle != null) {
            attrs.setGraphicLegendTitle(legendTitle);
        }
    }

    protected int resetGridOffsetForCentering(short dimensionLength, int axisLength) {
        return (int)((double)(dimensionLength - axisLength) / 2.0);
    }

    protected int resetGridOffsetForCenter(short dimensionLength, int axisLength, double offset) {
        return (int)((double)(dimensionLength - axisLength) / offset);
    }

    protected double getMaxLengthOfYmarker(SegmentMarker[] yMarkers, GraphicAttributes graphicAttrs) {
        int maxLengthOfYmarker = 0;
        for (int i = 0; i < yMarkers.length; ++i) {
            int length;
            String label = yMarkers[i].getDisplayLabel(graphicAttrs);
            if (label == null || maxLengthOfYmarker >= (length = label.length())) continue;
            maxLengthOfYmarker = length;
        }
        return 16.0 + (double)maxLengthOfYmarker * 6.0;
    }
}

