/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.harness.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.hyades.execution.core.IExecutionComponentFactory;
import org.eclipse.hyades.execution.harness.ExecutionHarnessDataProcessorFactory;
import org.eclipse.hyades.execution.harness.util.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StandaloneExecutionUtilities {
    public static void initializeRegisteredExecutionComponents(String[] standaloneConfigurationFiles, HashMap testTypeMap, IExecutionComponentFactory factory, ExecutionHarnessDataProcessorFactory dpFactory) throws ClassNotFoundException, FileNotFoundException {
        ArrayList dataProcessorCollection = new ArrayList();
        for (int i = 0; i < standaloneConfigurationFiles.length; ++i) {
            StandaloneExecutionUtilities.parseConfigFile(standaloneConfigurationFiles[i], testTypeMap, factory, dataProcessorCollection);
        }
        ExecutionHarnessDataProcessorFactory.setStandAloneClassObjects(dataProcessorCollection);
    }

    private static void parseConfigFile(String configFile, HashMap testTypeMap, IExecutionComponentFactory factory, ArrayList dataProcessors) throws ClassNotFoundException, FileNotFoundException {
        FileInputStream stream = new FileInputStream(configFile);
        Element plugin = XMLUtil.loadDom(stream, "plugin");
        NodeList nodeList = XMLUtil.getChildrenByName(plugin, "extension");
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                NodeList envAdapters;
                int j;
                Element extensionElement;
                if (!(nodeList.item(i) instanceof Element) || (extensionElement = (Element)nodeList.item(i)) == null) continue;
                if (extensionElement.getAttribute("point").equals("org.eclipse.hyades.execution.harness.RegisteredExecutionComponentImpl")) {
                    NodeList execComps = XMLUtil.getChildrenByName(extensionElement, "RegisteredExecutionComponentImpl");
                    for (j = 0; j < execComps.getLength(); ++j) {
                        if (!(execComps.item(j) instanceof Element)) continue;
                        StandaloneExecutionUtilities.parseRegisteredExecutionComponents((Element)execComps.item(j), testTypeMap, factory);
                    }
                }
                if (extensionElement.getAttribute("point").equals("org.eclipse.hyades.execution.harness.ExecutionEnvironmentAdapter")) {
                    envAdapters = XMLUtil.getChildrenByName(extensionElement, "ExecutionEnvironmentAdapter");
                    for (j = 0; j < envAdapters.getLength(); ++j) {
                        if (!(envAdapters.item(j) instanceof Element)) continue;
                        StandaloneExecutionUtilities.parseAdapters((Element)envAdapters.item(j), testTypeMap, "EXECUTION_ENVIRONMENT_ADAPTER");
                    }
                }
                if (extensionElement.getAttribute("point").equals("org.eclipse.hyades.execution.harness.ExecutableObjectAdapter")) {
                    NodeList execObjAdapters = XMLUtil.getChildrenByName(extensionElement, "ExecutableObjectAdapter");
                    for (j = 0; j < execObjAdapters.getLength(); ++j) {
                        if (!(execObjAdapters.item(j) instanceof Element)) continue;
                        StandaloneExecutionUtilities.parseAdapters((Element)execObjAdapters.item(j), testTypeMap, "EXECUTABLE_OBJECT_ADAPTER");
                    }
                }
                if (extensionElement.getAttribute("point").equals("org.eclipse.hyades.execution.harness.ExecutionDeploymentAdapter")) {
                    envAdapters = XMLUtil.getChildrenByName(extensionElement, "ExecutionDeploymentAdapter");
                    for (j = 0; j < envAdapters.getLength(); ++j) {
                        if (!(envAdapters.item(j) instanceof Element)) continue;
                        StandaloneExecutionUtilities.parseAdapters((Element)envAdapters.item(j), testTypeMap, "EXECUTION_DEPLOYMENT_ADAPTER");
                    }
                }
                if (!extensionElement.getAttribute("point").equals("org.eclipse.hyades.execution.harness.Dataprocessor")) continue;
                NodeList dataProcessorNodeList = XMLUtil.getChildrenByName(extensionElement, "dataprocessor");
                for (j = 0; j < dataProcessorNodeList.getLength(); ++j) {
                    if (!(dataProcessorNodeList.item(j) instanceof Element)) continue;
                    StandaloneExecutionUtilities.parseDataProcessors((Element)dataProcessorNodeList.item(j), dataProcessors);
                }
            }
        }
    }

    private static void parseRegisteredExecutionComponents(Element extensionElement, HashMap testTypeMap, IExecutionComponentFactory factory) throws ClassNotFoundException {
        String type = extensionElement.getAttribute("type");
        String executionComponentName = extensionElement.getAttribute("name");
        factory.addExecutionComponent(executionComponentName, extensionElement.getAttribute("implClass"));
        factory.addStub(executionComponentName, extensionElement.getAttribute("stubClass"));
        factory.addSkeleton(executionComponentName, extensionElement.getAttribute("skeletonClass"));
        Object map = testTypeMap.get(type);
        if (map == null) {
            map = new HashMap();
            testTypeMap.put(type, map);
        }
        HashMap execCompMap = (HashMap)map;
        NodeList supportedTestTypes = XMLUtil.getChildrenByName(extensionElement, "SupportedTestType");
        for (int j = 0; j < supportedTestTypes.getLength(); ++j) {
            if (!(supportedTestTypes.item(j) instanceof Element)) continue;
            Element supportedType = (Element)supportedTestTypes.item(j);
            execCompMap.put(supportedType.getAttribute("name"), executionComponentName);
        }
    }

    private static void parseAdapters(Element adapterElement, HashMap testTypeMap, String type) throws ClassNotFoundException {
        String adapterClass = adapterElement.getAttribute("class");
        Object map = testTypeMap.get(type);
        if (map == null) {
            map = new HashMap();
            testTypeMap.put(type, map);
        }
        HashMap execCompMap = (HashMap)map;
        NodeList supportedTestTypes = XMLUtil.getChildrenByName(adapterElement, "SupportedTestType");
        for (int j = 0; j < supportedTestTypes.getLength(); ++j) {
            if (!(supportedTestTypes.item(j) instanceof Element)) continue;
            Element supportedType = (Element)supportedTestTypes.item(j);
            execCompMap.put(supportedType.getAttribute("name"), adapterClass);
        }
    }

    private static void parseDataProcessors(Element dataProcessorElement, ArrayList dataProcessorCollection) {
        String adapterClass = dataProcessorElement.getAttribute("class");
        try {
            dataProcessorCollection.add(Class.forName(adapterClass));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String[] getConfigFilesFromConfigDir(String configDir) {
        File configDirFile = new File(configDir);
        if (!configDirFile.isDirectory()) {
            return null;
        }
        configDir = configDirFile.getAbsolutePath();
        configDirFile = new File(configDir = configDir + File.separator + "plugins");
        if (!configDirFile.isDirectory()) {
            return null;
        }
        ArrayList<String> pluginPaths = new ArrayList<String>();
        String[] elements = configDirFile.list();
        for (int i = 0; i < elements.length; ++i) {
            String element = configDir + File.separator + elements[i];
            File elementFile = new File(element);
            if (!elementFile.isDirectory() || !(elementFile = new File(element = element + File.separator + "plugin.xml")).exists()) continue;
            pluginPaths.add(element);
        }
        return pluginPaths.toArray(new String[0]);
    }

    public static String getHarnessDir(String configDir, String version) {
        File configDirFile = new File(configDir);
        if (!configDirFile.isDirectory()) {
            return null;
        }
        configDir = configDirFile.getAbsolutePath();
        String harnessDir = configDir + File.separator + "plugins" + File.separator + "org.eclipse.hyades.execution.harness" + "_" + version;
        File harnessFile = new File(harnessDir);
        if (harnessFile.isDirectory()) {
            return harnessDir;
        }
        return null;
    }
}

