/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.harness.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.hyades.execution.harness.util.ISystemUtility;

public class StandaloneSystemUtility
implements ISystemUtility {
    private ResourceBundle bundle;
    private String harnessDir;
    private String localizedBundleJar;

    public StandaloneSystemUtility(String harnessDir) {
        this.harnessDir = harnessDir;
        if (harnessDir.charAt(harnessDir.length() - 1) == '/') {
            this.localizedBundleJar = harnessDir.substring(0, harnessDir.length() - 2);
        } else {
            this.harnessDir = this.harnessDir + '/';
            this.localizedBundleJar = harnessDir;
        }
        this.localizedBundleJar = this.localizedBundleJar + ".nl1/nl1.jar";
    }

    public ResourceBundle getResourceBundle() {
        return this.getResourceBundle(Locale.getDefault());
    }

    public ResourceBundle getResourceBundle(Locale targetLocale) {
        if (this.bundle != null) {
            return this.bundle;
        }
        ResourceBundle newBundle = null;
        try {
            URL[] newcp = new URL[]{new URL("file", "", this.harnessDir), new URL("file", "", this.localizedBundleJar)};
            URLClassLoader resourceLoader = new URLClassLoader(newcp, null);
            this.bundle = newBundle = ResourceBundle.getBundle("plugin", targetLocale, resourceLoader);
        }
        catch (MalformedURLException exc) {
            this.logError(exc);
            return null;
        }
        catch (MissingResourceException exc) {
            this.logError(exc);
            return null;
        }
        return newBundle;
    }

    public String getString(String key) {
        ResourceBundle bundle = this.getResourceBundle();
        if (bundle == null) {
            return key;
        }
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public void logError(Throwable exc) {
        System.out.println(exc.getMessage());
    }
}

