/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import org.eclipse.hyades.test.ui.internal.editor.form.base.FormSection;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.IForm;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.JFacePreferences;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.actions.ActionFactory;

public abstract class AbstractForm
implements IForm,
IPropertyChangeListener {
    protected FormWidgetFactory factory = new FormWidgetFactory();
    protected Color headingBackground;
    protected Color headingForeground;
    protected boolean headingVisible = true;
    protected Image headingImage;
    protected String headingText;
    protected Font titleFont = JFaceResources.getHeaderFont();
    private IPropertyChangeListener hyperlinkColorListener;

    public AbstractForm() {
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        IPreferenceStore pstore = JFacePreferences.getPreferenceStore();
        this.hyperlinkColorListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (e.getProperty().equals("HYPERLINK_COLOR") || e.getProperty().equals("ACTIVE_HYPERLINK_COLOR")) {
                    AbstractForm.this.updateHyperlinkColors();
                }
            }
        };
        pstore.addPropertyChangeListener(this.hyperlinkColorListener);
    }

    protected void updateHyperlinkColors() {
        this.factory.updateHyperlinkColors();
    }

    public void commitChanges(boolean onSave) {
    }

    public abstract Control createControl(Composite var1);

    public void dispose() {
        this.factory.dispose();
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        IPreferenceStore pstore = JFacePreferences.getPreferenceStore();
        pstore.removePropertyChangeListener((IPropertyChangeListener)this);
        pstore.removePropertyChangeListener(this.hyperlinkColorListener);
    }

    public boolean doGlobalAction(String actionId) {
        return false;
    }

    public void expandTo(Object object) {
    }

    public abstract Control getControl();

    public FormWidgetFactory getFactory() {
        return this.factory;
    }

    public Color getHeadingBackground() {
        return this.headingBackground;
    }

    public Color getHeadingForeground() {
        return this.headingForeground;
    }

    public Image getHeadingImage() {
        return this.headingImage;
    }

    public String getHeadingText() {
        if (this.headingText == null) {
            return "";
        }
        return this.headingText;
    }

    public void initialize(Object model) {
    }

    public boolean isHeadingVisible() {
        return this.headingVisible;
    }

    public void registerSection(FormSection section) {
    }

    public void setFocus() {
    }

    public void setHeadingBackground(Color newHeadingBackground) {
        this.headingBackground = newHeadingBackground;
    }

    public void setHeadingForeground(Color newHeadingForeground) {
        this.headingForeground = newHeadingForeground;
    }

    public void setHeadingImage(Image headingImage) {
        this.headingImage = headingImage;
    }

    public void setHeadingVisible(boolean newHeadingVisible) {
        this.headingVisible = newHeadingVisible;
    }

    public void setHeadingText(String headingText) {
        this.headingText = headingText;
    }

    public void update() {
    }

    protected boolean canPerformDirectly(String id, Control control) {
        if (control instanceof Text) {
            Text text = (Text)control;
            if (id.equals(ActionFactory.CUT.getId())) {
                text.cut();
                return true;
            }
            if (id.equals(ActionFactory.COPY.getId())) {
                text.copy();
                return true;
            }
            if (id.equals(ActionFactory.PASTE.getId())) {
                text.paste();
                return true;
            }
            if (id.equals(ActionFactory.SELECT_ALL.getId())) {
                text.selectAll();
                return true;
            }
            if (id.equals(ActionFactory.DELETE.getId())) {
                int count = text.getSelectionCount();
                if (count == 0) {
                    int caretPos = text.getCaretPosition();
                    text.setSelection(caretPos, caretPos + 1);
                }
                text.insert("");
                return true;
            }
        }
        return false;
    }
}

