/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.EditorSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.PageBook;

public class DetailSection
extends EditorSection {
    private PageBook pageBook;
    private Map pageByType;
    private Map controlByPage;
    private Composite defaultControl;
    private Object input;

    public DetailSection(EditorForm editorForm) {
        super(editorForm);
        this.setCollapsable(true);
        this.pageByType = new HashMap();
        this.controlByPage = new HashMap();
    }

    public void dispose() {
        this.input = null;
        this.pageByType.clear();
        this.controlByPage.clear();
        super.dispose();
    }

    public void add(Class type, DetailPage detailPage) {
        if (!this.controlByPage.isEmpty()) {
            return;
        }
        detailPage.setDetailSection(this);
        this.pageByType.put(type, detailPage);
    }

    public void remove(Class type) {
        if (!this.controlByPage.isEmpty()) {
            return;
        }
        this.pageByType.remove(type);
    }

    public boolean isEmpty() {
        return this.pageByType.isEmpty();
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        WidgetFactory widgetFactory = this.getEditorForm().getWidgetFactory();
        Composite composite = widgetFactory.createComposite(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)GridDataUtil.createFill());
        this.pageBook = new PageBook(composite, 0);
        this.pageBook.setLayoutData((Object)GridDataUtil.createFill());
        this.pageBook.setBackground(widgetFactory.getBackgroundColor());
        this.pageBook.addMouseListener((MouseListener)new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                ((Control)e.widget).setFocus();
            }
        });
        this.pageBook.setMenu(parent.getMenu());
        this.defaultControl = widgetFactory.createComposite((Composite)this.pageBook);
        this.defaultControl.setLayout((Layout)new GridLayout());
        this.defaultControl.setLayoutData((Object)GridDataUtil.createFill());
        Label label = widgetFactory.createLabel(this.defaultControl, TestUIPlugin.getString("NO_DETAILS"));
        GridData gridData = GridDataUtil.createHorizontalFill();
        gridData.verticalAlignment = 2;
        label.setLayoutData((Object)gridData);
        int maxHeight = 0;
        Iterator i = this.pageByType.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            DetailPage detailPage = (DetailPage)entry.getValue();
            Control control = detailPage.createControl((Composite)this.pageBook, widgetFactory);
            control.setLayoutData((Object)GridDataUtil.createFill());
            this.controlByPage.put(detailPage, control);
            int height = control.computeSize((int)-1, (int)-1, (boolean)true).y;
            if (height <= maxHeight) continue;
            maxHeight = height;
        }
        ((GridData)this.pageBook.getLayoutData()).heightHint = maxHeight;
        this.pageBook.layout(true);
        return composite;
    }

    public void setInput(Object object) {
        this.input = object;
        DetailPage detailPage = this.getDetailPage(object);
        if (detailPage == null) {
            this.pageBook.showPage((Control)this.defaultControl);
        } else {
            detailPage.setInput(this.input);
            this.pageBook.showPage((Control)this.controlByPage.get(detailPage));
        }
    }

    public Object getInput() {
        return this.input;
    }

    public IStructuredSelection getStructuredSelection() {
        DetailPage detailPage = this.getDetailPage(this.input);
        if (detailPage == null) {
            return StructuredSelection.EMPTY;
        }
        return detailPage.getStructuredSelection();
    }

    public void selectReveal(ISelection selection) {
        DetailPage detailPage = this.getDetailPage(this.input);
        if (detailPage != null) {
            detailPage.selectReveal(selection);
        }
    }

    protected DetailPage getDetailPage(Object input) {
        if (input != null) {
            if (input instanceof IStructuredSelection) {
                input = ((IStructuredSelection)input).getFirstElement();
            }
            Iterator i = this.pageByType.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                if (!((Class)entry.getKey()).isInstance(input)) continue;
                return (DetailPage)entry.getValue();
            }
        }
        return null;
    }

    public static class DetailPage
    implements VerifyKeyListener,
    IDisposable {
        private DetailSection detailSection;

        public void dispose() {
            this.detailSection = null;
        }

        public Control createControl(Composite parent, FormWidgetFactory factory) {
            return null;
        }

        public void setDetailSection(DetailSection detailSection) {
            this.detailSection = detailSection;
        }

        protected EditorForm getEditorForm() {
            return this.getDetailSection().getEditorForm();
        }

        protected DetailSection getDetailSection() {
            return this.detailSection;
        }

        public void setInput(Object object) {
        }

        public Object getInput() {
            return null;
        }

        public IStructuredSelection getStructuredSelection() {
            if (this.getInput() == null) {
                return StructuredSelection.EMPTY;
            }
            return new StructuredSelection(this.getInput());
        }

        public void selectReveal(ISelection selection) {
        }

        public boolean isReadOnly() {
            return this.getDetailSection().isReadOnly();
        }

        public void verifyKey(VerifyEvent event) {
            this.getDetailSection().verifyKey(event);
        }
    }
}

