/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.model.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.jface.viewers.ILabelProvider;

public class VolatileTypes {
    private static VolatileTypes instance;
    private Map volatileTypes = new HashMap();

    public static VolatileTypes getInstance() {
        if (instance == null) {
            instance = new VolatileTypes();
        }
        return instance;
    }

    private VolatileTypes() {
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(TestUIPlugin.getID() + ".testNavigatorVolatileType");
        if (extPoint != null) {
            IConfigurationElement[] members = extPoint.getConfigurationElements();
            for (int i = 0; i < members.length; ++i) {
                IConfigurationElement element;
                String typeName;
                if (members[i].getName() == null || (typeName = (element = members[i]).getAttribute("targetType")) == null || typeName.length() == 0) continue;
                this.addVolatileType(typeName, element);
            }
        }
    }

    public boolean isVolatile(String type) {
        return this.volatileTypes.containsKey(type);
    }

    public VolatileElementInfo getVolatileElementInfo(IFile file) {
        try {
            boolean isVolatile;
            IMarker[] markers = file.findMarkers("org.eclipse.hyades.test.ui.volatileMarker", false, 0);
            if (markers.length > 0) {
                String uri = markers[0].getAttribute("uri", null);
                String type = markers[0].getAttribute("type", null);
                return new VolatileElementInfo(uri == null ? null : URI.createURI((String)uri), type);
            }
            EObject[] eObjects = EMFUtil.load(null, file);
            String type = "";
            String extension = file.getFileExtension();
            if (extension.equals("execution")) {
                if (eObjects.length > 0 && eObjects[0] instanceof TPFExecutionResult) {
                    type = ((TPFExecutionResult)eObjects[0]).getType();
                }
            } else if (extension.equals("testsuite") && eObjects.length > 0 && eObjects[0] instanceof TPFTestSuite) {
                type = ((TPFTestSuite)eObjects[0]).getType();
            }
            if (isVolatile = this.isVolatile(type)) {
                class UpdateMarkerJob
                extends Job {
                    private IFile _file;
                    private EObject eObject = null;
                    private String type = null;

                    public UpdateMarkerJob(IFile _file, EObject eObject, String type) {
                        super("update marker for file proxy");
                        this._file = _file;
                        this.eObject = eObject;
                        this.type = type;
                    }

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            IMarker marker = this._file.createMarker("org.eclipse.hyades.test.ui.volatileMarker");
                            URI uri = EcoreUtil.getURI((EObject)this.eObject);
                            marker.setAttribute("uri", (Object)uri.toString());
                            marker.setAttribute("type", (Object)this.type);
                            return new Status(0, TestUIPlugin.getID(), 0, "ok", null);
                        }
                        catch (CoreException e) {
                            TestUIPlugin.logError(e);
                            return new Status(4, TestUIPlugin.getID(), 0, "unable to update marker for file: " + this._file.getName(), (Throwable)e);
                        }
                    }
                }
                UpdateMarkerJob job = new UpdateMarkerJob(file, eObjects[0], type);
                job.setRule((ISchedulingRule)file);
                job.schedule();
                eObjects[0].eResource().unload();
                URI uri = EcoreUtil.getURI((EObject)eObjects[0]);
                return new VolatileElementInfo(uri, type);
            }
            return new VolatileElementInfo(null, "");
        }
        catch (CoreException e) {
            TestUIPlugin.logError(e);
            return new VolatileElementInfo(null, "");
        }
    }

    public void addVolatileType(String typeName, IConfigurationElement element) {
        if (!this.volatileTypes.containsKey(typeName)) {
            this.volatileTypes.put(typeName, element);
        }
    }

    public ILabelProvider getProvider(String type) {
        ILabelProvider provider = null;
        if (this.volatileTypes.containsKey(type)) {
            Object value = this.volatileTypes.get(type);
            if (value instanceof IConfigurationElement) {
                IConfigurationElement element = (IConfigurationElement)value;
                try {
                    provider = (ILabelProvider)element.createExecutableExtension("provider");
                    this.volatileTypes.put(type, provider);
                }
                catch (CoreException e) {
                    provider = null;
                }
            } else if (value instanceof ILabelProvider) {
                provider = (ILabelProvider)value;
            }
        }
        return provider;
    }

    public static class VolatileElementInfo {
        private URI uri;
        private String type;

        public VolatileElementInfo(URI uri, String type) {
            this.uri = uri;
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public URI getURI() {
            return this.uri;
        }
    }
}

