/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.action;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionType;
import org.eclipse.hyades.models.common.testprofile.TPFTypedEvent;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.launch.processes.TestExecutionProcess;
import org.eclipse.hyades.ui.internal.util.StringUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.help.WorkbenchHelp;

public class StopAction
extends Action
implements IDisposable {
    private IStructuredSelection structuredSelection;
    private TestExecutionProcess executionProcess;

    public StopAction() {
        super(TestUIPlugin.getString("STOP_TEXT"));
        WorkbenchHelp.setHelp((IAction)this, (String)(TestUIPlugin.getID() + ".enav0008"));
    }

    public void dispose() {
        this.structuredSelection = null;
    }

    protected IStructuredSelection getStructuredSelection() {
        return this.structuredSelection;
    }

    public void selectionChanged(IStructuredSelection structuredSelection) {
        this.structuredSelection = structuredSelection;
    }

    private boolean isSameObject(EObject obj1, EObject obj2) {
        URI uri1 = obj1 != null ? EcoreUtil.getURI((EObject)obj1) : null;
        URI uri2 = obj2 != null ? EcoreUtil.getURI((EObject)obj2) : null;
        return uri1 != null && uri1.equals((Object)uri2);
    }

    private TestExecutionProcess getExecutionProcess(TPFExecutionResult execResult) {
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        for (int i = 0; i < launches.length; ++i) {
            IProcess[] processes = launches[i].getProcesses();
            for (int j = 0; j < processes.length; ++j) {
                TestExecutionProcess process;
                if (!(processes[j] instanceof TestExecutionProcess) || !this.isSameObject((EObject)execResult, (EObject)(process = (TestExecutionProcess)processes[j]).getExecutionResult())) continue;
                return process;
            }
        }
        return null;
    }

    public void run() {
        Object object;
        IStructuredSelection selection = this.getStructuredSelection();
        if (selection != null && !selection.isEmpty() && (object = selection.getFirstElement()) instanceof TPFExecutionResult) {
            TPFExecutionResult execResult = (TPFExecutionResult)object;
            if (this.executionProcess != null) {
                try {
                    this.executionProcess.terminate();
                }
                catch (DebugException e) {
                    TPFDeployment deployment = execResult.getDeployment();
                    String errMsg = TestUIPlugin.getString("STOP_FAIL_TEXT");
                    errMsg = StringUtil.replace((String)errMsg, (String)"%1", (String)deployment.getName());
                    IStatus err1 = e.getStatus();
                    ErrorDialog.openError(null, (String)TestUIPlugin.getString("TEST_ERR_MSG"), (String)errMsg, (IStatus)err1);
                }
            }
        }
        this.structuredSelection = null;
    }

    public boolean isApplicableForSelection() {
        if (this.structuredSelection == null || this.structuredSelection.size() != 1) {
            return false;
        }
        Object selection = this.structuredSelection.getFirstElement();
        return selection instanceof TPFExecutionResult;
    }

    public boolean isApplicableForEnablement() {
        if (this.structuredSelection == null || this.structuredSelection.size() != 1) {
            return false;
        }
        Object selection = this.structuredSelection.getFirstElement();
        if (selection instanceof TPFExecutionResult) {
            TPFTypedEvent execEvent;
            TPFExecutionType type;
            Object obj;
            TPFExecutionResult execResult = (TPFExecutionResult)selection;
            TPFExecutionHistory execHistory = execResult.getExecutionHistory();
            EList execEvents = execHistory.getExecutionEvents();
            if (execEvents.size() > 0 && (obj = execEvents.get(execEvents.size() - 1)) instanceof TPFTypedEvent && (type = (execEvent = (TPFTypedEvent)obj).getType()).getValue() == 1) {
                return false;
            }
            this.executionProcess = this.getExecutionProcess((TPFExecutionResult)selection);
            return this.executionProcess != null && !this.executionProcess.isTerminated();
        }
        return false;
    }
}

